/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionType;
import co.cask.tephra.distributed.thrift.TTransaction;
import co.cask.tephra.distributed.thrift.TTransactionType;
import co.cask.tephra.distributed.thrift.TVisibilityLevel;
import com.google.common.primitives.Longs;

public final class TransactionConverterUtils {
    public static TTransaction wrap(Transaction tx) {
        return new TTransaction(tx.getTransactionId(), tx.getReadPointer(), Longs.asList((long[])tx.getInvalids()), Longs.asList((long[])tx.getInProgress()), tx.getFirstShortInProgress(), TransactionConverterUtils.getTTransactionType(tx.getType()), tx.getWritePointer(), Longs.asList((long[])tx.getCheckpointWritePointers()), TransactionConverterUtils.getTVisibilityLevel(tx.getVisibilityLevel()));
    }

    public static Transaction unwrap(TTransaction thriftTx) {
        return new Transaction(thriftTx.getReadPointer(), thriftTx.getTransactionId(), thriftTx.getWritePointer(), Longs.toArray(thriftTx.getInvalids()), Longs.toArray(thriftTx.getInProgress()), thriftTx.getFirstShort(), TransactionConverterUtils.getTransactionType(thriftTx.getType()), Longs.toArray(thriftTx.getCheckpointWritePointers()), TransactionConverterUtils.getVisibilityLevel(thriftTx.getVisibilityLevel()));
    }

    private static TransactionType getTransactionType(TTransactionType tType) {
        return tType == TTransactionType.SHORT ? TransactionType.SHORT : TransactionType.LONG;
    }

    private static TTransactionType getTTransactionType(TransactionType type) {
        return type == TransactionType.SHORT ? TTransactionType.SHORT : TTransactionType.LONG;
    }

    private static Transaction.VisibilityLevel getVisibilityLevel(TVisibilityLevel tLevel) {
        switch (tLevel) {
            case SNAPSHOT: {
                return Transaction.VisibilityLevel.SNAPSHOT;
            }
            case SNAPSHOT_EXCLUDE_CURRENT: {
                return Transaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT;
            }
        }
        throw new IllegalArgumentException("Unknown TVisibilityLevel: " + (Object)((Object)tLevel));
    }

    private static TVisibilityLevel getTVisibilityLevel(Transaction.VisibilityLevel level) {
        switch (level) {
            case SNAPSHOT: {
                return TVisibilityLevel.SNAPSHOT;
            }
            case SNAPSHOT_EXCLUDE_CURRENT: {
                return TVisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT;
            }
        }
        throw new IllegalArgumentException("Unknown VisibilityLevel: " + level);
    }
}

