/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.KillableContainer;
import org.apache.hadoop.yarn.util.resource.Resources;

public class PreemptableQueue {
    private Map<String, Resource> totalKillableResources = new HashMap<String, Resource>();
    private Map<String, Map<ContainerId, RMContainer>> killableContainers = new HashMap<String, Map<ContainerId, RMContainer>>();
    private PreemptableQueue parent;

    public PreemptableQueue(PreemptableQueue parent) {
        this.parent = parent;
    }

    public PreemptableQueue(Map<String, Resource> totalKillableResources, Map<String, Map<ContainerId, RMContainer>> killableContainers) {
        this.totalKillableResources = totalKillableResources;
        this.killableContainers = killableContainers;
    }

    void addKillableContainer(KillableContainer container) {
        String partition = container.getNodePartition();
        if (!this.totalKillableResources.containsKey(partition)) {
            this.totalKillableResources.put(partition, Resources.createResource((int)0));
            this.killableContainers.put(partition, new ConcurrentSkipListMap());
        }
        RMContainer c = container.getRMContainer();
        Resources.addTo((Resource)this.totalKillableResources.get(partition), (Resource)c.getAllocatedResource());
        this.killableContainers.get(partition).put(c.getContainerId(), c);
        if (null != this.parent) {
            this.parent.addKillableContainer(container);
        }
    }

    void removeKillableContainer(KillableContainer container) {
        RMContainer rmContainer;
        String partition = container.getNodePartition();
        Map<ContainerId, RMContainer> partitionKillableContainers = this.killableContainers.get(partition);
        if (partitionKillableContainers != null && null != (rmContainer = partitionKillableContainers.remove(container.getRMContainer().getContainerId()))) {
            Resources.subtractFrom((Resource)this.totalKillableResources.get(partition), (Resource)rmContainer.getAllocatedResource());
        }
        if (null != this.parent) {
            this.parent.removeKillableContainer(container);
        }
    }

    public Resource getKillableResource(String partition) {
        Resource res = this.totalKillableResources.get(partition);
        return res == null ? Resources.none() : res;
    }

    public Map<String, Map<ContainerId, RMContainer>> getKillableContainers() {
        return this.killableContainers;
    }

    Map<String, Resource> getTotalKillableResources() {
        return this.totalKillableResources;
    }
}

