/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ConfigurationMutationACLPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;

public class QueueAdminConfigurationMutationACLPolicy
implements ConfigurationMutationACLPolicy {
    private Configuration conf;
    private RMContext rmContext;
    private YarnAuthorizationProvider authorizer;

    @Override
    public void init(Configuration config, RMContext context) {
        this.conf = config;
        this.rmContext = context;
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)this.conf);
    }

    @Override
    public boolean isMutationAllowed(UserGroupInformation user, SchedConfUpdateInfo confUpdate) {
        HashMap globalParams = confUpdate.getGlobalParams();
        if (globalParams != null && globalParams.size() != 0 && !this.authorizer.isAdmin(user)) {
            return false;
        }
        HashSet<String> queues = new HashSet<String>();
        for (QueueConfigInfo addQueueInfo : confUpdate.getAddQueueInfo()) {
            queues.add(addQueueInfo.getQueue());
        }
        for (String removeQueue : confUpdate.getRemoveQueueInfo()) {
            queues.add(removeQueue);
        }
        for (QueueConfigInfo updateQueueInfo : confUpdate.getUpdateQueueInfo()) {
            queues.add(updateQueueInfo.getQueue());
        }
        for (String queuePath : queues) {
            String queueName = queuePath.lastIndexOf(46) != -1 ? queuePath.substring(queuePath.lastIndexOf(46) + 1) : queuePath;
            QueueInfo queueInfo = null;
            try {
                queueInfo = this.rmContext.getScheduler().getQueueInfo(queueName, false, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String parentPath = queuePath;
            while (queueInfo == null) {
                String parentName = (parentPath = parentPath.substring(0, parentPath.lastIndexOf(46))).lastIndexOf(46) != -1 ? parentPath.substring(parentPath.lastIndexOf(46) + 1) : parentPath;
                try {
                    queueInfo = this.rmContext.getScheduler().getQueueInfo(parentName, false, false);
                }
                catch (IOException iOException) {}
            }
            Queue queue = ((MutableConfScheduler)this.rmContext.getScheduler()).getQueue(queueInfo.getQueueName());
            if (queue == null || queue.hasAccess(QueueACL.ADMINISTER_QUEUE, user)) continue;
            return false;
        }
        return true;
    }
}

