/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.Epoch;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.AMRMTokenSecretManagerStatePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.EpochPBImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemRMStateStore
extends RMStateStore {
    public static final Log LOG = LogFactory.getLog(FileSystemRMStateStore.class);
    protected static final String ROOT_DIR_NAME = "FSRMStateRoot";
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)2);
    protected static final String AMRMTOKEN_SECRET_MANAGER_NODE = "AMRMTokenSecretManagerNode";
    private static final String UNREADABLE_BY_SUPERUSER_XATTRIB = "security.hdfs.unreadable.by.superuser";
    protected FileSystem fs;
    private Path rootDirPath;
    @InterfaceAudience.Private
    @VisibleForTesting
    Path rmDTSecretManagerRoot;
    private Path rmAppRoot;
    private Path dtSequenceNumberPath = null;
    private int fsNumRetries;
    private long fsRetryInterval;
    private boolean intermediateEncryptionEnabled = YarnConfiguration.DEFAULT_YARN_INTERMEDIATE_DATA_ENCRYPTION;
    @VisibleForTesting
    Path fsWorkingPath;
    Path amrmTokenSecretManagerRoot;

    @Override
    public synchronized void initInternal(Configuration conf) throws Exception {
        this.fsWorkingPath = new Path(conf.get("yarn.resourcemanager.fs.state-store.uri"));
        this.rootDirPath = new Path(this.fsWorkingPath, ROOT_DIR_NAME);
        this.rmDTSecretManagerRoot = new Path(this.rootDirPath, "RMDTSecretManagerRoot");
        this.rmAppRoot = new Path(this.rootDirPath, "RMAppRoot");
        this.amrmTokenSecretManagerRoot = new Path(this.rootDirPath, "AMRMTokenSecretManagerRoot");
        this.fsNumRetries = conf.getInt("yarn.resourcemanager.fs.state-store.num-retries", 0);
        this.fsRetryInterval = conf.getLong("yarn.resourcemanager.fs.state-store.retry-interval-ms", 1000L);
        this.intermediateEncryptionEnabled = conf.getBoolean("yarn.intermediate-data-encryption.enable", YarnConfiguration.DEFAULT_YARN_INTERMEDIATE_DATA_ENCRYPTION.booleanValue());
    }

    @Override
    protected synchronized void startInternal() throws Exception {
        Configuration conf = new Configuration(this.getConfig());
        conf.setBoolean("dfs.client.retry.policy.enabled", true);
        String retryPolicy = conf.get("yarn.resourcemanager.fs.state-store.retry-policy-spec", "2000, 500");
        conf.set("dfs.client.retry.policy.spec", retryPolicy);
        this.fs = this.fsWorkingPath.getFileSystem(conf);
        this.mkdirsWithRetries(this.rmDTSecretManagerRoot);
        this.mkdirsWithRetries(this.rmAppRoot);
        this.mkdirsWithRetries(this.amrmTokenSecretManagerRoot);
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
        this.closeWithRetries();
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    protected synchronized Version loadVersion() throws Exception {
        Path versionNodePath = this.getNodePath(this.rootDirPath, "RMVersionNode");
        FileStatus status = this.getFileStatusWithRetries(versionNodePath);
        if (status != null) {
            byte[] data = this.readFileWithRetries(versionNodePath, status.getLen());
            VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
            return version;
        }
        return null;
    }

    @Override
    protected synchronized void storeVersion() throws Exception {
        Path versionNodePath = this.getNodePath(this.rootDirPath, "RMVersionNode");
        byte[] data = ((VersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        if (this.existsWithRetries(versionNodePath)) {
            this.updateFile(versionNodePath, data, false);
        } else {
            this.writeFileWithRetries(versionNodePath, data, false);
        }
    }

    @Override
    public synchronized long getAndIncrementEpoch() throws Exception {
        Path epochNodePath = this.getNodePath(this.rootDirPath, "EpochNode");
        long currentEpoch = 0L;
        FileStatus status = this.getFileStatusWithRetries(epochNodePath);
        if (status != null) {
            byte[] data = this.readFileWithRetries(epochNodePath, status.getLen());
            EpochPBImpl epoch = new EpochPBImpl(YarnServerResourceManagerRecoveryProtos.EpochProto.parseFrom(data));
            currentEpoch = ((Epoch)epoch).getEpoch();
            byte[] storeData = Epoch.newInstance(currentEpoch + 1L).getProto().toByteArray();
            this.updateFile(epochNodePath, storeData, false);
        } else {
            byte[] storeData = Epoch.newInstance(currentEpoch + 1L).getProto().toByteArray();
            this.writeFileWithRetries(epochNodePath, storeData, false);
        }
        return currentEpoch;
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMAppState(rmState);
        this.loadAMRMTokenSecretManagerState(rmState);
        return rmState;
    }

    private void loadAMRMTokenSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        this.checkAndResumeUpdateOperation(this.amrmTokenSecretManagerRoot);
        Path amrmTokenSecretManagerStateDataDir = new Path(this.amrmTokenSecretManagerRoot, AMRMTOKEN_SECRET_MANAGER_NODE);
        FileStatus status = this.getFileStatusWithRetries(amrmTokenSecretManagerStateDataDir);
        if (status == null) {
            return;
        }
        assert (status.isFile());
        byte[] data = this.readFileWithRetries(amrmTokenSecretManagerStateDataDir, status.getLen());
        AMRMTokenSecretManagerStatePBImpl stateData = new AMRMTokenSecretManagerStatePBImpl(YarnServerResourceManagerRecoveryProtos.AMRMTokenSecretManagerStateProto.parseFrom(data));
        rmState.amrmTokenSecretManagerState = AMRMTokenSecretManagerState.newInstance(stateData.getCurrentMasterKey(), stateData.getNextMasterKey());
    }

    private void loadRMAppState(RMStateStore.RMState rmState) throws Exception {
        try {
            ArrayList<ApplicationAttemptStateDataPBImpl> attempts = new ArrayList<ApplicationAttemptStateDataPBImpl>();
            for (FileStatus appDir : this.listStatusWithRetries(this.rmAppRoot)) {
                this.checkAndResumeUpdateOperation(appDir.getPath());
                for (FileStatus childNodeStatus : this.listStatusWithRetries(appDir.getPath())) {
                    assert (childNodeStatus.isFile());
                    String childNodeName = childNodeStatus.getPath().getName();
                    if (this.checkAndRemovePartialRecordWithRetries(childNodeStatus.getPath())) continue;
                    byte[] childData = this.readFileWithRetries(childNodeStatus.getPath(), childNodeStatus.getLen());
                    this.setUnreadableBySuperuserXattrib(childNodeStatus.getPath());
                    if (childNodeName.startsWith("application_")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Loading application from node: " + childNodeName));
                        }
                        ApplicationStateDataPBImpl appState = new ApplicationStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto.parseFrom(childData));
                        ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
                        rmState.appState.put(appId, appState);
                        continue;
                    }
                    if (childNodeName.startsWith("appattempt_")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Loading application attempt from node: " + childNodeName));
                        }
                        ApplicationAttemptStateDataPBImpl attemptState = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.parseFrom(childData));
                        attempts.add(attemptState);
                        continue;
                    }
                    LOG.info((Object)("Unknown child node with name: " + childNodeName));
                }
            }
            for (ApplicationAttemptStateData applicationAttemptStateData : attempts) {
                ApplicationId appId = applicationAttemptStateData.getAttemptId().getApplicationId();
                ApplicationStateData appState = rmState.appState.get(appId);
                assert (appState != null);
                appState.attempts.put(applicationAttemptStateData.getAttemptId(), applicationAttemptStateData);
            }
            LOG.info((Object)"Done loading applications from FS state store");
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to load state.", (Throwable)e);
            throw e;
        }
    }

    private boolean checkAndRemovePartialRecord(Path record) throws IOException {
        if (record.getName().endsWith(".tmp")) {
            LOG.error((Object)("incomplete rm state store entry found :" + record));
            this.fs.delete(record, false);
            return true;
        }
        return false;
    }

    private void checkAndResumeUpdateOperation(Path path) throws Exception {
        FileStatus[] newChildNodes;
        for (FileStatus newChildNodeStatus : newChildNodes = this.listStatusWithRetries(path, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().endsWith(".new");
            }
        })) {
            assert (newChildNodeStatus.isFile());
            String newChildNodeName = newChildNodeStatus.getPath().getName();
            String childNodeName = newChildNodeName.substring(0, newChildNodeName.length() - ".new".length());
            Path childNodePath = new Path(newChildNodeStatus.getPath().getParent(), childNodeName);
            this.replaceFile(newChildNodeStatus.getPath(), childNodePath);
        }
    }

    private void loadRMDTSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        FileStatus[] childNodes;
        this.checkAndResumeUpdateOperation(this.rmDTSecretManagerRoot);
        for (FileStatus childNodeStatus : childNodes = this.listStatusWithRetries(this.rmDTSecretManagerRoot)) {
            assert (childNodeStatus.isFile());
            String childNodeName = childNodeStatus.getPath().getName();
            if (this.checkAndRemovePartialRecordWithRetries(childNodeStatus.getPath())) continue;
            if (childNodeName.startsWith("RMDTSequenceNumber_")) {
                rmState.rmSecretManagerState.dtSequenceNumber = Integer.parseInt(childNodeName.split("_")[1]);
                continue;
            }
            Path childNodePath = this.getNodePath(this.rmDTSecretManagerRoot, childNodeName);
            byte[] childData = this.readFileWithRetries(childNodePath, childNodeStatus.getLen());
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            try (DataInputStream fsIn = new DataInputStream(is);){
                if (childNodeName.startsWith("DelegationKey_")) {
                    DelegationKey key = new DelegationKey();
                    key.readFields((DataInput)fsIn);
                    rmState.rmSecretManagerState.masterKeyState.add(key);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Loaded delegation key: keyId=" + key.getKeyId() + ", expirationDate=" + key.getExpiryDate()));
                    continue;
                }
                if (childNodeName.startsWith("RMDelegationToken_")) {
                    RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData();
                    identifierData.readFields(fsIn);
                    RMDelegationTokenIdentifier identifier = identifierData.getTokenIdentifier();
                    long renewDate = identifierData.getRenewDate();
                    rmState.rmSecretManagerState.delegationTokenState.put(identifier, renewDate);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Loaded RMDelegationTokenIdentifier: " + identifier + " renewDate=" + renewDate));
                    continue;
                }
                LOG.warn((Object)"Unknown file for recovering RMDelegationTokenSecretManager");
            }
        }
    }

    @Override
    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appId);
        this.mkdirsWithRetries(appDirPath);
        Path nodeCreatePath = this.getNodePath(appDirPath, appId.toString());
        LOG.info((Object)("Storing info for app: " + appId + " at: " + nodeCreatePath));
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        try {
            this.writeFileWithRetries(nodeCreatePath, appStateData, true);
        }
        catch (Exception e) {
            LOG.info((Object)("Error storing info for app: " + appId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appId);
        Path nodeCreatePath = this.getNodePath(appDirPath, appId.toString());
        LOG.info((Object)("Updating info for app: " + appId + " at: " + nodeCreatePath));
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        try {
            this.updateFile(nodeCreatePath, appStateData, true);
        }
        catch (Exception e) {
            LOG.info((Object)("Error updating info for app: " + appId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appAttemptId.getApplicationId());
        Path nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        LOG.info((Object)("Storing info for attempt: " + appAttemptId + " at: " + nodeCreatePath));
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        try {
            this.writeFileWithRetries(nodeCreatePath, attemptStateData, true);
        }
        catch (Exception e) {
            LOG.info((Object)("Error storing info for attempt: " + appAttemptId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appAttemptId.getApplicationId());
        Path nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        LOG.info((Object)("Updating info for attempt: " + appAttemptId + " at: " + nodeCreatePath));
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        try {
            this.updateFile(nodeCreatePath, attemptStateData, true);
        }
        catch (Exception e) {
            LOG.info((Object)("Error updating info for attempt: " + appAttemptId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void removeApplicationStateInternal(ApplicationStateData appState) throws Exception {
        ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
        Path nodeRemovePath = this.getAppDir(this.rmAppRoot, appId);
        LOG.info((Object)("Removing info for app: " + appId + " at: " + nodeRemovePath));
        this.deleteFileWithRetries(nodeRemovePath);
    }

    @Override
    public synchronized void storeRMDelegationTokenState(RMDelegationTokenIdentifier identifier, Long renewDate) throws Exception {
        this.storeOrUpdateRMDelegationTokenState(identifier, renewDate, false);
    }

    @Override
    public synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier identifier) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDelegationToken_" + identifier.getSequenceNumber());
        LOG.info((Object)("Removing RMDelegationToken_" + identifier.getSequenceNumber()));
        this.deleteFileWithRetries(nodeCreatePath);
    }

    @Override
    protected synchronized void updateRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        this.storeOrUpdateRMDelegationTokenState(rmDTIdentifier, renewDate, true);
    }

    private void storeOrUpdateRMDelegationTokenState(RMDelegationTokenIdentifier identifier, Long renewDate, boolean isUpdate) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDelegationToken_" + identifier.getSequenceNumber());
        RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData((YARNDelegationTokenIdentifier)identifier, renewDate);
        if (isUpdate) {
            LOG.info((Object)("Updating RMDelegationToken_" + identifier.getSequenceNumber()));
            this.updateFile(nodeCreatePath, identifierData.toByteArray(), true);
        } else {
            LOG.info((Object)("Storing RMDelegationToken_" + identifier.getSequenceNumber()));
            this.writeFileWithRetries(nodeCreatePath, identifierData.toByteArray(), true);
            Path latestSequenceNumberPath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDTSequenceNumber_" + identifier.getSequenceNumber());
            LOG.info((Object)("Storing RMDTSequenceNumber_" + identifier.getSequenceNumber()));
            if (this.dtSequenceNumberPath == null) {
                if (!this.createFileWithRetries(latestSequenceNumberPath)) {
                    throw new Exception("Failed to create " + latestSequenceNumberPath);
                }
            } else if (!this.renameFileWithRetries(this.dtSequenceNumberPath, latestSequenceNumberPath)) {
                throw new Exception("Failed to rename " + this.dtSequenceNumberPath);
            }
            this.dtSequenceNumberPath = latestSequenceNumberPath;
        }
    }

    @Override
    public synchronized void storeRMDTMasterKeyState(DelegationKey masterKey) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "DelegationKey_" + masterKey.getKeyId());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (DataOutputStream fsOut = new DataOutputStream(os);){
            LOG.info((Object)("Storing RMDelegationKey_" + masterKey.getKeyId()));
            masterKey.write((DataOutput)fsOut);
            this.writeFileWithRetries(nodeCreatePath, os.toByteArray(), true);
        }
    }

    @Override
    public synchronized void removeRMDTMasterKeyState(DelegationKey masterKey) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "DelegationKey_" + masterKey.getKeyId());
        LOG.info((Object)("Removing RMDelegationKey_" + masterKey.getKeyId()));
        this.deleteFileWithRetries(nodeCreatePath);
    }

    @Override
    public synchronized void deleteStore() throws Exception {
        if (this.existsWithRetries(this.rootDirPath)) {
            this.deleteFileWithRetries(this.rootDirPath);
        }
    }

    private Path getAppDir(Path root, ApplicationId appId) {
        return this.getNodePath(root, appId.toString());
    }

    @VisibleForTesting
    protected Path getAppDir(ApplicationId appId) {
        return this.getAppDir(this.rmAppRoot, appId);
    }

    @VisibleForTesting
    protected Path getAppAttemptDir(ApplicationAttemptId appAttId) {
        return this.getNodePath(this.getAppDir(appAttId.getApplicationId()), appAttId.toString());
    }

    private boolean checkAndRemovePartialRecordWithRetries(final Path record) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.checkAndRemovePartialRecord(record);
            }
        }.runWithRetries();
    }

    private void mkdirsWithRetries(final Path appDirPath) throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystemRMStateStore.this.fs.mkdirs(appDirPath);
                return null;
            }
        }.runWithRetries();
    }

    private void writeFileWithRetries(final Path outputPath, final byte[] data, final boolean makeUnreadableByAdmin) throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystemRMStateStore.this.writeFile(outputPath, data, makeUnreadableByAdmin);
                return null;
            }
        }.runWithRetries();
    }

    private void deleteFileWithRetries(final Path deletePath) throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystemRMStateStore.this.deleteFile(deletePath);
                return null;
            }
        }.runWithRetries();
    }

    private boolean renameFileWithRetries(final Path src, final Path dst) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.renameFile(src, dst);
            }
        }.runWithRetries();
    }

    private boolean createFileWithRetries(final Path newFile) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.createFile(newFile);
            }
        }.runWithRetries();
    }

    private FileStatus getFileStatusWithRetries(final Path path) throws Exception {
        return (FileStatus)new FSAction<FileStatus>(){

            @Override
            public FileStatus run() throws Exception {
                return FileSystemRMStateStore.this.getFileStatus(path);
            }
        }.runWithRetries();
    }

    private boolean existsWithRetries(final Path path) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.fs.exists(path);
            }
        }.runWithRetries();
    }

    private byte[] readFileWithRetries(final Path inputPath, final long len) throws Exception {
        return (byte[])new FSAction<byte[]>(){

            @Override
            public byte[] run() throws Exception {
                return FileSystemRMStateStore.this.readFile(inputPath, len);
            }
        }.runWithRetries();
    }

    private FileStatus[] listStatusWithRetries(final Path path) throws Exception {
        return (FileStatus[])new FSAction<FileStatus[]>(){

            @Override
            public FileStatus[] run() throws Exception {
                return FileSystemRMStateStore.this.fs.listStatus(path);
            }
        }.runWithRetries();
    }

    private FileStatus[] listStatusWithRetries(final Path path, final PathFilter filter) throws Exception {
        return (FileStatus[])new FSAction<FileStatus[]>(){

            @Override
            public FileStatus[] run() throws Exception {
                return FileSystemRMStateStore.this.fs.listStatus(path, filter);
            }
        }.runWithRetries();
    }

    private void closeWithRetries() throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystemRMStateStore.this.fs.close();
                return null;
            }
        }.runWithRetries();
    }

    private void deleteFile(Path deletePath) throws Exception {
        if (!this.fs.delete(deletePath, true)) {
            throw new Exception("Failed to delete " + deletePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(Path inputPath, long len) throws Exception {
        byte[] byArray;
        FSDataInputStream fsIn = null;
        try {
            fsIn = this.fs.open(inputPath);
            byte[] data = new byte[(int)len];
            fsIn.readFully(data);
            byArray = data;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fsIn});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fsIn});
        return byArray;
    }

    private FileStatus getFileStatus(Path path) throws Exception {
        try {
            return this.fs.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(Path outputPath, byte[] data, boolean makeUnradableByAdmin) throws Exception {
        Path tempPath = new Path(outputPath.getParent(), outputPath.getName() + ".tmp");
        FSDataOutputStream fsOut = null;
        try {
            fsOut = this.fs.create(tempPath, true);
            if (makeUnradableByAdmin) {
                this.setUnreadableBySuperuserXattrib(tempPath);
            }
            fsOut.write(data);
            fsOut.close();
            fsOut = null;
            this.fs.rename(tempPath, outputPath);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fsOut});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fsOut});
    }

    protected void updateFile(Path outputPath, byte[] data, boolean makeUnradableByAdmin) throws Exception {
        Path newPath = new Path(outputPath.getParent(), outputPath.getName() + ".new");
        this.writeFileWithRetries(newPath, data, makeUnradableByAdmin);
        this.replaceFile(newPath, outputPath);
    }

    protected void replaceFile(Path srcPath, Path dstPath) throws Exception {
        if (this.existsWithRetries(dstPath)) {
            this.deleteFileWithRetries(dstPath);
        } else {
            LOG.info((Object)("File doesn't exist. Skip deleting the file " + dstPath));
        }
        this.renameFileWithRetries(srcPath, dstPath);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    boolean renameFile(Path src, Path dst) throws Exception {
        return this.fs.rename(src, dst);
    }

    private boolean createFile(Path newFile) throws Exception {
        return this.fs.createNewFile(newFile);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    Path getNodePath(Path root, String nodeName) {
        return new Path(root, nodeName);
    }

    @Override
    public synchronized void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState amrmTokenSecretManagerState, boolean isUpdate) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.amrmTokenSecretManagerRoot, AMRMTOKEN_SECRET_MANAGER_NODE);
        AMRMTokenSecretManagerState data = AMRMTokenSecretManagerState.newInstance(amrmTokenSecretManagerState);
        byte[] stateData = data.getProto().toByteArray();
        if (isUpdate) {
            this.updateFile(nodeCreatePath, stateData, true);
        } else {
            this.writeFileWithRetries(nodeCreatePath, stateData, true);
        }
    }

    @VisibleForTesting
    public int getNumRetries() {
        return this.fsNumRetries;
    }

    @VisibleForTesting
    public long getRetryInterval() {
        return this.fsRetryInterval;
    }

    private void setUnreadableBySuperuserXattrib(Path p) throws IOException {
        if (this.fs.getScheme().toLowerCase().contains("hdfs") && this.intermediateEncryptionEnabled && !this.fs.getXAttrs(p).containsKey(UNREADABLE_BY_SUPERUSER_XATTRIB)) {
            this.fs.setXAttr(p, UNREADABLE_BY_SUPERUSER_XATTRIB, null, EnumSet.of(XAttrSetFlag.CREATE));
        }
    }

    private abstract class FSAction<T> {
        private FSAction() {
        }

        abstract T run() throws Exception;

        T runWithRetries() throws Exception {
            int retry = 0;
            while (true) {
                try {
                    return this.run();
                }
                catch (IOException e) {
                    LOG.info((Object)"Exception while executing a FS operation.", (Throwable)e);
                    if (++retry > FileSystemRMStateStore.this.fsNumRetries) {
                        LOG.info((Object)"Maxed out FS retries. Giving up!");
                        throw e;
                    }
                    LOG.info((Object)("Retrying operation on FS. Retry no. " + retry));
                    Thread.sleep(FileSystemRMStateStore.this.fsRetryInterval);
                    continue;
                }
                break;
            }
        }
    }
}

