/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.column;

import java.util.Arrays;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.shade.org.apache.parquet.schema.Type;

public class ColumnDescriptor
implements Comparable<ColumnDescriptor> {
    private final String[] path;
    private final PrimitiveType type;
    private final int maxRep;
    private final int maxDef;

    @Deprecated
    public ColumnDescriptor(String[] path, PrimitiveType.PrimitiveTypeName type, int maxRep, int maxDef) {
        this(path, type, 0, maxRep, maxDef);
    }

    @Deprecated
    public ColumnDescriptor(String[] path, PrimitiveType.PrimitiveTypeName type, int typeLength, int maxRep, int maxDef) {
        this(path, new PrimitiveType(Type.Repetition.OPTIONAL, type, typeLength, ""), maxRep, maxDef);
    }

    public ColumnDescriptor(String[] path, PrimitiveType type, int maxRep, int maxDef) {
        this.path = path;
        this.type = type;
        this.maxRep = maxRep;
        this.maxDef = maxDef;
    }

    public String[] getPath() {
        return this.path;
    }

    public int getMaxRepetitionLevel() {
        return this.maxRep;
    }

    public int getMaxDefinitionLevel() {
        return this.maxDef;
    }

    @Deprecated
    public PrimitiveType.PrimitiveTypeName getType() {
        return this.type.getPrimitiveTypeName();
    }

    @Deprecated
    public int getTypeLength() {
        return this.type.getTypeLength();
    }

    public PrimitiveType getPrimitiveType() {
        return this.type;
    }

    public int hashCode() {
        return Arrays.hashCode(this.path);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ColumnDescriptor)) {
            return false;
        }
        ColumnDescriptor descriptor = (ColumnDescriptor)other;
        return Arrays.equals(this.path, descriptor.path);
    }

    @Override
    public int compareTo(ColumnDescriptor o) {
        int length = this.path.length < o.path.length ? this.path.length : o.path.length;
        for (int i = 0; i < length; ++i) {
            int compareTo = this.path[i].compareTo(o.path[i]);
            if (compareTo == 0) continue;
            return compareTo;
        }
        return this.path.length - o.path.length;
    }

    public String toString() {
        return Arrays.toString(this.path) + " " + this.type;
    }
}

