/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import java.math.BigDecimal;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.DecimalUtils;

public class FieldSumAgg
extends FieldAggregator {
    private static final long serialVersionUID = 1L;

    public FieldSumAgg(String name, DataType dataType) {
        super(name, dataType);
    }

    @Override
    public Object agg(Object accumulator, Object inputField) {
        Number sum;
        if (accumulator == null || inputField == null) {
            return accumulator == null ? inputField : accumulator;
        }
        switch (this.fieldType.getTypeRoot()) {
            case DECIMAL: {
                Decimal mergeFieldDD = (Decimal)accumulator;
                Decimal inFieldDD = (Decimal)inputField;
                assert (mergeFieldDD.scale() == inFieldDD.scale()) : "Inconsistent scale of aggregate Decimal!";
                assert (mergeFieldDD.precision() == inFieldDD.precision()) : "Inconsistent precision of aggregate Decimal!";
                sum = DecimalUtils.add((Decimal)mergeFieldDD, (Decimal)inFieldDD, (int)mergeFieldDD.precision(), (int)mergeFieldDD.scale());
                break;
            }
            case TINYINT: {
                sum = (byte)((Byte)accumulator + (Byte)inputField);
                break;
            }
            case SMALLINT: {
                sum = (short)((Short)accumulator + (Short)inputField);
                break;
            }
            case INTEGER: {
                sum = (Integer)accumulator + (Integer)inputField;
                break;
            }
            case BIGINT: {
                sum = (Long)accumulator + (Long)inputField;
                break;
            }
            case FLOAT: {
                sum = Float.valueOf(((Float)accumulator).floatValue() + ((Float)inputField).floatValue());
                break;
            }
            case DOUBLE: {
                sum = (Double)accumulator + (Double)inputField;
                break;
            }
            default: {
                String msg = String.format("type %s not support in %s", this.fieldType.getTypeRoot().toString(), this.getClass().getName());
                throw new IllegalArgumentException(msg);
            }
        }
        return sum;
    }

    @Override
    public Object retract(Object accumulator, Object inputField) {
        Number sum;
        if (accumulator == null || inputField == null) {
            return accumulator == null ? this.negative(inputField) : accumulator;
        }
        switch (this.fieldType.getTypeRoot()) {
            case DECIMAL: {
                Decimal mergeFieldDD = (Decimal)accumulator;
                Decimal inFieldDD = (Decimal)inputField;
                assert (mergeFieldDD.scale() == inFieldDD.scale()) : "Inconsistent scale of aggregate Decimal!";
                assert (mergeFieldDD.precision() == inFieldDD.precision()) : "Inconsistent precision of aggregate Decimal!";
                sum = DecimalUtils.subtract((Decimal)mergeFieldDD, (Decimal)inFieldDD, (int)mergeFieldDD.precision(), (int)mergeFieldDD.scale());
                break;
            }
            case TINYINT: {
                sum = (byte)((Byte)accumulator - (Byte)inputField);
                break;
            }
            case SMALLINT: {
                sum = (short)((Short)accumulator - (Short)inputField);
                break;
            }
            case INTEGER: {
                sum = (Integer)accumulator - (Integer)inputField;
                break;
            }
            case BIGINT: {
                sum = (Long)accumulator - (Long)inputField;
                break;
            }
            case FLOAT: {
                sum = Float.valueOf(((Float)accumulator).floatValue() - ((Float)inputField).floatValue());
                break;
            }
            case DOUBLE: {
                sum = (Double)accumulator - (Double)inputField;
                break;
            }
            default: {
                String msg = String.format("type %s not support in %s", this.fieldType.getTypeRoot().toString(), this.getClass().getName());
                throw new IllegalArgumentException(msg);
            }
        }
        return sum;
    }

    private Object negative(Object value) {
        if (value == null) {
            return null;
        }
        switch (this.fieldType.getTypeRoot()) {
            case DECIMAL: {
                Decimal decimal = (Decimal)value;
                return Decimal.fromBigDecimal((BigDecimal)decimal.toBigDecimal().negate(), (int)decimal.precision(), (int)decimal.scale());
            }
            case TINYINT: {
                return -((Byte)value).byteValue();
            }
            case SMALLINT: {
                return -((Short)value).shortValue();
            }
            case INTEGER: {
                return -((Integer)value).intValue();
            }
            case BIGINT: {
                return -((Long)value).longValue();
            }
            case FLOAT: {
                return Float.valueOf(-((Float)value).floatValue());
            }
            case DOUBLE: {
                return -((Double)value).doubleValue();
            }
        }
        String msg = String.format("type %s not support in %s", this.fieldType.getTypeRoot().toString(), this.getClass().getName());
        throw new IllegalArgumentException(msg);
    }
}

