/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.paimon.iceberg.manifest.IcebergPartitionSummary;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;

public class IcebergManifestFileMeta {
    private final String manifestPath;
    private final long manifestLength;
    private final int partitionSpecId;
    private final Content content;
    private final long sequenceNumber;
    private final long minSequenceNumber;
    private final long addedSnapshotId;
    private final int addedFilesCount;
    private final int existingFilesCount;
    private final int deletedFilesCount;
    private final long addedRowsCount;
    private final long existingRowsCount;
    private final long deletedRowsCount;
    private final List<IcebergPartitionSummary> partitions;

    public IcebergManifestFileMeta(String manifestPath, long manifestLength, int partitionSpecId, Content content, long sequenceNumber, long minSequenceNumber, long addedSnapshotId, int addedFilesCount, int existingFilesCount, int deletedFilesCount, long addedRowsCount, long existingRowsCount, long deletedRowsCount, List<IcebergPartitionSummary> partitions) {
        this.manifestPath = manifestPath;
        this.manifestLength = manifestLength;
        this.partitionSpecId = partitionSpecId;
        this.content = content;
        this.sequenceNumber = sequenceNumber;
        this.minSequenceNumber = minSequenceNumber;
        this.addedSnapshotId = addedSnapshotId;
        this.addedFilesCount = addedFilesCount;
        this.existingFilesCount = existingFilesCount;
        this.deletedFilesCount = deletedFilesCount;
        this.addedRowsCount = addedRowsCount;
        this.existingRowsCount = existingRowsCount;
        this.deletedRowsCount = deletedRowsCount;
        this.partitions = partitions;
    }

    public String manifestPath() {
        return this.manifestPath;
    }

    public long manifestLength() {
        return this.manifestLength;
    }

    public int partitionSpecId() {
        return this.partitionSpecId;
    }

    public Content content() {
        return this.content;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public long minSequenceNumber() {
        return this.minSequenceNumber;
    }

    public long addedSnapshotId() {
        return this.addedSnapshotId;
    }

    public int addedFilesCount() {
        return this.addedFilesCount;
    }

    public int existingFilesCount() {
        return this.existingFilesCount;
    }

    public int deletedFilesCount() {
        return this.deletedFilesCount;
    }

    public long addedRowsCount() {
        return this.addedRowsCount;
    }

    public long existingRowsCount() {
        return this.existingRowsCount;
    }

    public long deletedRowsCount() {
        return this.deletedRowsCount;
    }

    public long liveRowsCount() {
        return this.addedRowsCount + this.existingRowsCount;
    }

    public List<IcebergPartitionSummary> partitions() {
        return this.partitions;
    }

    public static RowType schema(boolean legacyVersion) {
        return legacyVersion ? IcebergManifestFileMeta.schemaForIceberg1_4() : IcebergManifestFileMeta.schemaForIcebergNew();
    }

    private static RowType schemaForIcebergNew() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(500, "manifest_path", DataTypes.STRING().notNull()));
        fields.add(new DataField(501, "manifest_length", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(502, "partition_spec_id", DataTypes.INT().notNull()));
        fields.add(new DataField(517, "content", DataTypes.INT().notNull()));
        fields.add(new DataField(515, "sequence_number", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(516, "min_sequence_number", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(503, "added_snapshot_id", (DataType)DataTypes.BIGINT()));
        fields.add(new DataField(504, "added_files_count", DataTypes.INT().notNull()));
        fields.add(new DataField(505, "existing_files_count", DataTypes.INT().notNull()));
        fields.add(new DataField(506, "deleted_files_count", DataTypes.INT().notNull()));
        fields.add(new DataField(512, "added_rows_count", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(513, "existing_rows_count", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(514, "deleted_rows_count", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(508, "partitions", (DataType)DataTypes.ARRAY((DataType)IcebergPartitionSummary.schema())));
        return new RowType(false, fields);
    }

    private static RowType schemaForIceberg1_4() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(500, "manifest_path", DataTypes.STRING().notNull()));
        fields.add(new DataField(501, "manifest_length", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(502, "partition_spec_id", DataTypes.INT().notNull()));
        fields.add(new DataField(517, "content", DataTypes.INT().notNull()));
        fields.add(new DataField(515, "sequence_number", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(516, "min_sequence_number", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(503, "added_snapshot_id", (DataType)DataTypes.BIGINT()));
        fields.add(new DataField(504, "added_data_files_count", DataTypes.INT().notNull()));
        fields.add(new DataField(505, "existing_data_files_count", DataTypes.INT().notNull()));
        fields.add(new DataField(506, "deleted_data_files_count", DataTypes.INT().notNull()));
        fields.add(new DataField(512, "added_rows_count", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(513, "existing_rows_count", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(514, "deleted_rows_count", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(508, "partitions", (DataType)DataTypes.ARRAY((DataType)IcebergPartitionSummary.schema())));
        return new RowType(false, fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergManifestFileMeta that = (IcebergManifestFileMeta)o;
        return Objects.equals(this.manifestPath, that.manifestPath) && this.manifestLength == that.manifestLength && this.partitionSpecId == that.partitionSpecId && this.content == that.content && this.sequenceNumber == that.sequenceNumber && this.minSequenceNumber == that.minSequenceNumber && this.addedSnapshotId == that.addedSnapshotId && this.addedFilesCount == that.addedFilesCount && this.existingFilesCount == that.existingFilesCount && this.deletedFilesCount == that.deletedFilesCount && this.addedRowsCount == that.addedRowsCount && this.existingRowsCount == that.existingRowsCount && this.deletedRowsCount == that.deletedRowsCount && Objects.equals(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.manifestPath, this.manifestLength, this.partitionSpecId, this.content, this.sequenceNumber, this.minSequenceNumber, this.addedSnapshotId, this.addedFilesCount, this.existingFilesCount, this.deletedFilesCount, this.addedRowsCount, this.existingRowsCount, this.deletedRowsCount, this.partitions});
    }

    public static enum Content {
        DATA(0),
        DELETES(1);

        private final int id;

        private Content(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static Content fromId(int id) {
            switch (id) {
                case 0: {
                    return DATA;
                }
                case 1: {
                    return DELETES;
                }
            }
            throw new IllegalArgumentException("Unknown manifest content: " + id);
        }
    }
}

