/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.authorization;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Audit;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.dto.AuditDTO;

public class UserDTO
implements User {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="audit")
    private AuditDTO audit;
    @JsonProperty(value="roles")
    private List<String> roles;

    protected UserDTO() {
    }

    protected UserDTO(String name, List<String> roles, AuditDTO audit) {
        this.name = name;
        this.audit = audit;
        this.roles = roles;
    }

    public String name() {
        return this.name;
    }

    public List<String> roles() {
        return this.roles;
    }

    public Audit auditInfo() {
        return this.audit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<S extends Builder> {
        protected String name;
        protected List<String> roles = Collections.emptyList();
        protected AuditDTO audit;

        public S withName(String name) {
            this.name = name;
            return (S)this;
        }

        public S withRoles(List<String> roles) {
            if (roles != null) {
                this.roles = roles;
            }
            return (S)this;
        }

        public S withAudit(AuditDTO audit) {
            this.audit = audit;
            return (S)this;
        }

        public UserDTO build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"name cannot be null or empty");
            Preconditions.checkArgument((this.audit != null ? 1 : 0) != 0, (Object)"audit cannot be null");
            return new UserDTO(this.name, this.roles, this.audit);
        }
    }
}

