/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.iceberg;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.sorts.NullOrdering;
import org.apache.gravitino.rel.expressions.sorts.SortDirection;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.sorts.SortOrders;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;

public class ExpressionUtil {
    private static final String IDENTIFIER = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static final String FUNCTION_ARG_INT = "(\\d+)";
    private static final String FUNCTION_ARG_IDENTIFIER = "([a-zA-Z_][a-zA-Z0-9_]*)";
    private static final Pattern YEAR_FUNCTION_PATTERN = Pattern.compile("year\\(([a-zA-Z_][a-zA-Z0-9_]*)\\)", 2);
    private static final Pattern MONTH_FUNCTION_PATTERN = Pattern.compile("month\\(([a-zA-Z_][a-zA-Z0-9_]*)\\)", 2);
    private static final Pattern DAY_FUNCTION_PATTERN = Pattern.compile("day\\(([a-zA-Z_][a-zA-Z0-9_]*)\\)", 2);
    private static final Pattern HOUR_FUNCTION_PATTERN = Pattern.compile("hour\\(([a-zA-Z_][a-zA-Z0-9_]*)\\)", 2);
    private static final Pattern BUCKET_FUNCTION_PATTERN = Pattern.compile("bucket\\(([a-zA-Z_][a-zA-Z0-9_]*),\\s*(\\d+)\\)", 2);
    private static final Pattern TRUNCATE_FUNCTION_PATTERN = Pattern.compile("truncate\\(([a-zA-Z_][a-zA-Z0-9_]*),\\s*(\\d+)\\)", 2);
    private static final Pattern IDENTIFILER_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*", 2);
    private static final String SORT_DIRECTION_ASC = "ASC";
    private static final String SORT_DIRECTION_DESC = "DESC";
    private static final String NULL_ORDERING_FIRST = "NULLS FIRST";
    private static final String NULL_ORDERING_LAST = "NULLS LAST";
    private static final String SORT_DIRECTION = "(ASC|DESC)";
    private static final String NULL_ORDERING = "(NULLS FIRST|NULLS LAST)";
    private static final Pattern SROT_ORDER_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*", 2);
    private static final Pattern SORT_ORDER_WITH_SORT_DIRECTION_PATTERN = Pattern.compile("([a-zA-Z_][a-zA-Z0-9_]*)\\s+(ASC|DESC)", 2);
    private static final Pattern SORT_ORDER_WITH_SORT_DIRECTION_AND_NULL_ORDERING_PATTERN = Pattern.compile("([a-zA-Z_][a-zA-Z0-9_]*)\\s+(ASC|DESC)\\s+(NULLS FIRST|NULLS LAST)", 2);

    public static List<String> expressionToPartitionFiled(Transform[] transforms) {
        try {
            ArrayList<String> partitionFields = new ArrayList<String>();
            for (Transform transform : transforms) {
                partitionFields.add(ExpressionUtil.transFormToString(transform));
            }
            return partitionFields;
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_EXPRESSION_ERROR, "Error to handle transform Expressions :" + e.getMessage(), (Throwable)e);
        }
    }

    public static Transform[] partitionFiledToExpression(List<String> partitions) {
        try {
            ArrayList<Transform> partitionTransforms = new ArrayList<Transform>();
            for (String partition : partitions) {
                ExpressionUtil.parseTransform(partitionTransforms, partition);
            }
            return partitionTransforms.toArray(new Transform[0]);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_EXPRESSION_ERROR, "Error parsing the partition field: " + e.getMessage(), (Throwable)e);
        }
    }

    public static List<String> expressionToSortOrderFiled(SortOrder[] orders) {
        try {
            ArrayList<String> orderFields = new ArrayList<String>();
            for (SortOrder order : orders) {
                orderFields.add(ExpressionUtil.sortOrderToString(order));
            }
            return orderFields;
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_EXPRESSION_ERROR, "Error to handle the sort order expressions : " + e.getMessage(), (Throwable)e);
        }
    }

    public static SortOrder[] sortOrderFiledToExpression(List<String> orderFields) {
        try {
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (String orderField : orderFields) {
                ExpressionUtil.parseSortOrder(sortOrders, orderField);
            }
            return sortOrders.toArray(new SortOrder[0]);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_EXPRESSION_ERROR, "Error parsing the sort order field: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void parseTransform(List<Transform> transforms, String value) {
        boolean match;
        boolean bl = match = ExpressionUtil.tryMatch(value, IDENTIFILER_PATTERN, m -> transforms.add((Transform)Transforms.identity((String)m.group(0)))) || ExpressionUtil.tryMatch(value, YEAR_FUNCTION_PATTERN, m -> transforms.add((Transform)Transforms.year((String)m.group(1)))) || ExpressionUtil.tryMatch(value, MONTH_FUNCTION_PATTERN, m -> transforms.add((Transform)Transforms.month((String)m.group(1)))) || ExpressionUtil.tryMatch(value, DAY_FUNCTION_PATTERN, m -> transforms.add((Transform)Transforms.day((String)m.group(1)))) || ExpressionUtil.tryMatch(value, HOUR_FUNCTION_PATTERN, m -> transforms.add((Transform)Transforms.hour((String)m.group(1)))) || ExpressionUtil.tryMatch(value, BUCKET_FUNCTION_PATTERN, m -> transforms.add((Transform)Transforms.bucket((int)Integer.parseInt(m.group(2)), (String[][])new String[][]{{m.group(1)}}))) || ExpressionUtil.tryMatch(value, TRUNCATE_FUNCTION_PATTERN, m -> transforms.add((Transform)Transforms.truncate((int)Integer.parseInt(m.group(2)), (String[])new String[]{m.group(1)})));
        if (!match) {
            throw new IllegalArgumentException("Unparsed expression: " + value);
        }
    }

    private static boolean tryMatch(String value, Pattern pattern, MatchHandler handler) {
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            handler.invoke(matcher.toMatchResult());
            return true;
        }
        return false;
    }

    private static String transFormToString(Transform transform) {
        if (transform instanceof Transforms.IdentityTransform) {
            return ((Transforms.IdentityTransform)transform).fieldName()[0];
        }
        if (transform instanceof Transforms.YearTransform || transform instanceof Transforms.MonthTransform || transform instanceof Transforms.DayTransform || transform instanceof Transforms.HourTransform) {
            return String.format("%s(%s)", transform.name(), ExpressionUtil.expressionToString(transform.arguments()[0]));
        }
        if (transform instanceof Transforms.BucketTransform) {
            Transforms.BucketTransform bucketTransform = (Transforms.BucketTransform)transform;
            return String.format("%s(%s, %s)", bucketTransform.name(), bucketTransform.fieldNames()[0][0], bucketTransform.numBuckets());
        }
        if (transform instanceof Transforms.TruncateTransform) {
            Transforms.TruncateTransform truncateTransform = (Transforms.TruncateTransform)transform;
            return String.format("%s(%s, %s)", truncateTransform.name(), truncateTransform.fieldName()[0], truncateTransform.width());
        }
        throw new IllegalArgumentException(String.format("Unsupported transform %s with %d parameters: ", transform, transform.arguments().length));
    }

    private static String expressionToString(Expression expression) {
        if (expression instanceof NamedReference) {
            return ((NamedReference)expression).fieldName()[0];
        }
        if (expression instanceof Literal) {
            return ((Literal)expression).value().toString();
        }
        throw new IllegalArgumentException("Unsupported expression: " + String.valueOf(expression));
    }

    private static String sortOrderToString(SortOrder order) {
        Expression orderExpression = order.expression();
        if (!(orderExpression instanceof NamedReference)) {
            throw new IllegalArgumentException("Only supported sort expression of NamedReference, the expression: " + String.valueOf(orderExpression));
        }
        String columnName = ((NamedReference)orderExpression).fieldName()[0];
        if (order.direction() == SortDirection.ASCENDING) {
            if (order.nullOrdering() == NullOrdering.NULLS_LAST) {
                return String.format("%s ASC NULLS LAST", columnName);
            }
            return columnName;
        }
        if (order.direction() == SortDirection.DESCENDING) {
            if (order.nullOrdering() == NullOrdering.NULLS_FIRST) {
                return String.format("%s DESC NULLS FIRST", columnName);
            }
            return columnName + " DESC";
        }
        throw new IllegalArgumentException("Unsupported sort order: " + String.valueOf(order));
    }

    private static void parseSortOrder(List<SortOrder> sortOrders, String value) {
        boolean match;
        boolean bl = match = ExpressionUtil.tryMatch(value, SROT_ORDER_PATTERN, m -> {
            NamedReference.FieldReference sortField = NamedReference.field((String)m.group(0));
            sortOrders.add((SortOrder)SortOrders.ascending((Expression)sortField));
        }) || ExpressionUtil.tryMatch(value, SORT_ORDER_WITH_SORT_DIRECTION_PATTERN, m -> {
            NamedReference.FieldReference sortField = NamedReference.field((String)m.group(1));
            SortDirection sortDirection = m.group(1).toUpperCase().equals(SORT_DIRECTION_ASC) ? SortDirection.ASCENDING : SortDirection.DESCENDING;
            NullOrdering nullOrdering = sortDirection.equals((Object)SortDirection.ASCENDING) ? NullOrdering.NULLS_FIRST : NullOrdering.NULLS_LAST;
            sortOrders.add((SortOrder)SortOrders.of((Expression)sortField, (SortDirection)sortDirection, (NullOrdering)nullOrdering));
        }) || ExpressionUtil.tryMatch(value, SORT_ORDER_WITH_SORT_DIRECTION_AND_NULL_ORDERING_PATTERN, m -> {
            NamedReference.FieldReference sortField = NamedReference.field((String)m.group(1));
            SortDirection sortDirection = m.group(2).toUpperCase().equals(SORT_DIRECTION_ASC) ? SortDirection.ASCENDING : SortDirection.DESCENDING;
            NullOrdering nullOrdering = m.group(3).toUpperCase().equals(NULL_ORDERING_FIRST) ? NullOrdering.NULLS_FIRST : NullOrdering.NULLS_LAST;
            sortOrders.add((SortOrder)SortOrders.of((Expression)sortField, (SortDirection)sortDirection, (NullOrdering)nullOrdering));
        });
        if (!match) {
            throw new IllegalArgumentException("Unparsed expression: " + value);
        }
    }

    static interface MatchHandler {
        public void invoke(MatchResult var1);
    }
}

