/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.model.Model;

@Evolving
public abstract class BaseModel
implements Model {
    protected String name;
    @Nullable
    protected String comment;
    @Nullable
    protected Map<String, String> properties;
    protected int latestVersion;
    protected AuditInfo auditInfo;

    public String name() {
        return this.name;
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    @Nullable
    public Map<String, String> properties() {
        return this.properties;
    }

    public int latestVersion() {
        return this.latestVersion;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    public static abstract class BaseModelBuilder<SELF extends Builder<SELF, T>, T extends BaseModel>
    implements Builder<SELF, T> {
        protected String name;
        @Nullable
        protected String comment;
        @Nullable
        protected Map<String, String> properties;
        protected int latestVersion;
        protected AuditInfo auditInfo;

        @Override
        public SELF withName(String name) {
            this.name = name;
            return this.self();
        }

        @Override
        public SELF withComment(@Nullable String comment) {
            this.comment = comment;
            return this.self();
        }

        @Override
        public SELF withProperties(@Nullable Map<String, String> properties) {
            this.properties = properties;
            return this.self();
        }

        @Override
        public SELF withLatestVersion(int latestVersion) {
            this.latestVersion = latestVersion;
            return this.self();
        }

        @Override
        public SELF withAuditInfo(AuditInfo auditInfo) {
            this.auditInfo = auditInfo;
            return this.self();
        }

        @Override
        public T build() {
            return this.internalBuild();
        }

        protected abstract T internalBuild();

        private SELF self() {
            return (SELF)this;
        }
    }

    static interface Builder<SELF extends Builder<SELF, T>, T extends BaseModel> {
        public SELF withName(String var1);

        public SELF withComment(@Nullable String var1);

        public SELF withProperties(@Nullable Map<String, String> var1);

        public SELF withLatestVersion(int var1);

        public SELF withAuditInfo(AuditInfo var1);

        public T build();
    }
}

