/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.responses.BaseResponse;

public class OAuth2TokenResponse
extends BaseResponse {
    @JsonProperty(value="access_token")
    private final String accessToken;
    @Nullable
    @JsonProperty(value="issued_token_type")
    private final String issuedTokenType;
    @JsonProperty(value="token_type")
    private final String tokenType;
    @JsonProperty(value="expires_in")
    private final Integer expiresIn;
    @JsonProperty(value="scope")
    private final String scope;
    @Nullable
    @JsonProperty(value="refresh_token")
    private final String refreshToken;

    public OAuth2TokenResponse(String accessToken, String issuedTokenType, String tokenType, Integer expiresIn, String scope, String refreshToken) {
        this.accessToken = accessToken;
        this.issuedTokenType = issuedTokenType;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
        this.scope = scope;
        this.refreshToken = refreshToken;
    }

    public OAuth2TokenResponse() {
        this.accessToken = null;
        this.issuedTokenType = null;
        this.tokenType = null;
        this.expiresIn = null;
        this.scope = null;
        this.refreshToken = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.accessToken), "Invalid access token: null");
        Preconditions.checkArgument("bearer".equalsIgnoreCase(this.tokenType), "Unsupported token type: %s (must be \"bearer\")", (Object)this.tokenType);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    @Nullable
    public String getIssuedTokenType() {
        return this.issuedTokenType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2TokenResponse)) {
            return false;
        }
        OAuth2TokenResponse other = (OAuth2TokenResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$expiresIn = this.getExpiresIn();
        Integer other$expiresIn = other.getExpiresIn();
        if (this$expiresIn == null ? other$expiresIn != null : !((Object)this$expiresIn).equals(other$expiresIn)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$issuedTokenType = this.getIssuedTokenType();
        String other$issuedTokenType = other.getIssuedTokenType();
        if (this$issuedTokenType == null ? other$issuedTokenType != null : !this$issuedTokenType.equals(other$issuedTokenType)) {
            return false;
        }
        String this$tokenType = this.getTokenType();
        String other$tokenType = other.getTokenType();
        if (this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        return !(this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OAuth2TokenResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $expiresIn = this.getExpiresIn();
        result = result * 59 + ($expiresIn == null ? 43 : ((Object)$expiresIn).hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $issuedTokenType = this.getIssuedTokenType();
        result = result * 59 + ($issuedTokenType == null ? 43 : $issuedTokenType.hashCode());
        String $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OAuth2TokenResponse(accessToken=" + this.getAccessToken() + ", issuedTokenType=" + this.getIssuedTokenType() + ", tokenType=" + this.getTokenType() + ", expiresIn=" + this.getExpiresIn() + ", scope=" + this.getScope() + ", refreshToken=" + this.getRefreshToken() + ")";
    }
}

