/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class ListUsers
extends Command {
    protected final String metalake;

    public ListUsers(CommandContext context, String metalake) {
        super(context);
        this.metalake = metalake;
    }

    @Override
    public void handle() {
        CharSequence[] users = new String[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            users = client.listUserNames();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (users.length == 0) {
            this.printInformation("No users exist.");
        } else {
            this.printResults(String.join((CharSequence)",", users));
        }
    }
}

