/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import com.google.common.base.Joiner;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;

public class ListFilesets
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;

    public ListFilesets(CommandContext context, String metalake, String catalog, String schema) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
    }

    @Override
    public void handle() {
        Namespace name = Namespace.of(this.schema);
        Object[] filesets = new NameIdentifier[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            filesets = client.loadCatalog(this.catalog).asFilesetCatalog().listFilesets(name);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        String all = filesets.length == 0 ? "No filesets exist." : Joiner.on(",").join(filesets);
        this.printResults(all);
    }
}

