/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.Properties;
import org.apache.gravitino.cli.commands.Command;

public class CatalogCommandHandler
extends CommandHandler {
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final String command;
    private final CommandContext context;
    private final FullName name;
    private final String metalake;
    private String catalog;

    public CatalogCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
        this.name = new FullName(line);
        this.metalake = this.name.getMetalakeName();
    }

    @Override
    protected void handle() {
        String userName = this.line.getOptionValue("login");
        Command.setAuthenticationMode(this.context.auth(), userName);
        ArrayList<String> missingEntities = Lists.newArrayList();
        if ("list".equals(this.command)) {
            this.handleListCommand();
            return;
        }
        this.catalog = this.name.getCatalogName();
        if (this.catalog == null) {
            missingEntities.add("catalog");
        }
        this.checkEntities(missingEntities);
        if (!this.executeCommand()) {
            System.err.println("Unsupported or unknown command.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "create": {
                this.handleCreateCommand();
                return true;
            }
            case "delete": {
                this.handleDeleteCommand();
                return true;
            }
            case "set": {
                this.handleSetCommand();
                return true;
            }
            case "remove": {
                this.handleRemoveCommand();
                return true;
            }
            case "properties": {
                this.handlePropertiesCommand();
                return true;
            }
            case "update": {
                this.handleUpdateCommand();
                return true;
            }
        }
        return false;
    }

    private void handleDetailsCommand() {
        if (this.line.hasOption("audit")) {
            this.gravitinoCommandLine.newCatalogAudit(this.context, this.metalake, this.catalog).validate().handle();
        } else {
            this.gravitinoCommandLine.newCatalogDetails(this.context, this.metalake, this.catalog).validate().handle();
        }
    }

    private void handleCreateCommand() {
        String comment = this.line.getOptionValue("comment");
        String provider = this.line.getOptionValue("provider");
        String[] properties = this.line.getOptionValues("properties");
        Map<String, String> propertyMap = new Properties().parse(properties);
        this.gravitinoCommandLine.newCreateCatalog(this.context, this.metalake, this.catalog, provider, comment, propertyMap).validate().handle();
    }

    private void handleDeleteCommand() {
        this.gravitinoCommandLine.newDeleteCatalog(this.context, this.metalake, this.catalog).validate().handle();
    }

    private void handleSetCommand() {
        String property = this.line.getOptionValue("property");
        String value = this.line.getOptionValue("value");
        this.gravitinoCommandLine.newSetCatalogProperty(this.context, this.metalake, this.catalog, property, value).validate().handle();
    }

    private void handleRemoveCommand() {
        String property = this.line.getOptionValue("property");
        this.gravitinoCommandLine.newRemoveCatalogProperty(this.context, this.metalake, this.catalog, property).validate().handle();
    }

    private void handlePropertiesCommand() {
        this.gravitinoCommandLine.newListCatalogProperties(this.context, this.metalake, this.catalog).validate().handle();
    }

    private void handleUpdateCommand() {
        if (this.line.hasOption("enable") || this.line.hasOption("disable")) {
            this.gravitinoCommandLine.newManageCatalog(this.context, this.metalake, this.catalog).validate().handle();
        }
        if (this.line.hasOption("comment")) {
            String updateComment = this.line.getOptionValue("comment");
            this.gravitinoCommandLine.newUpdateCatalogComment(this.context, this.metalake, this.catalog, updateComment).validate().handle();
        }
        if (this.line.hasOption("rename")) {
            String newName = this.line.getOptionValue("rename");
            this.gravitinoCommandLine.newUpdateCatalogName(this.context, this.metalake, this.catalog, newName).validate().handle();
        }
    }

    private void handleListCommand() {
        this.gravitinoCommandLine.newListCatalogs(this.context, this.metalake).validate().handle();
    }
}

