/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.gravitino.exceptions.ForbiddenException;
import org.apache.gravitino.listener.AsyncQueueListener;
import org.apache.gravitino.listener.api.EventListenerPlugin;
import org.apache.gravitino.listener.api.event.BaseEvent;
import org.apache.gravitino.listener.api.event.Event;
import org.apache.gravitino.listener.api.event.PreEvent;

public class EventBus {
    private final List<EventListenerPlugin> eventListeners;
    private final List<AsyncQueueListener> asyncQueueListeners;

    public EventBus(List<EventListenerPlugin> eventListeners) {
        this.eventListeners = eventListeners;
        this.asyncQueueListeners = eventListeners.stream().filter(AsyncQueueListener.class::isInstance).map(AsyncQueueListener.class::cast).collect(Collectors.toList());
    }

    public void dispatchEvent(BaseEvent baseEvent) {
        if (baseEvent instanceof PreEvent) {
            this.dispatchPreEvent((PreEvent)baseEvent);
        } else if (baseEvent instanceof Event) {
            this.dispatchPostEvent((Event)baseEvent);
        } else {
            throw new RuntimeException("Unknown event type:" + baseEvent.getClass().getSimpleName());
        }
    }

    public boolean isHighWatermark() {
        return this.asyncQueueListeners.stream().anyMatch(AsyncQueueListener::isHighWatermark);
    }

    @VisibleForTesting
    public List<EventListenerPlugin> getEventListeners() {
        return this.eventListeners;
    }

    private void dispatchPostEvent(Event postEvent) {
        this.eventListeners.forEach(eventListener -> eventListener.onPostEvent(postEvent));
    }

    private void dispatchPreEvent(PreEvent preEvent) throws ForbiddenException {
        this.eventListeners.forEach(eventListener -> eventListener.onPreEvent(preEvent));
    }
}

