/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.sort;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.paimon.codegen.NormalizedKeyComputer;
import org.apache.paimon.codegen.RecordComparator;
import org.apache.paimon.data.AbstractPagedInputView;
import org.apache.paimon.data.AbstractPagedOutputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.RandomAccessInputView;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.sort.IndexedSortable;

public abstract class BinaryIndexedSortable
implements IndexedSortable {
    public static final int OFFSET_LEN = 8;
    private final NormalizedKeyComputer normalizedKeyComputer;
    protected final BinaryRowSerializer serializer;
    private final RecordComparator comparator;
    protected final RandomAccessInputView recordBuffer;
    private final RandomAccessInputView recordBufferForComparison;
    protected MemorySegment currentSortIndexSegment;
    protected final MemorySegmentPool memorySegmentPool;
    protected final ArrayList<MemorySegment> sortIndex;
    private final int numKeyBytes;
    protected final int indexEntrySize;
    private final int indexEntriesPerSegment;
    protected final int lastIndexEntryOffset;
    private final boolean normalizedKeyFullyDetermines;
    private final boolean useNormKeyUninverted;
    protected final BinaryRowSerializer serializer1;
    private final BinaryRowSerializer serializer2;
    protected final BinaryRow row1;
    private final BinaryRow row2;
    protected int currentSortIndexOffset;
    protected int numRecords;

    public BinaryIndexedSortable(NormalizedKeyComputer normalizedKeyComputer, BinaryRowSerializer serializer, RecordComparator comparator, ArrayList<MemorySegment> recordBufferSegments, MemorySegmentPool memorySegmentPool) {
        if (normalizedKeyComputer == null || serializer == null) {
            throw new NullPointerException();
        }
        this.normalizedKeyComputer = normalizedKeyComputer;
        this.serializer = serializer;
        this.comparator = comparator;
        this.memorySegmentPool = memorySegmentPool;
        this.useNormKeyUninverted = !normalizedKeyComputer.invertKey();
        this.numKeyBytes = normalizedKeyComputer.getNumKeyBytes();
        int segmentSize = memorySegmentPool.pageSize();
        this.recordBuffer = new RandomAccessInputView(recordBufferSegments, segmentSize);
        this.recordBufferForComparison = new RandomAccessInputView(recordBufferSegments, segmentSize);
        this.normalizedKeyFullyDetermines = normalizedKeyComputer.isKeyFullyDetermines();
        this.indexEntrySize = this.numKeyBytes + 8;
        this.indexEntriesPerSegment = segmentSize / this.indexEntrySize;
        this.lastIndexEntryOffset = (this.indexEntriesPerSegment - 1) * this.indexEntrySize;
        this.serializer1 = serializer.duplicate();
        this.serializer2 = serializer.duplicate();
        this.row1 = this.serializer1.createInstance();
        this.row2 = this.serializer2.createInstance();
        this.sortIndex = new ArrayList(16);
        this.currentSortIndexSegment = this.nextMemorySegment();
        this.sortIndex.add(this.currentSortIndexSegment);
    }

    protected MemorySegment nextMemorySegment() {
        return this.memorySegmentPool.nextSegment();
    }

    protected boolean checkNextIndexOffset() {
        if (this.currentSortIndexOffset > this.lastIndexEntryOffset) {
            MemorySegment returnSegment = this.nextMemorySegment();
            if (returnSegment != null) {
                this.currentSortIndexSegment = returnSegment;
                this.sortIndex.add(this.currentSortIndexSegment);
                this.currentSortIndexOffset = 0;
            } else {
                return false;
            }
        }
        return true;
    }

    protected void writeIndexAndNormalizedKey(InternalRow record, long currOffset) {
        this.currentSortIndexSegment.putLong(this.currentSortIndexOffset, currOffset);
        if (this.numKeyBytes != 0) {
            this.normalizedKeyComputer.putKey(record, this.currentSortIndexSegment, this.currentSortIndexOffset + 8);
        }
        this.currentSortIndexOffset += this.indexEntrySize;
        ++this.numRecords;
    }

    @Override
    public int compare(int i, int j) {
        int segmentNumberI = i / this.indexEntriesPerSegment;
        int segmentOffsetI = i % this.indexEntriesPerSegment * this.indexEntrySize;
        int segmentNumberJ = j / this.indexEntriesPerSegment;
        int segmentOffsetJ = j % this.indexEntriesPerSegment * this.indexEntrySize;
        return this.compare(segmentNumberI, segmentOffsetI, segmentNumberJ, segmentOffsetJ);
    }

    @Override
    public int compare(int segmentNumberI, int segmentOffsetI, int segmentNumberJ, int segmentOffsetJ) {
        MemorySegment segJ;
        MemorySegment segI = this.sortIndex.get(segmentNumberI);
        int val = this.normalizedKeyComputer.compareKey(segI, segmentOffsetI + 8, segJ = this.sortIndex.get(segmentNumberJ), segmentOffsetJ + 8);
        if (val != 0 || this.normalizedKeyFullyDetermines) {
            return this.useNormKeyUninverted ? val : -val;
        }
        long pointerI = segI.getLong(segmentOffsetI);
        long pointerJ = segJ.getLong(segmentOffsetJ);
        return this.compareRecords(pointerI, pointerJ);
    }

    private int compareRecords(long pointer1, long pointer2) {
        this.recordBuffer.setReadPosition(pointer1);
        this.recordBufferForComparison.setReadPosition(pointer2);
        try {
            return this.comparator.compare((InternalRow)this.serializer1.mapFromPages(this.row1, (AbstractPagedInputView)this.recordBuffer), (InternalRow)this.serializer2.mapFromPages(this.row2, (AbstractPagedInputView)this.recordBufferForComparison));
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error comparing two records.", ioex);
        }
    }

    @Override
    public void swap(int i, int j) {
        int segmentNumberI = i / this.indexEntriesPerSegment;
        int segmentOffsetI = i % this.indexEntriesPerSegment * this.indexEntrySize;
        int segmentNumberJ = j / this.indexEntriesPerSegment;
        int segmentOffsetJ = j % this.indexEntriesPerSegment * this.indexEntrySize;
        this.swap(segmentNumberI, segmentOffsetI, segmentNumberJ, segmentOffsetJ);
    }

    @Override
    public void swap(int segmentNumberI, int segmentOffsetI, int segmentNumberJ, int segmentOffsetJ) {
        MemorySegment segI = this.sortIndex.get(segmentNumberI);
        MemorySegment segJ = this.sortIndex.get(segmentNumberJ);
        long index = segI.getLong(segmentOffsetI);
        segI.putLong(segmentOffsetI, segJ.getLong(segmentOffsetJ));
        segJ.putLong(segmentOffsetJ, index);
        this.normalizedKeyComputer.swapKey(segI, segmentOffsetI + 8, segJ, segmentOffsetJ + 8);
    }

    @Override
    public int size() {
        return this.numRecords;
    }

    @Override
    public int recordSize() {
        return this.indexEntrySize;
    }

    @Override
    public int recordsPerSegment() {
        return this.indexEntriesPerSegment;
    }

    public void writeToOutput(AbstractPagedOutputView output) throws IOException {
        int numRecords = this.numRecords;
        int currentMemSeg = 0;
        int currentRecord = 0;
        while (currentRecord < numRecords) {
            MemorySegment currentIndexSegment = this.sortIndex.get(currentMemSeg++);
            for (int offset = 0; currentRecord < numRecords && offset <= this.lastIndexEntryOffset; ++currentRecord, offset += this.indexEntrySize) {
                long pointer = currentIndexSegment.getLong(offset);
                this.recordBuffer.setReadPosition(pointer);
                this.serializer.copyFromPagesToView((AbstractPagedInputView)this.recordBuffer, (DataOutputView)output);
            }
        }
    }
}

