/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.doris.operation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.gravitino.catalog.jdbc.JdbcTable;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTablePartitionOperations;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.partitions.Partition;
import org.apache.gravitino.rel.partitions.Partitions;
import org.apache.gravitino.rel.types.Type;

public final class DorisTablePartitionOperations
extends JdbcTablePartitionOperations {
    private static final String PARTITION_TYPE_VALUE_PATTERN_STRING = "types: \\[([^\\]]+)\\]; keys: \\[([^\\]]+)\\];";
    private static final Pattern PARTITION_TYPE_VALUE_PATTERN = Pattern.compile("types: \\[([^\\]]+)\\]; keys: \\[([^\\]]+)\\];");
    private final JdbcExceptionConverter exceptionConverter;
    private final JdbcTypeConverter typeConverter;

    public DorisTablePartitionOperations(DataSource dataSource, JdbcTable loadedTable, JdbcExceptionConverter exceptionConverter, JdbcTypeConverter typeConverter) {
        super(dataSource, loadedTable);
        Preconditions.checkArgument((exceptionConverter != null ? 1 : 0) != 0, (Object)"exceptionConverter is null");
        Preconditions.checkArgument((typeConverter != null ? 1 : 0) != 0, (Object)"typeConverter is null");
        this.exceptionConverter = exceptionConverter;
        this.typeConverter = typeConverter;
    }

    /*
     * Exception decompiling
     */
    public String[] listPartitionNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Partition[] listPartitions() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Partition getPartition(String partitionName) throws NoSuchPartitionException {
        try (Connection connection = this.getConnection(this.loadedTable.databaseName());){
            Transform partitionInfo = this.loadedTable.partitioning()[0];
            Map<String, Type> columnTypes = this.getColumnType(connection);
            String showPartitionsSql = String.format("SHOW PARTITIONS FROM `%s` WHERE PartitionName = \"%s\"", this.loadedTable.name(), partitionName);
            try (Statement statement = connection.createStatement();
                 ResultSet result = statement.executeQuery(showPartitionsSql);){
                if (!result.next()) throw new NoSuchPartitionException("Partition %s does not exist", new Object[]{partitionName});
                Partition partition = this.fromDorisPartition(result, partitionInfo, columnTypes);
                return partition;
            }
        }
        catch (SQLException e) {
            throw this.exceptionConverter.toGravitinoException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public Partition addPartition(Partition partition) throws PartitionAlreadyExistsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean dropPartition(String partitionName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Partition fromDorisPartition(ResultSet resultSet, Transform partitionInfo, Map<String, Type> columnTypes) throws SQLException {
        String partitionName = resultSet.getString("PartitionName");
        String partitionKey = resultSet.getString("PartitionKey");
        String partitionValues = resultSet.getString("Range");
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        propertiesBuilder.put((Object)"PartitionId", (Object)resultSet.getString("PartitionId"));
        propertiesBuilder.put((Object)"VisibleVersion", (Object)resultSet.getString("VisibleVersion"));
        propertiesBuilder.put((Object)"VisibleVersionTime", (Object)resultSet.getString("VisibleVersionTime"));
        propertiesBuilder.put((Object)"State", (Object)resultSet.getString("State"));
        propertiesBuilder.put((Object)"PartitionKey", (Object)partitionKey);
        propertiesBuilder.put((Object)"DataSize", (Object)resultSet.getString("DataSize"));
        propertiesBuilder.put((Object)"IsInMemory", (Object)resultSet.getString("IsInMemory"));
        ImmutableMap properties = propertiesBuilder.build();
        String[] partitionKeys = partitionKey.split(", ");
        if (partitionInfo instanceof Transforms.RangeTransform) {
            if (partitionKeys.length != 1) {
                throw new UnsupportedOperationException("Multi-column range partitioning in Doris is not supported yet");
            }
            Type partitionColumnType = columnTypes.get(partitionKeys[0]);
            Literal lower = Literals.NULL;
            Literal upper = Literals.NULL;
            Matcher matcher = PARTITION_TYPE_VALUE_PATTERN.matcher(partitionValues);
            if (matcher.find()) {
                String lowerValue = matcher.group(2);
                lower = Literals.of((Object)lowerValue, (Type)partitionColumnType);
                if (matcher.find()) {
                    String upperValue = matcher.group(2);
                    upper = Literals.of((Object)upperValue, (Type)partitionColumnType);
                }
            }
            return Partitions.range((String)partitionName, (Literal)upper, (Literal)lower, (Map)properties);
        }
        if (partitionInfo instanceof Transforms.ListTransform) {
            Matcher matcher = PARTITION_TYPE_VALUE_PATTERN.matcher(partitionValues);
            ImmutableList.Builder lists = ImmutableList.builder();
            while (matcher.find()) {
                String[] values = matcher.group(2).split(", ");
                ImmutableList.Builder literValues = ImmutableList.builder();
                for (int i = 0; i < values.length; ++i) {
                    Type partitionColumnType = columnTypes.get(partitionKeys[i]);
                    literValues.add((Object)Literals.of((Object)values[i], (Type)partitionColumnType));
                }
                lists.add((Object)((Literal[])literValues.build().toArray((Object[])new Literal[0])));
            }
            return Partitions.list((String)partitionName, (Literal[][])((Literal[][])lists.build().toArray((Object[])new Literal[0][0])), (Map)properties);
        }
        throw new UnsupportedOperationException(String.format("%s is not a partitioned table", this.loadedTable.name()));
    }

    private Map<String, Type> getColumnType(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        try (ResultSet result = metaData.getColumns(connection.getCatalog(), connection.getSchema(), this.loadedTable.name(), null);){
            ImmutableMap.Builder columnTypes = ImmutableMap.builder();
            while (result.next()) {
                if (!Objects.equals(result.getString("TABLE_NAME"), this.loadedTable.name())) continue;
                JdbcTypeConverter.JdbcTypeBean typeBean = new JdbcTypeConverter.JdbcTypeBean(result.getString("TYPE_NAME"));
                typeBean.setColumnSize(Integer.valueOf(result.getInt("COLUMN_SIZE")));
                typeBean.setScale(Integer.valueOf(result.getInt("DECIMAL_DIGITS")));
                Type gravitinoType = this.typeConverter.toGravitino((Object)typeBean);
                String columnName = result.getString("COLUMN_NAME");
                columnTypes.put((Object)columnName, (Object)gravitinoType);
            }
            ImmutableMap immutableMap = columnTypes.build();
            return immutableMap;
        }
    }

    private static /* synthetic */ boolean lambda$addPartition$0(Transform partitionInfo, Literal[] part) {
        return part.length == ((Transforms.ListTransform)partitionInfo).fieldNames().length;
    }
}

