/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.audit.v2;

import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.audit.AuditLog;
import org.apache.gravitino.audit.v2.CompatibilityUtils;
import org.apache.gravitino.listener.api.event.BaseEvent;
import org.apache.gravitino.listener.api.event.EventSource;
import org.apache.gravitino.listener.api.event.OperationStatus;
import org.apache.gravitino.listener.api.event.OperationType;

public class SimpleAuditLogV2
implements AuditLog {
    private final BaseEvent event;

    public SimpleAuditLogV2(BaseEvent event) {
        this.event = event;
    }

    @Override
    public String user() {
        return this.event.user();
    }

    @Override
    public AuditLog.Operation operation() {
        return CompatibilityUtils.toAuditLogOperation(this.event.operationType());
    }

    @Override
    public String identifier() {
        return Optional.ofNullable(this.event.identifier()).map(NameIdentifier::toString).orElse(null);
    }

    @Override
    public long timestamp() {
        return this.event.eventTime();
    }

    @Override
    public AuditLog.Status status() {
        return CompatibilityUtils.toAuditLogStatus(this.event.operationStatus());
    }

    @Override
    public String remoteAddress() {
        return this.event.remoteAddress();
    }

    @Override
    public OperationStatus operationStatus() {
        return this.event.operationStatus();
    }

    @Override
    public OperationType operationType() {
        return this.event.operationType();
    }

    @Override
    public EventSource eventSource() {
        return this.event.eventSource();
    }

    @Override
    public Map<String, String> customInfo() {
        return this.event.customInfo();
    }

    public String toString() {
        return String.format("[%s]\t%s\t%s\t%s\t%s\t%s\t%s", new Object[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.timestamp()), this.user(), this.operationType(), this.identifier(), this.operationStatus(), this.eventSource(), this.remoteAddress()});
    }
}

