/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.circuitBreaker;

import io.openlineage.client.circuitBreaker.CircuitBreaker;
import io.openlineage.client.circuitBreaker.CircuitBreakerState;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutorCircuitBreaker
implements CircuitBreaker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorCircuitBreaker.class);
    private Integer circuitCheckIntervalInMillis;
    protected Optional<Duration> timeout;
    private ExecutorService executor;

    public ExecutorCircuitBreaker(Integer circuitCheckIntervalInMillis) {
        this.circuitCheckIntervalInMillis = circuitCheckIntervalInMillis;
        this.timeout = Optional.empty();
        this.executor = Executors.newCachedThreadPool();
    }

    public ExecutorCircuitBreaker(Integer circuitCheckIntervalInMillis, Duration timeout) {
        this.circuitCheckIntervalInMillis = circuitCheckIntervalInMillis;
        this.timeout = Optional.of(timeout);
        this.executor = Executors.newCachedThreadPool();
    }

    @Override
    public <T> T run(Callable<T> callable) {
        T result;
        if (this.currentState().isClosed()) {
            log.warn("CircuitBreaker closed preventing callable to be run: {}", (Object)this);
            return null;
        }
        long startTime = System.currentTimeMillis();
        Future futureOpenLineage = this.executor.submit(callable);
        Future<Object> futureCircuitBreaker = this.executor.submit(() -> {
            log.debug("Starting CircuitBreaker in background {} with interval {}", (Object)this, (Object)this.getCheckIntervalMillis());
            CircuitBreakerState circuitBreakerState = this.currentState();
            boolean isTimeoutExceeded = false;
            while (!circuitBreakerState.isClosed() && !isTimeoutExceeded) {
                Thread.sleep(this.getCheckIntervalMillis());
                circuitBreakerState = this.currentState();
                Duration runningTime = Duration.ofMillis(System.currentTimeMillis() - startTime);
                isTimeoutExceeded = this.timeout.map(t -> t.minus(runningTime).isNegative()).orElse(false);
            }
            if (circuitBreakerState.isClosed()) {
                log.warn("CircuitBreaker cancelling OpenLineage code: {}", circuitBreakerState.getReason());
            } else {
                log.warn("CircuitBreaker timeout exceeded: {}", (Object)this.timeout.get());
            }
            futureOpenLineage.cancel(true);
            return null;
        });
        try {
            result = futureOpenLineage.get();
            log.debug("Callable successfully executed. Stopping CircuitBreaker.");
            futureCircuitBreaker.cancel(true);
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            futureOpenLineage.cancel(true);
            futureCircuitBreaker.cancel(true);
            log.warn("Got error in run callable: {}", (Object)e.getMessage(), (Object)e.getCause());
            return null;
        }
        return result;
    }

    @Override
    public int getCheckIntervalMillis() {
        return this.circuitCheckIntervalInMillis;
    }

    @Override
    public void close() {
        log.info("No-op close");
    }

    public Optional<Duration> getTimeout() {
        return this.timeout;
    }

    protected boolean isPercentageValueValid(Integer value) {
        return value != null && value >= 0 && value <= 100;
    }
}

