/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.circuitBreaker;

import io.openlineage.client.circuitBreaker.CircuitBreaker;
import io.openlineage.client.circuitBreaker.CircuitBreakerConfig;
import io.openlineage.client.circuitBreaker.JavaRuntimeCircuitBreaker;
import io.openlineage.client.circuitBreaker.JavaRuntimeCircuitBreakerConfig;
import io.openlineage.client.circuitBreaker.NoOpCircuitBreaker;
import io.openlineage.client.circuitBreaker.SimpleMemoryCircuitBreaker;
import io.openlineage.client.circuitBreaker.SimpleMemoryCircuitBreakerConfig;
import io.openlineage.client.circuitBreaker.StaticCircuitBreaker;
import io.openlineage.client.circuitBreaker.StaticCircuitBreakerConfig;
import io.openlineage.client.circuitBreaker.TaskQueueCircuitBreaker;
import io.openlineage.client.circuitBreaker.TaskQueueCircuitBreakerConfig;

public class CircuitBreakerFactory {
    private final CircuitBreakerConfig circuitBreakerConfig;

    public CircuitBreakerFactory(CircuitBreakerConfig circuitBreakerConfig) {
        this.circuitBreakerConfig = circuitBreakerConfig;
    }

    public CircuitBreaker build() {
        if (this.circuitBreakerConfig instanceof JavaRuntimeCircuitBreakerConfig) {
            return new JavaRuntimeCircuitBreaker((JavaRuntimeCircuitBreakerConfig)this.circuitBreakerConfig);
        }
        if (this.circuitBreakerConfig instanceof SimpleMemoryCircuitBreakerConfig) {
            return new SimpleMemoryCircuitBreaker((SimpleMemoryCircuitBreakerConfig)this.circuitBreakerConfig);
        }
        if (this.circuitBreakerConfig instanceof StaticCircuitBreakerConfig) {
            return new StaticCircuitBreaker((StaticCircuitBreakerConfig)this.circuitBreakerConfig);
        }
        if (this.circuitBreakerConfig instanceof TaskQueueCircuitBreakerConfig) {
            return new TaskQueueCircuitBreaker((TaskQueueCircuitBreakerConfig)this.circuitBreakerConfig);
        }
        return new NoOpCircuitBreaker();
    }
}

