/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.AuthorizationMetadataObject;
import org.apache.gravitino.authorization.AuthorizationPrivilege;
import org.apache.gravitino.authorization.AuthorizationPrivilegesMappingProvider;
import org.apache.gravitino.authorization.AuthorizationSecurableObject;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.MetadataObjectChange;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.RoleChange;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.authorization.common.RangerAuthorizationProperties;
import org.apache.gravitino.authorization.ranger.RangerClientExtension;
import org.apache.gravitino.authorization.ranger.RangerHelper;
import org.apache.gravitino.authorization.ranger.RangerPrivileges;
import org.apache.gravitino.authorization.ranger.reference.VXGroup;
import org.apache.gravitino.authorization.ranger.reference.VXGroupList;
import org.apache.gravitino.authorization.ranger.reference.VXUser;
import org.apache.gravitino.authorization.ranger.reference.VXUserList;
import org.apache.gravitino.connector.authorization.AuthorizationPlugin;
import org.apache.gravitino.exceptions.AuthorizationPluginException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.ranger.RangerServiceException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerAuthorizationPlugin
implements AuthorizationPlugin,
AuthorizationPrivilegesMappingProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuthorizationPlugin.class);
    protected static final String HDFS_SERVICE_TYPE = "hdfs";
    protected static final String HADOOP_SQL_SERVICE_TYPE = "hive";
    protected String metalake;
    protected final String rangerServiceName;
    protected RangerClientExtension rangerClient;
    protected RangerHelper rangerHelper;
    @VisibleForTesting
    public final String rangerAdminName;

    protected RangerAuthorizationPlugin(String metalake, Map<String, String> config) {
        this.metalake = metalake;
        RangerAuthorizationProperties rangerAuthorizationProperties = new RangerAuthorizationProperties(config);
        rangerAuthorizationProperties.validate();
        String rangerUrl = config.get("authorization.ranger.admin.url");
        String authType = config.get("authorization.ranger.auth.type");
        this.rangerAdminName = config.get("authorization.ranger.username");
        String password = config.get("authorization.ranger.password");
        this.rangerServiceName = config.get("authorization.ranger.service.name");
        this.rangerClient = new RangerClientExtension(rangerUrl, authType, this.rangerAdminName, password);
        this.createRangerServiceIfNecessary(config, this.rangerServiceName);
        this.rangerHelper = new RangerHelper(this.rangerClient, this.rangerAdminName, this.rangerServiceName, this.ownerMappingRule(), this.policyResourceDefinesRule());
    }

    @VisibleForTesting
    public String getMetalake() {
        return this.metalake;
    }

    @VisibleForTesting
    public RangerHelper getRangerHelper() {
        return this.rangerHelper;
    }

    @VisibleForTesting
    public void setRangerHelper(RangerHelper rangerHelper) {
        this.rangerHelper = rangerHelper;
    }

    @VisibleForTesting
    public RangerClientExtension getRangerClient() {
        return this.rangerClient;
    }

    @VisibleForTesting
    public void setRangerClient(RangerClientExtension rangerClient) {
        this.rangerClient = rangerClient;
    }

    public abstract List<String> policyResourceDefinesRule();

    protected abstract RangerPolicy createPolicyAddResources(AuthorizationMetadataObject var1);

    protected abstract List<RangerPolicy> wildcardSearchPolies(AuthorizationMetadataObject var1);

    public abstract RangerPolicy findManagedPolicy(AuthorizationMetadataObject var1) throws AuthorizationPluginException;

    protected abstract void updatePolicyByMetadataObject(MetadataObject.Type var1, AuthorizationMetadataObject var2, AuthorizationMetadataObject var3);

    protected RangerPolicy preciseFindPolicy(AuthorizationMetadataObject authzMetadataObject, Map<String, String> preciseFilters) throws AuthorizationPluginException {
        List<Object> policies = this.wildcardSearchPolies(authzMetadataObject);
        if (!policies.isEmpty()) {
            policies = policies.stream().filter(policy -> policy.getResources().entrySet().stream().allMatch(entry -> preciseFilters.containsKey(entry.getKey()) && ((RangerPolicy.RangerPolicyResource)entry.getValue()).getValues().size() == 1 && ((RangerPolicy.RangerPolicyResource)entry.getValue()).getValues().contains(preciseFilters.get(entry.getKey())))).collect(Collectors.toList());
        }
        if (policies.size() > 1) {
            throw new AuthorizationPluginException("Each metadata object can have at most one policy.", new Object[0]);
        }
        if (policies.isEmpty()) {
            return null;
        }
        RangerPolicy policy2 = policies.get(0);
        policy2.getPolicyItems().forEach(RangerHelper::checkPolicyItemAccess);
        policy2.getDenyPolicyItems().forEach(RangerHelper::checkPolicyItemAccess);
        policy2.getRowFilterPolicyItems().forEach(RangerHelper::checkPolicyItemAccess);
        policy2.getDataMaskPolicyItems().forEach(RangerHelper::checkPolicyItemAccess);
        return policy2;
    }

    protected RangerPolicy addOwnerToNewPolicy(AuthorizationMetadataObject metadataObject, Owner newOwner) {
        RangerPolicy policy = this.createPolicyAddResources(metadataObject);
        this.ownerMappingRule().forEach(ownerPrivilege -> {
            RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
            policyItem.getAccesses().add(new RangerPolicy.RangerPolicyItemAccess(ownerPrivilege.getName()));
            if (newOwner != null) {
                if (newOwner.type() == Owner.Type.USER) {
                    policyItem.getUsers().add(newOwner.name());
                } else {
                    policyItem.getGroups().add(newOwner.name());
                }
                policyItem.getRoles().add("GRAVITINO_OWNER_ROLE");
            }
            policy.getPolicyItems().add(policyItem);
        });
        return policy;
    }

    protected RangerPolicy addOwnerRoleToNewPolicy(AuthorizationMetadataObject metadataObject, String ownerRoleName) {
        RangerPolicy policy = this.createPolicyAddResources(metadataObject);
        this.ownerMappingRule().forEach(ownerPrivilege -> {
            RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
            policyItem.getAccesses().add(new RangerPolicy.RangerPolicyItemAccess(ownerPrivilege.getName()));
            policyItem.getRoles().add(this.rangerHelper.generateGravitinoRoleName(ownerRoleName));
            policy.getPolicyItems().add(policyItem);
        });
        return policy;
    }

    public Boolean onRoleCreated(Role role) throws AuthorizationPluginException {
        if (!this.validAuthorizationOperation(role.securableObjects())) {
            return false;
        }
        this.rangerHelper.createRangerRoleIfNotExists(role.name(), false);
        return this.onRoleUpdated(role, (RoleChange[])role.securableObjects().stream().map(securableObject -> RoleChange.addSecurableObject((String)role.name(), (SecurableObject)securableObject)).toArray(RoleChange[]::new));
    }

    public Boolean onRoleAcquired(Role role) throws AuthorizationPluginException {
        if (!this.validAuthorizationOperation(role.securableObjects())) {
            return false;
        }
        return this.rangerHelper.checkRangerRole(role.name());
    }

    public Boolean onRoleDeleted(Role role) throws AuthorizationPluginException {
        if (!this.validAuthorizationOperation(role.securableObjects())) {
            return false;
        }
        this.onRoleUpdated(role, (RoleChange[])role.securableObjects().stream().map(securableObject -> RoleChange.removeSecurableObject((String)role.name(), (SecurableObject)securableObject)).toArray(RoleChange[]::new));
        try {
            this.rangerClient.deleteRole(this.rangerHelper.generateGravitinoRoleName(role.name()), this.rangerAdminName, this.rangerServiceName);
        }
        catch (RangerServiceException e) {
            if (this.rangerHelper.getRangerRole(role.name()) == null) {
                LOG.info("Ranger delete role: {} failed!", (Object)role, (Object)e);
            }
            throw new AuthorizationPluginException("Fail to delete role %s exception: %s", new Object[]{role, e.getMessage()});
        }
        return Boolean.TRUE;
    }

    public Boolean onRoleUpdated(Role role, RoleChange ... changes) throws AuthorizationPluginException {
        for (RoleChange change : changes) {
            List authzSecurableObjects;
            SecurableObject securableObject;
            if (change instanceof RoleChange.AddSecurableObject) {
                securableObject = ((RoleChange.AddSecurableObject)change).getSecurableObject();
                if (!this.validAuthorizationOperation(Arrays.asList(securableObject))) {
                    return Boolean.FALSE;
                }
                authzSecurableObjects = this.translatePrivilege(securableObject);
                authzSecurableObjects.forEach(authzSecurableObject -> {
                    if (!this.doAddSecurableObject(role.name(), (AuthorizationSecurableObject)authzSecurableObject)) {
                        throw new AuthorizationPluginException("Failed to add the securable object to the Ranger policy!", new Object[0]);
                    }
                });
                continue;
            }
            if (change instanceof RoleChange.RemoveSecurableObject) {
                securableObject = ((RoleChange.RemoveSecurableObject)change).getSecurableObject();
                if (!this.validAuthorizationOperation(Arrays.asList(securableObject))) {
                    return Boolean.FALSE;
                }
                authzSecurableObjects = this.translatePrivilege(securableObject);
                authzSecurableObjects.stream().forEach(authzSecurableObject -> {
                    if (!this.removeSecurableObject(role.name(), (AuthorizationSecurableObject)authzSecurableObject)) {
                        throw new AuthorizationPluginException("Failed to add the securable object to the Ranger policy!", new Object[0]);
                    }
                });
                continue;
            }
            if (change instanceof RoleChange.UpdateSecurableObject) {
                SecurableObject oldSecurableObject = ((RoleChange.UpdateSecurableObject)change).getSecurableObject();
                if (!this.validAuthorizationOperation(Arrays.asList(oldSecurableObject))) {
                    return Boolean.FALSE;
                }
                SecurableObject newSecurableObject = ((RoleChange.UpdateSecurableObject)change).getNewSecurableObject();
                if (!this.validAuthorizationOperation(Arrays.asList(newSecurableObject))) {
                    return Boolean.FALSE;
                }
                Preconditions.checkArgument((oldSecurableObject.fullName().equals(newSecurableObject.fullName()) && oldSecurableObject.type().equals((Object)newSecurableObject.type()) ? 1 : 0) != 0, (Object)"The old and new securable objects metadata must be equal!");
                List rangerOldSecurableObjects = this.translatePrivilege(oldSecurableObject);
                List rangerNewSecurableObjects = this.translatePrivilege(newSecurableObject);
                rangerOldSecurableObjects.forEach(AuthorizationSecurableObject2 -> this.removeSecurableObject(role.name(), (AuthorizationSecurableObject)AuthorizationSecurableObject2));
                rangerNewSecurableObjects.forEach(AuthorizationSecurableObject2 -> this.doAddSecurableObject(role.name(), (AuthorizationSecurableObject)AuthorizationSecurableObject2));
                continue;
            }
            throw new IllegalArgumentException("Unsupported role change type: " + (change == null ? "null" : change.getClass().getSimpleName()));
        }
        return Boolean.TRUE;
    }

    public Boolean onMetadataUpdated(MetadataObjectChange ... changes) throws RuntimeException {
        for (MetadataObjectChange change : changes) {
            MetadataObject metadataObject;
            if (change instanceof MetadataObjectChange.RenameMetadataObject) {
                metadataObject = ((MetadataObjectChange.RenameMetadataObject)change).metadataObject();
                MetadataObject newMetadataObject = ((MetadataObjectChange.RenameMetadataObject)change).newMetadataObject();
                Preconditions.checkArgument((metadataObject.type() == newMetadataObject.type() ? 1 : 0) != 0, (Object)"The old and new metadata object type must be equal!");
                if (metadataObject.type() == MetadataObject.Type.METALAKE) {
                    this.metalake = newMetadataObject.name();
                    continue;
                }
                if (metadataObject.type() == MetadataObject.Type.CATALOG) continue;
                List oldAuthzMetadataObjects = this.translateMetadataObject(metadataObject);
                List newAuthzMetadataObjects = this.translateMetadataObject(newMetadataObject);
                Preconditions.checkArgument((oldAuthzMetadataObjects.size() == newAuthzMetadataObjects.size() ? 1 : 0) != 0, (Object)"The old and new metadata objects size must be equal!");
                for (int i = 0; i < oldAuthzMetadataObjects.size(); ++i) {
                    AuthorizationMetadataObject newAuthzMetadataObject;
                    AuthorizationMetadataObject oldAuthMetadataObject = (AuthorizationMetadataObject)oldAuthzMetadataObjects.get(i);
                    if (oldAuthMetadataObject.equals(newAuthzMetadataObject = (AuthorizationMetadataObject)newAuthzMetadataObjects.get(i))) {
                        LOG.info("The metadata object({}) and new metadata object({}) are equal, so ignore rename!", (Object)oldAuthMetadataObject.fullName(), (Object)newAuthzMetadataObject.fullName());
                        continue;
                    }
                    this.renameMetadataObject(oldAuthMetadataObject, newAuthzMetadataObject);
                }
                continue;
            }
            if (change instanceof MetadataObjectChange.RemoveMetadataObject) {
                metadataObject = ((MetadataObjectChange.RemoveMetadataObject)change).metadataObject();
                List authzMetadataObjects = this.translateMetadataObject(metadataObject);
                authzMetadataObjects.stream().forEach(this::removeMetadataObject);
                continue;
            }
            throw new IllegalArgumentException("Unsupported metadata object change type: " + (change == null ? "null" : change.getClass().getSimpleName()));
        }
        return Boolean.TRUE;
    }

    public Boolean onOwnerSet(MetadataObject metadataObject, Owner preOwner, Owner newOwner) throws AuthorizationPluginException {
        Preconditions.checkArgument((newOwner != null ? 1 : 0) != 0, (Object)"The newOwner must be not null");
        String preOwnerUserName = null;
        String preOwnerGroupName = null;
        String newOwnerUserName = null;
        String newOwnerGroupName = null;
        AuditInfo auditInfo = AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build();
        if (preOwner != null) {
            if (preOwner.type() == Owner.Type.USER) {
                preOwnerUserName = preOwner.name();
            } else {
                preOwnerGroupName = preOwner.name();
            }
        }
        if (newOwner.type() == Owner.Type.USER) {
            newOwnerUserName = newOwner.name();
            UserEntity userEntity = UserEntity.builder().withId(Long.valueOf(1L)).withName(newOwnerUserName).withRoleNames(Collections.emptyList()).withRoleIds(Collections.emptyList()).withAuditInfo(auditInfo).build();
            this.onUserAdded((User)userEntity);
        } else {
            newOwnerGroupName = newOwner.name();
            GroupEntity groupEntity = GroupEntity.builder().withId(Long.valueOf(1L)).withName(newOwnerGroupName).withRoleNames(Collections.emptyList()).withRoleIds(Collections.emptyList()).withAuditInfo(auditInfo).build();
            this.onGroupAdded((Group)groupEntity);
        }
        List rangerSecurableObjects = this.translateOwner(metadataObject);
        switch (metadataObject.type()) {
            case METALAKE: 
            case CATALOG: {
                String ownerRoleName = metadataObject.type() == MetadataObject.Type.METALAKE ? "GRAVITINO_METALAKE_OWNER_ROLE" : "GRAVITINO_CATALOG_OWNER_ROLE";
                this.rangerHelper.createRangerRoleIfNotExists(ownerRoleName, true);
                this.rangerHelper.createRangerRoleIfNotExists("GRAVITINO_OWNER_ROLE", true);
                try {
                    if (preOwnerUserName != null || preOwnerGroupName != null) {
                        GrantRevokeRoleRequest revokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(ownerRoleName, preOwnerUserName, preOwnerGroupName);
                        this.rangerClient.revokeRole(this.rangerServiceName, revokeRoleRequest);
                    }
                    if (newOwnerUserName != null || newOwnerGroupName != null) {
                        GrantRevokeRoleRequest grantRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(ownerRoleName, newOwnerUserName, newOwnerGroupName);
                        this.rangerClient.grantRole(this.rangerServiceName, grantRoleRequest);
                    }
                }
                catch (RangerServiceException e) {
                    LOG.warn("Grant owner role: {} failed!", (Object)ownerRoleName, (Object)e);
                }
                rangerSecurableObjects.forEach(rangerSecurableObject -> {
                    RangerPolicy policy = this.findManagedPolicy((AuthorizationMetadataObject)rangerSecurableObject);
                    try {
                        if (policy == null) {
                            policy = this.addOwnerRoleToNewPolicy((AuthorizationMetadataObject)rangerSecurableObject, ownerRoleName);
                            this.rangerClient.createPolicy(policy);
                        } else {
                            this.rangerHelper.updatePolicyOwnerRole(policy, ownerRoleName);
                            this.rangerClient.updatePolicy(policy.getId(), policy);
                        }
                    }
                    catch (RangerServiceException e) {
                        throw new AuthorizationPluginException((Throwable)e, "Failed to add the owner to the Ranger!", new Object[0]);
                    }
                });
                break;
            }
            case SCHEMA: 
            case TABLE: 
            case FILESET: {
                rangerSecurableObjects.stream().forEach(AuthorizationSecurableObject2 -> {
                    RangerPolicy policy = this.findManagedPolicy((AuthorizationMetadataObject)AuthorizationSecurableObject2);
                    try {
                        if (policy == null) {
                            policy = this.addOwnerToNewPolicy((AuthorizationMetadataObject)AuthorizationSecurableObject2, newOwner);
                            this.rangerClient.createPolicy(policy);
                        } else {
                            this.rangerHelper.updatePolicyOwner(policy, preOwner, newOwner);
                            this.rangerClient.updatePolicy(policy.getId(), policy);
                        }
                    }
                    catch (RangerServiceException e) {
                        throw new AuthorizationPluginException((Throwable)e, "Failed to add the owner to the Ranger!", new Object[0]);
                    }
                });
                break;
            }
            default: {
                throw new AuthorizationPluginException("The owner privilege is not supported for the securable object: %s", new Object[]{metadataObject.type()});
            }
        }
        return Boolean.TRUE;
    }

    public Boolean onGrantedRolesToUser(List<Role> roles, User user) throws AuthorizationPluginException {
        if (roles.stream().anyMatch(role -> !this.validAuthorizationOperation(role.securableObjects()))) {
            return false;
        }
        this.onUserAdded(user);
        roles.stream().forEach(role -> {
            this.rangerHelper.createRangerRoleIfNotExists(role.name(), false);
            GrantRevokeRoleRequest grantRevokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(role.name(), user.name(), null);
            try {
                this.rangerClient.grantRole(this.rangerServiceName, grantRevokeRoleRequest);
            }
            catch (RangerServiceException e) {
                throw new AuthorizationPluginException("Fail to grant role %s to user %s, exception: %s", new Object[]{role.name(), user.name(), e.getMessage()});
            }
        });
        return Boolean.TRUE;
    }

    public Boolean onRevokedRolesFromUser(List<Role> roles, User user) throws AuthorizationPluginException {
        if (roles.stream().anyMatch(role -> !this.validAuthorizationOperation(role.securableObjects()))) {
            return false;
        }
        this.onUserAdded(user);
        roles.stream().forEach(role -> {
            this.rangerHelper.checkRangerRole(role.name());
            GrantRevokeRoleRequest grantRevokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(role.name(), user.name(), null);
            try {
                this.rangerClient.revokeRole(this.rangerServiceName, grantRevokeRoleRequest);
            }
            catch (RangerServiceException e) {
                throw new AuthorizationPluginException("Fail to revoke role %s from user %s, exception: %s", new Object[]{role.name(), user.name(), e.getMessage()});
            }
        });
        return Boolean.TRUE;
    }

    public Boolean onGrantedRolesToGroup(List<Role> roles, Group group) throws AuthorizationPluginException {
        if (roles.stream().anyMatch(role -> !this.validAuthorizationOperation(role.securableObjects()))) {
            return false;
        }
        this.onGroupAdded(group);
        roles.stream().forEach(role -> {
            this.rangerHelper.createRangerRoleIfNotExists(role.name(), false);
            GrantRevokeRoleRequest grantRevokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(role.name(), null, group.name());
            try {
                this.rangerClient.grantRole(this.rangerServiceName, grantRevokeRoleRequest);
            }
            catch (RangerServiceException e) {
                throw new AuthorizationPluginException("Fail to grant role: %s to group %s, exception: %s.", new Object[]{role, group, e.getMessage()});
            }
        });
        return Boolean.TRUE;
    }

    public Boolean onRevokedRolesFromGroup(List<Role> roles, Group group) throws AuthorizationPluginException {
        if (roles.stream().anyMatch(role -> !this.validAuthorizationOperation(role.securableObjects()))) {
            return false;
        }
        this.onGroupAdded(group);
        roles.stream().forEach(role -> {
            this.rangerHelper.checkRangerRole(role.name());
            GrantRevokeRoleRequest grantRevokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(role.name(), null, group.name());
            try {
                this.rangerClient.revokeRole(this.rangerServiceName, grantRevokeRoleRequest);
            }
            catch (RangerServiceException e) {
                throw new AuthorizationPluginException("Fail to revoke role %s from group %s, exception: %s", new Object[]{role.name(), group.name(), e.getMessage()});
            }
        });
        return Boolean.TRUE;
    }

    public Boolean onUserAdded(User user) throws AuthorizationPluginException {
        return this.getUserId(user.name()).map(id -> {
            LOG.warn("The user({}) already exists in the Ranger!", (Object)user.name());
            return Boolean.FALSE;
        }).orElseGet(() -> {
            VXUser rangerUser = VXUser.builder().withName(user.name()).withDescription(user.name()).build();
            return this.rangerClient.createUser(rangerUser);
        });
    }

    public Boolean onUserRemoved(User user) throws AuthorizationPluginException {
        return this.getUserId(user.name()).map(id -> this.rangerClient.deleteUser((Long)id)).orElseGet(() -> {
            LOG.warn("The user({}) doesn't exist in the Ranger!", (Object)user.name());
            return Boolean.FALSE;
        });
    }

    public Boolean onUserAcquired(User user) throws AuthorizationPluginException {
        return this.getUserId(user.name()).map(id -> Boolean.TRUE).orElseGet(() -> {
            LOG.warn("The user({}) doesn't exist in the Ranger!", (Object)user);
            return Boolean.FALSE;
        });
    }

    public Boolean onGroupAdded(Group group) throws AuthorizationPluginException {
        return this.rangerClient.createGroup(VXGroup.builder().withName(group.name()).withDescription(group.name()).build());
    }

    public Boolean onGroupRemoved(Group group) throws AuthorizationPluginException {
        Optional<Long> groupId = this.getGroupId(group.name());
        return groupId.map(id -> this.rangerClient.deleteGroup((Long)id)).orElseGet(() -> {
            LOG.warn("The group({}) doesn't exist in the Ranger!", (Object)group.name());
            return Boolean.FALSE;
        });
    }

    public Boolean onGroupAcquired(Group group) {
        if (!this.getGroupId(group.name()).isPresent()) {
            LOG.warn("The group({}) doesn't exist in the Ranger!", (Object)group);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void createRangerServiceIfNecessary(Map<String, String> config, String serviceName) {
        try {
            this.rangerClient.getService(serviceName);
        }
        catch (RangerServiceException rse) {
            if (Boolean.parseBoolean(config.get("authorization.ranger.service.create-if-absent")) && ClientResponse.Status.NOT_FOUND.equals((Object)rse.getStatus())) {
                try {
                    RangerService rangerService = new RangerService();
                    rangerService.setType(this.getServiceType());
                    rangerService.setName(serviceName);
                    rangerService.setConfigs(this.getServiceConfigs(config));
                    this.rangerClient.createService(rangerService);
                    List policies = this.rangerClient.getPoliciesInService(serviceName);
                    for (RangerPolicy policy : policies) {
                        this.rangerClient.deletePolicy(policy.getId());
                    }
                }
                catch (RangerServiceException crse) {
                    throw new AuthorizationPluginException("Fail to create ranger service %s, exception: %s", new Object[]{serviceName, crse.getMessage()});
                }
            }
            throw new AuthorizationPluginException("Fail to get ranger service name %s, exception: %s", new Object[]{serviceName, rse.getMessage()});
        }
    }

    private boolean doAddSecurableObject(String roleName, AuthorizationSecurableObject securableObject) {
        RangerPolicy policy = this.findManagedPolicy((AuthorizationMetadataObject)securableObject);
        if (policy != null) {
            List allowPrivileges = securableObject.privileges().stream().filter(privilege -> privilege.condition() == Privilege.Condition.ALLOW).collect(Collectors.toList());
            List denyPrivileges = securableObject.privileges().stream().filter(privilege -> privilege.condition() == Privilege.Condition.DENY).collect(Collectors.toList());
            Set policyPrivileges = policy.getPolicyItems().stream().filter(policyItem -> policyItem.getRoles().contains(this.rangerHelper.generateGravitinoRoleName(roleName))).flatMap(policyItem -> policyItem.getAccesses().stream()).map(RangerPolicy.RangerPolicyItemAccess::getType).map(RangerPrivileges::valueOf).collect(Collectors.toSet());
            Set policyDenyPrivileges = policy.getDenyPolicyItems().stream().filter(policyItem -> policyItem.getRoles().contains(this.rangerHelper.generateGravitinoRoleName(roleName))).flatMap(policyItem -> policyItem.getAccesses().stream()).map(RangerPolicy.RangerPolicyItemAccess::getType).map(RangerPrivileges::valueOf).collect(Collectors.toSet());
            if (policyPrivileges.containsAll(allowPrivileges) && policyDenyPrivileges.containsAll(denyPrivileges)) {
                LOG.info("The privilege({}) already added to Ranger policy({})!", (Object)policy.getName(), (Object)securableObject.fullName());
                return true;
            }
        } else {
            policy = this.createPolicyAddResources((AuthorizationMetadataObject)securableObject);
        }
        this.rangerHelper.addPolicyItem(policy, roleName, securableObject);
        try {
            if (policy.getId() == null) {
                this.rangerClient.createPolicy(policy);
            } else {
                this.rangerClient.updatePolicy(policy.getId(), policy);
            }
        }
        catch (RangerServiceException e) {
            throw new AuthorizationPluginException((Throwable)e, "Failed to add the securable object to the Ranger!", new Object[0]);
        }
        return true;
    }

    private boolean removeSecurableObject(String roleName, AuthorizationSecurableObject authzSecurableObject) {
        RangerPolicy policy = this.findManagedPolicy((AuthorizationMetadataObject)authzSecurableObject);
        if (policy == null) {
            LOG.warn("Cannot find the Ranger policy for the Ranger securable object({})!", (Object)authzSecurableObject.fullName());
            return true;
        }
        authzSecurableObject.privileges().stream().forEach(rangerPrivilege -> {
            if (rangerPrivilege.condition() == Privilege.Condition.ALLOW) {
                policy.getPolicyItems().forEach(policyItem -> this.removePolicyItemIfEqualRoleName((RangerPolicy.RangerPolicyItem)policyItem, authzSecurableObject, roleName));
            } else {
                policy.getDenyPolicyItems().forEach(policyItem -> this.removePolicyItemIfEqualRoleName((RangerPolicy.RangerPolicyItem)policyItem, authzSecurableObject, roleName));
            }
        });
        policy.getPolicyItems().removeIf(policyItem -> policyItem.getRoles().isEmpty() && policyItem.getUsers().isEmpty() && policyItem.getGroups().isEmpty());
        policy.getDenyPolicyItems().removeIf(policyItem -> policyItem.getRoles().isEmpty() && policyItem.getUsers().isEmpty() && policyItem.getGroups().isEmpty());
        try {
            if (policy.getPolicyItems().isEmpty() && policy.getDenyPolicyItems().isEmpty()) {
                this.rangerClient.deletePolicy(policy.getId());
            } else {
                this.rangerClient.updatePolicy(policy.getId(), policy);
            }
        }
        catch (RangerServiceException e) {
            LOG.error("Failed to remove the policy item from the Ranger policy {}!", (Object)policy);
            throw new AuthorizationPluginException((Throwable)e, "Failed to remove the securable object from Ranger!", new Object[0]);
        }
        return true;
    }

    private void removePolicyItemIfEqualRoleName(RangerPolicy.RangerPolicyItem policyItem, AuthorizationSecurableObject AuthorizationSecurableObject2, String roleName) {
        roleName = this.rangerHelper.generateGravitinoRoleName(roleName);
        boolean match = policyItem.getAccesses().stream().allMatch(access -> {
            boolean matchPrivilege = AuthorizationSecurableObject2.privileges().stream().anyMatch(privilege -> privilege.equalsTo(access.getType()));
            return matchPrivilege;
        });
        if (match) {
            policyItem.getRoles().removeIf(roleName::equals);
        }
    }

    protected abstract void renameMetadataObject(AuthorizationMetadataObject var1, AuthorizationMetadataObject var2);

    protected abstract void removeMetadataObject(AuthorizationMetadataObject var1);

    protected void removePolicyByMetadataObject(AuthorizationMetadataObject authzMetadataObject) {
        RangerPolicy policy = this.findManagedPolicy(authzMetadataObject);
        if (policy != null) {
            this.rangerHelper.removeAllGravitinoManagedPolicyItem(policy);
        }
    }

    protected String getConfValue(Map<String, String> conf, String key, String defaultValue) {
        if (conf.containsKey(key)) {
            return conf.get(key);
        }
        return defaultValue;
    }

    protected abstract String getServiceType();

    protected abstract Map<String, String> getServiceConfigs(Map<String, String> var1);

    protected int getPrefixLength() {
        return "authorization.ranger".length() + 1;
    }

    public void close() throws IOException {
    }

    public abstract AuthorizationSecurableObject generateAuthorizationSecurableObject(AuthorizationMetadataObject var1, Set<AuthorizationPrivilege> var2);

    public boolean validAuthorizationOperation(List<SecurableObject> securableObjects) {
        return securableObjects.stream().allMatch(securableObject -> {
            AtomicBoolean match = new AtomicBoolean(true);
            securableObject.privileges().stream().forEach(privilege -> {
                if (!privilege.canBindTo(securableObject.type())) {
                    LOG.error("The privilege({}) is not supported for the metadata object({})!", (Object)privilege.name(), (Object)securableObject.fullName());
                    match.set(false);
                }
            });
            return match.get();
        });
    }

    private Optional<Long> getUserId(String name) {
        VXUserList list = this.rangerClient.searchUser((Map<String, String>)ImmutableMap.of((Object)"name", (Object)name));
        if (list.getListSize() > 0) {
            for (VXUser vxUser : list.getList()) {
                if (!vxUser.getName().equals(name)) continue;
                return Optional.of(vxUser.getId());
            }
        }
        return Optional.empty();
    }

    private Optional<Long> getGroupId(String name) {
        VXGroupList vxGroupList = this.rangerClient.searchGroup((Map<String, String>)ImmutableMap.of((Object)"name", (Object)name));
        try {
            for (VXGroup group : vxGroupList.getList()) {
                String value = (String)FieldUtils.readField((Object)group, (String)"name", (boolean)true);
                if (!name.equals(value)) continue;
                return Optional.of(group.getId());
            }
        }
        catch (Exception e) {
            throw new AuthorizationPluginException("Fail to get the field name of class VXGroup", new Object[0]);
        }
        return Optional.empty();
    }
}

