/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.AuthorizationMetadataObject;
import org.apache.gravitino.authorization.AuthorizationPrivilege;
import org.apache.gravitino.authorization.AuthorizationSecurableObject;
import org.apache.gravitino.authorization.MetadataObjectChange;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.SecurableObjects;
import org.apache.gravitino.authorization.ranger.RangerAuthorizationPlugin;
import org.apache.gravitino.authorization.ranger.RangerHadoopSQLMetadataObject;
import org.apache.gravitino.authorization.ranger.RangerHadoopSQLSecurableObject;
import org.apache.gravitino.authorization.ranger.RangerHelper;
import org.apache.gravitino.authorization.ranger.RangerPrivileges;
import org.apache.gravitino.authorization.ranger.reference.RangerDefines;
import org.apache.gravitino.exceptions.AuthorizationPluginException;
import org.apache.ranger.RangerServiceException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizationHadoopSQLPlugin
extends RangerAuthorizationPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuthorizationHadoopSQLPlugin.class);

    public RangerAuthorizationHadoopSQLPlugin(String metalake, Map<String, String> config) {
        super(metalake, config);
    }

    public Map<Privilege.Name, Set<AuthorizationPrivilege>> privilegesMappingRule() {
        return ImmutableMap.of((Object)Privilege.Name.CREATE_CATALOG, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.CREATE)), (Object)Privilege.Name.USE_CATALOG, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.SELECT)), (Object)Privilege.Name.CREATE_SCHEMA, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.CREATE)), (Object)Privilege.Name.USE_SCHEMA, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.SELECT)), (Object)Privilege.Name.CREATE_TABLE, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.CREATE)), (Object)Privilege.Name.MODIFY_TABLE, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.SELECT), (Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.UPDATE), (Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.ALTER), (Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.WRITE)), (Object)Privilege.Name.SELECT_TABLE, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.SELECT)));
    }

    @Override
    public RangerPolicy findManagedPolicy(AuthorizationMetadataObject authzMetadataObject) throws AuthorizationPluginException {
        List nsMetadataObj = authzMetadataObject.names();
        HashMap<String, String> preciseFilters = new HashMap<String, String>();
        for (int i = 0; i < nsMetadataObj.size() && i < this.policyResourceDefinesRule().size(); ++i) {
            preciseFilters.put(this.policyResourceDefinesRule().get(i), (String)nsMetadataObj.get(i));
        }
        return this.preciseFindPolicy(authzMetadataObject, preciseFilters);
    }

    @Override
    protected List<RangerPolicy> wildcardSearchPolies(AuthorizationMetadataObject authzMetadataObject) {
        List<String> resourceDefines = this.policyResourceDefinesRule();
        HashMap<String, String> searchFilters = new HashMap<String, String>();
        searchFilters.put("serviceName", this.rangerServiceName);
        for (int i = 0; i < authzMetadataObject.names().size() && i < resourceDefines.size(); ++i) {
            searchFilters.put("resource:" + resourceDefines.get(i), (String)authzMetadataObject.names().get(i));
        }
        try {
            return this.rangerClient.findPolicies(searchFilters);
        }
        catch (RangerServiceException e) {
            throw new AuthorizationPluginException((Throwable)e, "Failed to find policies in Ranger", new Object[0]);
        }
    }

    @Override
    protected void renameMetadataObject(AuthorizationMetadataObject authzMetadataObject, AuthorizationMetadataObject newAuthzMetadataObject) {
        ImmutableList mappingOldAndNewMetadata;
        if (newAuthzMetadataObject.type().equals((Object)RangerHadoopSQLMetadataObject.Type.SCHEMA)) {
            mappingOldAndNewMetadata = ImmutableList.of((Object)Pair.of((Object)((String)authzMetadataObject.names().get(0)), (Object)((String)newAuthzMetadataObject.names().get(0))), (Object)Pair.of((Object)"*", (Object)"*"), (Object)Pair.of((Object)"*", (Object)"*"));
        } else if (newAuthzMetadataObject.type().equals((Object)RangerHadoopSQLMetadataObject.Type.TABLE)) {
            mappingOldAndNewMetadata = ImmutableList.of((Object)Pair.of((Object)((String)authzMetadataObject.names().get(0)), (Object)((String)newAuthzMetadataObject.names().get(0))), (Object)Pair.of((Object)((String)authzMetadataObject.names().get(1)), (Object)((String)newAuthzMetadataObject.names().get(1))), (Object)Pair.of((Object)"*", (Object)"*"));
        } else if (newAuthzMetadataObject.type().equals((Object)RangerHadoopSQLMetadataObject.Type.COLUMN)) {
            mappingOldAndNewMetadata = ImmutableList.of((Object)Pair.of((Object)((String)authzMetadataObject.names().get(0)), (Object)((String)newAuthzMetadataObject.names().get(0))), (Object)Pair.of((Object)((String)authzMetadataObject.names().get(1)), (Object)((String)newAuthzMetadataObject.names().get(1))), (Object)Pair.of((Object)((String)authzMetadataObject.names().get(2)), (Object)((String)newAuthzMetadataObject.names().get(2))));
        } else {
            throw new IllegalArgumentException("Unsupported metadata object type: " + authzMetadataObject.type());
        }
        ArrayList<String> oldMetadataNames = new ArrayList<String>();
        ArrayList<String> newMetadataNames = new ArrayList<String>();
        for (int index = 0; index < mappingOldAndNewMetadata.size(); ++index) {
            oldMetadataNames.add((String)((Pair)mappingOldAndNewMetadata.get(index)).getKey());
            newMetadataNames.add((String)((Pair)mappingOldAndNewMetadata.get(index)).getValue());
            RangerHadoopSQLMetadataObject.Type type = index == 0 ? RangerHadoopSQLMetadataObject.Type.SCHEMA : (index == 1 ? RangerHadoopSQLMetadataObject.Type.TABLE : RangerHadoopSQLMetadataObject.Type.COLUMN);
            RangerHadoopSQLMetadataObject oldHadoopSQLMetadataObject = new RangerHadoopSQLMetadataObject(AuthorizationMetadataObject.getParentFullName(oldMetadataNames), AuthorizationMetadataObject.getLastName(oldMetadataNames), type);
            RangerHadoopSQLMetadataObject newHadoopSQLMetadataObject = new RangerHadoopSQLMetadataObject(AuthorizationMetadataObject.getParentFullName(newMetadataNames), AuthorizationMetadataObject.getLastName(newMetadataNames), type);
            this.updatePolicyByMetadataObject(type.metadataObjectType(), oldHadoopSQLMetadataObject, newHadoopSQLMetadataObject);
        }
    }

    @Override
    protected void updatePolicyByMetadataObject(MetadataObject.Type operationType, AuthorizationMetadataObject oldAuthzMetaObject, AuthorizationMetadataObject newAuthzMetaObject) {
        List<RangerPolicy> oldPolicies = this.wildcardSearchPolies(oldAuthzMetaObject);
        List<RangerPolicy> existNewPolicies = this.wildcardSearchPolies(newAuthzMetaObject);
        if (oldPolicies.isEmpty()) {
            LOG.warn("Cannot find the Ranger policy for the metadata object({})!", (Object)oldAuthzMetaObject);
            return;
        }
        if (!existNewPolicies.isEmpty()) {
            LOG.warn("The Ranger policy for the metadata object({}) already exists!", (Object)newAuthzMetaObject);
        }
        ImmutableMap operationTypeIndex = ImmutableMap.of((Object)MetadataObject.Type.SCHEMA, (Object)0, (Object)MetadataObject.Type.TABLE, (Object)1, (Object)MetadataObject.Type.COLUMN, (Object)2);
        oldPolicies.stream().forEach(arg_0 -> this.lambda$updatePolicyByMetadataObject$1((Map)operationTypeIndex, operationType, oldAuthzMetaObject, newAuthzMetaObject, existNewPolicies, arg_0));
    }

    @Override
    protected void removeMetadataObject(AuthorizationMetadataObject authzMetadataObject) {
        AuthorizationMetadataObject.Type type = authzMetadataObject.type();
        if (type.equals((Object)RangerHadoopSQLMetadataObject.Type.SCHEMA)) {
            this.doRemoveSchemaMetadataObject(authzMetadataObject);
        } else if (type.equals((Object)RangerHadoopSQLMetadataObject.Type.TABLE)) {
            this.doRemoveTableMetadataObject(authzMetadataObject);
        } else if (type.equals((Object)RangerHadoopSQLMetadataObject.Type.COLUMN)) {
            this.removePolicyByMetadataObject(authzMetadataObject);
        } else {
            throw new IllegalArgumentException("Unsupported metadata object type: " + authzMetadataObject.type());
        }
    }

    private void doRemoveSchemaMetadataObject(AuthorizationMetadataObject authzMetadataObject) {
        Preconditions.checkArgument((authzMetadataObject.type() == RangerHadoopSQLMetadataObject.Type.SCHEMA ? 1 : 0) != 0, (Object)"The metadata object type must be a schema");
        Preconditions.checkArgument((authzMetadataObject.names().size() == 1 ? 1 : 0) != 0, (Object)"The metadata object's name size must be 1");
        if ("*".equals(authzMetadataObject.name())) {
            try {
                List policies = this.rangerClient.getPoliciesInService(this.rangerServiceName);
                policies.stream().filter(RangerHelper::hasGravitinoManagedPolicyItem).forEach(this.rangerHelper::removeAllGravitinoManagedPolicyItem);
            }
            catch (RangerServiceException e) {
                throw new RuntimeException(e);
            }
        } else {
            ImmutableList loop = ImmutableList.of((Object)Pair.of((Object)((Object)RangerHadoopSQLMetadataObject.Type.SCHEMA), (Object)ImmutableList.of((Object)authzMetadataObject.name())), (Object)Pair.of((Object)((Object)RangerHadoopSQLMetadataObject.Type.TABLE), (Object)ImmutableList.of((Object)authzMetadataObject.name(), (Object)"*")), (Object)Pair.of((Object)((Object)RangerHadoopSQLMetadataObject.Type.COLUMN), (Object)ImmutableList.of((Object)authzMetadataObject.name(), (Object)"*", (Object)"*")));
            for (int index = 0; index < loop.size(); ++index) {
                RangerHadoopSQLMetadataObject authzMetadataObject1 = new RangerHadoopSQLMetadataObject(AuthorizationMetadataObject.getParentFullName((List)((List)((Pair)loop.get(index)).getValue())), AuthorizationMetadataObject.getLastName((List)((List)((Pair)loop.get(index)).getValue())), (AuthorizationMetadataObject.Type)((Pair)loop.get(index)).getKey());
                this.removePolicyByMetadataObject(authzMetadataObject1);
            }
        }
    }

    private void doRemoveTableMetadataObject(AuthorizationMetadataObject authzMetadataObject) {
        ImmutableList loop = ImmutableList.of((Object)Pair.of((Object)((Object)RangerHadoopSQLMetadataObject.Type.TABLE), (Object)authzMetadataObject.names()), (Object)Pair.of((Object)((Object)RangerHadoopSQLMetadataObject.Type.COLUMN), Stream.concat(authzMetadataObject.names().stream(), Stream.of("*")).collect(Collectors.toList())));
        for (int index = 0; index < loop.size(); ++index) {
            RangerHadoopSQLMetadataObject authzMetadataObject1 = new RangerHadoopSQLMetadataObject(AuthorizationMetadataObject.getParentFullName((List)((List)((Pair)loop.get(index)).getValue())), AuthorizationMetadataObject.getLastName((List)((List)((Pair)loop.get(index)).getValue())), (AuthorizationMetadataObject.Type)((Pair)loop.get(index)).getKey());
            this.removePolicyByMetadataObject(authzMetadataObject1);
        }
    }

    public Set<AuthorizationPrivilege> ownerMappingRule() {
        return ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHadoopSQLPrivilege.ALL));
    }

    @Override
    public List<String> policyResourceDefinesRule() {
        return ImmutableList.of((Object)RangerDefines.PolicyResource.DATABASE.getName(), (Object)RangerDefines.PolicyResource.TABLE.getName(), (Object)RangerDefines.PolicyResource.COLUMN.getName());
    }

    @Override
    protected RangerPolicy createPolicyAddResources(AuthorizationMetadataObject metadataObject) {
        RangerPolicy policy = new RangerPolicy();
        policy.setService(this.rangerServiceName);
        policy.setName(metadataObject.fullName());
        List nsMetadataObject = metadataObject.names();
        for (int i = 0; i < nsMetadataObject.size(); ++i) {
            RangerPolicy.RangerPolicyResource policyResource = new RangerPolicy.RangerPolicyResource((String)nsMetadataObject.get(i));
            policy.getResources().put(this.policyResourceDefinesRule().get(i), policyResource);
        }
        return policy;
    }

    public AuthorizationSecurableObject generateAuthorizationSecurableObject(List<String> names, AuthorizationMetadataObject.Type type, Set<AuthorizationPrivilege> privileges) {
        RangerHadoopSQLMetadataObject object = new RangerHadoopSQLMetadataObject(AuthorizationMetadataObject.getParentFullName(names), AuthorizationMetadataObject.getLastName(names), type);
        return this.generateAuthorizationSecurableObject(object, privileges);
    }

    @Override
    public AuthorizationSecurableObject generateAuthorizationSecurableObject(AuthorizationMetadataObject object, Set<AuthorizationPrivilege> privileges) {
        object.validateAuthorizationMetadataObject();
        return new RangerHadoopSQLSecurableObject(object.parent(), object.name(), object.type(), privileges);
    }

    public Set<Privilege.Name> allowPrivilegesRule() {
        return ImmutableSet.of((Object)Privilege.Name.CREATE_CATALOG, (Object)Privilege.Name.USE_CATALOG, (Object)Privilege.Name.CREATE_SCHEMA, (Object)Privilege.Name.USE_SCHEMA, (Object)Privilege.Name.CREATE_TABLE, (Object)Privilege.Name.MODIFY_TABLE, (Object[])new Privilege.Name[]{Privilege.Name.SELECT_TABLE});
    }

    public Set<MetadataObject.Type> allowMetadataObjectTypesRule() {
        return ImmutableSet.of((Object)MetadataObject.Type.METALAKE, (Object)MetadataObject.Type.CATALOG, (Object)MetadataObject.Type.SCHEMA, (Object)MetadataObject.Type.TABLE, (Object)MetadataObject.Type.COLUMN);
    }

    public List<AuthorizationSecurableObject> translateOwner(MetadataObject gravitinoMetadataObject) {
        ArrayList<AuthorizationSecurableObject> rangerSecurableObjects = new ArrayList<AuthorizationSecurableObject>();
        switch (gravitinoMetadataObject.type()) {
            case METALAKE: 
            case CATALOG: {
                rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)"*"), RangerHadoopSQLMetadataObject.Type.SCHEMA, this.ownerMappingRule()));
                rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)"*", (Object)"*"), RangerHadoopSQLMetadataObject.Type.TABLE, this.ownerMappingRule()));
                rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)"*", (Object)"*", (Object)"*"), RangerHadoopSQLMetadataObject.Type.COLUMN, this.ownerMappingRule()));
                break;
            }
            case SCHEMA: {
                rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)gravitinoMetadataObject.name()), RangerHadoopSQLMetadataObject.Type.SCHEMA, this.ownerMappingRule()));
                rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)gravitinoMetadataObject.name(), (Object)"*"), RangerHadoopSQLMetadataObject.Type.TABLE, this.ownerMappingRule()));
                rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)gravitinoMetadataObject.name(), (Object)"*", (Object)"*"), RangerHadoopSQLMetadataObject.Type.COLUMN, this.ownerMappingRule()));
                break;
            }
            case TABLE: {
                this.translateMetadataObject(gravitinoMetadataObject).stream().forEach(rangerMetadataObject -> {
                    rangerSecurableObjects.add(this.generateAuthorizationSecurableObject(rangerMetadataObject.names(), RangerHadoopSQLMetadataObject.Type.TABLE, this.ownerMappingRule()));
                    rangerSecurableObjects.add(this.generateAuthorizationSecurableObject(Stream.concat(rangerMetadataObject.names().stream(), Stream.of("*")).collect(Collectors.toList()), RangerHadoopSQLMetadataObject.Type.COLUMN, this.ownerMappingRule()));
                });
                break;
            }
            default: {
                throw new AuthorizationPluginException("The owner privilege is not supported for the securable object: %s", new Object[]{gravitinoMetadataObject.type()});
            }
        }
        return rangerSecurableObjects;
    }

    public List<AuthorizationSecurableObject> translatePrivilege(SecurableObject securableObject) {
        ArrayList<AuthorizationSecurableObject> rangerSecurableObjects = new ArrayList<AuthorizationSecurableObject>();
        securableObject.privileges().stream().filter(Objects::nonNull).forEach(gravitinoPrivilege -> {
            HashSet<AuthorizationPrivilege> rangerPrivileges = new HashSet<AuthorizationPrivilege>();
            if (!this.privilegesMappingRule().containsKey(gravitinoPrivilege.name())) {
                return;
            }
            this.privilegesMappingRule().get(gravitinoPrivilege.name()).stream().forEach(rangerPrivilege -> rangerPrivileges.add(new RangerPrivileges.RangerHivePrivilegeImpl((AuthorizationPrivilege)rangerPrivilege, gravitinoPrivilege.condition())));
            block0 : switch (gravitinoPrivilege.name()) {
                case CREATE_CATALOG: {
                    break;
                }
                case USE_CATALOG: {
                    switch (securableObject.type()) {
                        case METALAKE: 
                        case CATALOG: {
                            rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)"*"), RangerHadoopSQLMetadataObject.Type.SCHEMA, rangerPrivileges));
                            break block0;
                        }
                    }
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
                case CREATE_SCHEMA: {
                    switch (securableObject.type()) {
                        case METALAKE: 
                        case CATALOG: {
                            rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)"*"), RangerHadoopSQLMetadataObject.Type.SCHEMA, rangerPrivileges));
                            break block0;
                        }
                    }
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
                case USE_SCHEMA: {
                    switch (securableObject.type()) {
                        case METALAKE: 
                        case CATALOG: {
                            rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)"*"), RangerHadoopSQLMetadataObject.Type.SCHEMA, rangerPrivileges));
                            break block0;
                        }
                        case SCHEMA: {
                            rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)securableObject.name()), RangerHadoopSQLMetadataObject.Type.SCHEMA, rangerPrivileges));
                            break block0;
                        }
                    }
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
                case CREATE_TABLE: 
                case MODIFY_TABLE: 
                case SELECT_TABLE: {
                    switch (securableObject.type()) {
                        case METALAKE: 
                        case CATALOG: {
                            rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)"*", (Object)"*"), RangerHadoopSQLMetadataObject.Type.TABLE, rangerPrivileges));
                            rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)"*", (Object)"*", (Object)"*"), RangerHadoopSQLMetadataObject.Type.COLUMN, rangerPrivileges));
                            break block0;
                        }
                        case SCHEMA: {
                            rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)securableObject.name(), (Object)"*"), RangerHadoopSQLMetadataObject.Type.TABLE, rangerPrivileges));
                            rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((List<String>)ImmutableList.of((Object)securableObject.name(), (Object)"*", (Object)"*"), RangerHadoopSQLMetadataObject.Type.COLUMN, rangerPrivileges));
                            break block0;
                        }
                        case TABLE: {
                            if (gravitinoPrivilege.name() == Privilege.Name.CREATE_TABLE) {
                                throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                            }
                            this.translateMetadataObject((MetadataObject)securableObject).stream().forEach(rangerMetadataObject -> {
                                rangerSecurableObjects.add(this.generateAuthorizationSecurableObject(rangerMetadataObject.names(), RangerHadoopSQLMetadataObject.Type.TABLE, rangerPrivileges));
                                rangerSecurableObjects.add(this.generateAuthorizationSecurableObject(Stream.concat(rangerMetadataObject.names().stream(), Stream.of("*")).collect(Collectors.toList()), RangerHadoopSQLMetadataObject.Type.COLUMN, rangerPrivileges));
                            });
                            break block0;
                        }
                    }
                    LOG.warn("The privilege %s is not supported for the securable object: %s", (Object)gravitinoPrivilege.name(), (Object)securableObject.type());
                    break;
                }
                default: {
                    LOG.warn("The privilege %s is not supported for the securable object: %s", (Object)gravitinoPrivilege.name(), (Object)securableObject.type());
                }
            }
        });
        return rangerSecurableObjects;
    }

    public List<AuthorizationMetadataObject> translateMetadataObject(MetadataObject metadataObject) {
        RangerHadoopSQLMetadataObject.Type type;
        Preconditions.checkArgument((!(metadataObject instanceof RangerPrivileges) ? 1 : 0) != 0, (Object)"The metadata object must not be a RangerPrivileges object.");
        ArrayList nsMetadataObject = Lists.newArrayList((Iterable)SecurableObjects.DOT_SPLITTER.splitToList((CharSequence)metadataObject.fullName()));
        Preconditions.checkArgument((nsMetadataObject.size() > 0 ? 1 : 0) != 0, (Object)"The metadata object must have at least one name.");
        if (metadataObject.type() == MetadataObject.Type.METALAKE || metadataObject.type() == MetadataObject.Type.CATALOG) {
            nsMetadataObject.clear();
            nsMetadataObject.add("*");
            type = RangerHadoopSQLMetadataObject.Type.SCHEMA;
        } else {
            nsMetadataObject.remove(0);
            type = RangerHadoopSQLMetadataObject.Type.fromMetadataType(metadataObject.type());
        }
        RangerHadoopSQLMetadataObject rangerHadoopSQLMetadataObject = new RangerHadoopSQLMetadataObject(AuthorizationMetadataObject.getParentFullName((List)nsMetadataObject), AuthorizationMetadataObject.getLastName((List)nsMetadataObject), type);
        rangerHadoopSQLMetadataObject.validateAuthorizationMetadataObject();
        return ImmutableList.of((Object)rangerHadoopSQLMetadataObject);
    }

    @Override
    public Boolean onMetadataUpdated(MetadataObjectChange ... changes) throws RuntimeException {
        for (MetadataObjectChange change : changes) {
            MetadataObject metadataObject;
            if (change instanceof MetadataObjectChange.RenameMetadataObject) {
                metadataObject = ((MetadataObjectChange.RenameMetadataObject)change).metadataObject();
                MetadataObject newMetadataObject = ((MetadataObjectChange.RenameMetadataObject)change).newMetadataObject();
                Preconditions.checkArgument((metadataObject.type() == newMetadataObject.type() ? 1 : 0) != 0, (Object)"The old and new metadata object types must be equal!");
                if (metadataObject.type() == MetadataObject.Type.METALAKE) {
                    this.metalake = newMetadataObject.name();
                    continue;
                }
                if (metadataObject.type() == MetadataObject.Type.CATALOG) continue;
                List<AuthorizationMetadataObject> oldAuthzMetadataObjects = this.translateMetadataObject(metadataObject);
                List<AuthorizationMetadataObject> newAuthzMetadataObjects = this.translateMetadataObject(newMetadataObject);
                Preconditions.checkArgument((oldAuthzMetadataObjects.size() == newAuthzMetadataObjects.size() ? 1 : 0) != 0, (Object)"The old and new metadata objects sizes must be equal!");
                for (int i = 0; i < oldAuthzMetadataObjects.size(); ++i) {
                    AuthorizationMetadataObject newAuthzMetadataObject;
                    AuthorizationMetadataObject oldAuthMetadataObject = oldAuthzMetadataObjects.get(i);
                    if (oldAuthMetadataObject.equals(newAuthzMetadataObject = newAuthzMetadataObjects.get(i))) {
                        LOG.info("The metadata object({}) and new metadata object({}) are equal, so ignoring rename!", (Object)oldAuthMetadataObject.fullName(), (Object)newAuthzMetadataObject.fullName());
                        continue;
                    }
                    this.renameMetadataObject(oldAuthMetadataObject, newAuthzMetadataObject);
                }
                continue;
            }
            if (change instanceof MetadataObjectChange.RemoveMetadataObject) {
                metadataObject = ((MetadataObjectChange.RemoveMetadataObject)change).metadataObject();
                List<AuthorizationMetadataObject> authzMetadataObjects = this.translateMetadataObject(metadataObject);
                authzMetadataObjects.stream().forEach(this::removeMetadataObject);
                continue;
            }
            throw new IllegalArgumentException("Unsupported metadata object change type: " + (change == null ? "null" : change.getClass().getSimpleName()));
        }
        return Boolean.TRUE;
    }

    @Override
    protected String getServiceType() {
        return "hive";
    }

    @Override
    protected Map<String, String> getServiceConfigs(Map<String, String> config) {
        return ImmutableMap.builder().put((Object)"authorization.ranger.username".substring(this.getPrefixLength()), (Object)config.get("authorization.ranger.username")).put((Object)"authorization.ranger.password".substring(this.getPrefixLength()), (Object)config.get("authorization.ranger.password")).put((Object)"authorization.ranger.jdbc.driverClassName".substring(this.getPrefixLength()), (Object)this.getConfValue(config, "authorization.ranger.jdbc.driverClassName", "org.apache.hive.jdbc.HiveDriver")).put((Object)"authorization.ranger.jdbc.url".substring(this.getPrefixLength()), (Object)this.getConfValue(config, "authorization.ranger.jdbc.url", "jdbc:hive2://127.0.0.1:8081")).build();
    }

    private /* synthetic */ void lambda$updatePolicyByMetadataObject$1(Map operationTypeIndex, MetadataObject.Type operationType, AuthorizationMetadataObject oldAuthzMetaObject, AuthorizationMetadataObject newAuthzMetaObject, List existNewPolicies, RangerPolicy policy) {
        try {
            String policyName = policy.getName();
            int index = (Integer)operationTypeIndex.get(operationType);
            if (policy.getName().equals(AuthorizationSecurableObject.DOT_JOINER.join((Iterable)oldAuthzMetaObject.names()))) {
                ArrayList policyNames = Lists.newArrayList((Iterable)AuthorizationSecurableObject.DOT_SPLITTER.splitToList((CharSequence)policyName));
                Preconditions.checkArgument((policyNames.size() >= oldAuthzMetaObject.names().size() ? 1 : 0) != 0, (Object)String.format("The policy name (%s) is invalid!", policyName));
                if (((String)policyNames.get(index)).equals("*")) {
                    return;
                }
                policyNames.set(index, (String)newAuthzMetaObject.names().get(index));
                policy.setName(AuthorizationSecurableObject.DOT_JOINER.join((Iterable)policyNames));
            }
            policy.getResources().put(this.policyResourceDefinesRule().get(index), new RangerPolicy.RangerPolicyResource((String)newAuthzMetaObject.names().get(index)));
            boolean alreadyExist = existNewPolicies.stream().anyMatch(existNewPolicy -> existNewPolicy.getName().equals(policy.getName()) || existNewPolicy.getResources().equals(policy.getResources()));
            if (alreadyExist) {
                LOG.warn("The Ranger policy for the metadata object ({}) already exists!", (Object)newAuthzMetaObject);
                return;
            }
            this.rangerClient.updatePolicy(policy.getId(), policy);
        }
        catch (RangerServiceException e) {
            LOG.error("Failed to rename the policy {}!", (Object)policy);
            throw new RuntimeException(e);
        }
    }
}

