/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergColumn;
import org.apache.gravitino.catalog.lakehouse.iceberg.converter.ConvertUtil;
import org.apache.gravitino.catalog.lakehouse.iceberg.converter.FromIcebergPartitionSpec;
import org.apache.gravitino.catalog.lakehouse.iceberg.converter.FromIcebergSortOrder;
import org.apache.gravitino.catalog.lakehouse.iceberg.converter.ToIcebergPartitionSpec;
import org.apache.gravitino.catalog.lakehouse.iceberg.converter.ToIcebergSortOrder;
import org.apache.gravitino.catalog.lakehouse.iceberg.utils.IcebergTablePropertiesUtil;
import org.apache.gravitino.connector.BaseTable;
import org.apache.gravitino.connector.TableOperations;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.rest.requests.CreateTableRequest;

public class IcebergTable
extends BaseTable {
    public static final String PROP_LOCATION = "location";
    public static final String PROP_PROVIDER = "provider";
    public static final String DEFAULT_ICEBERG_PROVIDER = "iceberg";
    public static final String ICEBERG_PARQUET_FILE_FORMAT = "parquet";
    public static final String ICEBERG_ORC_FILE_FORMAT = "orc";
    public static final String ICEBERG_AVRO_FILE_FORMAT = "avro";
    public static final String ICEBERG_COMMENT_FIELD_NAME = "comment";
    private String location;

    private IcebergTable() {
    }

    public static Map<String, String> rebuildCreateProperties(Map<String, String> createProperties) {
        String provider = createProperties.get(PROP_PROVIDER);
        if (ICEBERG_PARQUET_FILE_FORMAT.equalsIgnoreCase(provider)) {
            createProperties.put("write.format.default", ICEBERG_PARQUET_FILE_FORMAT);
        } else if (ICEBERG_AVRO_FILE_FORMAT.equalsIgnoreCase(provider)) {
            createProperties.put("write.format.default", ICEBERG_AVRO_FILE_FORMAT);
        } else if (ICEBERG_ORC_FILE_FORMAT.equalsIgnoreCase(provider)) {
            createProperties.put("write.format.default", ICEBERG_ORC_FILE_FORMAT);
        } else if (provider != null && !DEFAULT_ICEBERG_PROVIDER.equalsIgnoreCase(provider)) {
            throw new IllegalArgumentException("Unsupported format in USING: " + provider);
        }
        return createProperties;
    }

    public CreateTableRequest toCreateTableRequest() {
        Schema schema = ConvertUtil.toIcebergSchema(this);
        this.properties = this.properties == null ? Maps.newHashMap() : Maps.newHashMap((Map)this.properties);
        this.properties.put("write.distribution-mode", this.transformDistribution(this.distribution));
        CreateTableRequest.Builder builder = CreateTableRequest.builder().withName(this.name).withLocation(this.location).withSchema(schema).setProperties(IcebergTable.rebuildCreateProperties(this.properties)).withPartitionSpec(ToIcebergPartitionSpec.toPartitionSpec(schema, this.partitioning)).withWriteOrder(ToIcebergSortOrder.toSortOrder(schema, this.sortOrders));
        return builder.build();
    }

    @VisibleForTesting
    String transformDistribution(Distribution distribution) {
        switch (distribution.strategy()) {
            case HASH: {
                Preconditions.checkArgument((boolean)ArrayUtils.isEmpty((Object[])distribution.expressions()), (Object)"Iceberg's Distribution Mode.HASH does not support set expressions.");
                Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((Object[])this.partitioning), (Object)"Iceberg's Distribution Mode.HASH is distributed based on partition, but the partition is empty.");
                return DistributionMode.HASH.modeName();
            }
            case RANGE: {
                Preconditions.checkArgument((boolean)ArrayUtils.isEmpty((Object[])distribution.expressions()), (Object)"Iceberg's Distribution Mode.RANGE not support set expressions.");
                Preconditions.checkArgument((ArrayUtils.isNotEmpty((Object[])this.partitioning) || ArrayUtils.isNotEmpty((Object[])this.sortOrders) ? 1 : 0) != 0, (Object)"Iceberg's Distribution Mode.RANGE is distributed based on sortOrder or partition, but both are empty.");
                return DistributionMode.RANGE.modeName();
            }
            case NONE: {
                return DistributionMode.NONE.modeName();
            }
        }
        throw new IllegalArgumentException("Iceberg unsupported distribution strategy: " + distribution.strategy());
    }

    public static IcebergTable fromIcebergTable(TableMetadata table, String tableName) {
        HashMap<String, String> properties = new HashMap<String, String>(table.properties());
        properties.putAll(IcebergTablePropertiesUtil.buildReservedProperties(table));
        Schema schema = table.schema();
        Transform[] partitionSpec = FromIcebergPartitionSpec.fromPartitionSpec(table.spec(), schema);
        SortOrder[] sortOrder = FromIcebergSortOrder.fromSortOrder(table.sortOrder());
        IcebergColumn[] icebergColumns = (IcebergColumn[])schema.columns().stream().map(ConvertUtil::fromNestedField).toArray(IcebergColumn[]::new);
        return (IcebergTable)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)IcebergTable.builder().withComment(table.property(ICEBERG_COMMENT_FIELD_NAME, null))).withLocation(table.location()).withProperties(properties)).withColumns((Column[])icebergColumns)).withName(tableName)).withAuditInfo(AuditInfo.EMPTY)).withPartitioning(partitionSpec)).withSortOrders(sortOrder)).withDistribution(IcebergTable.getDistribution(properties))).build();
    }

    protected TableOperations newOps() {
        throw new UnsupportedOperationException("IcebergTable does not support TableOperations.");
    }

    public static Builder builder() {
        return new Builder();
    }

    private static Distribution getDistribution(Map<String, String> properties) {
        Distribution distribution = Distributions.NONE;
        String distributionName = properties.get("write.distribution-mode");
        if (null != distributionName) {
            switch (DistributionMode.fromName((String)distributionName)) {
                case HASH: {
                    distribution = Distributions.HASH;
                    break;
                }
                case RANGE: {
                    distribution = Distributions.RANGE;
                    break;
                }
            }
        }
        return distribution;
    }

    public String toString() {
        return "IcebergTable(location=" + this.getLocation() + ")";
    }

    public String getLocation() {
        return this.location;
    }

    static /* synthetic */ Column[] access$502(IcebergTable x0, Column[] x1) {
        x0.columns = x1;
        return x1;
    }

    static /* synthetic */ Transform[] access$802(IcebergTable x0, Transform[] x1) {
        x0.partitioning = x1;
        return x1;
    }

    static /* synthetic */ SortOrder[] access$1002(IcebergTable x0, SortOrder[] x1) {
        x0.sortOrders = x1;
        return x1;
    }

    public static class Builder
    extends BaseTable.BaseTableBuilder<Builder, IcebergTable> {
        private String location;

        private Builder() {
        }

        public Builder withLocation(String location) {
            this.location = location;
            return this;
        }

        protected IcebergTable internalBuild() {
            IcebergTable icebergTable = new IcebergTable();
            icebergTable.name = this.name;
            icebergTable.comment = this.comment;
            icebergTable.properties = this.properties != null ? Maps.newHashMap((Map)this.properties) : Maps.newHashMap();
            icebergTable.auditInfo = this.auditInfo;
            IcebergTable.access$502(icebergTable, this.columns);
            if (null != this.location) {
                icebergTable.location = this.location;
            } else {
                icebergTable.location = (String)icebergTable.properties.get(IcebergTable.PROP_LOCATION);
            }
            IcebergTable.access$802(icebergTable, this.partitioning);
            icebergTable.distribution = this.distribution;
            IcebergTable.access$1002(icebergTable, this.sortOrders);
            if (null != this.comment) {
                icebergTable.properties.putIfAbsent(IcebergTable.ICEBERG_COMMENT_FIELD_NAME, this.comment);
            }
            return icebergTable;
        }
    }
}

