/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.process;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.ProjectedRowData;
import org.apache.flink.table.runtime.operators.process.PassThroughCollectorBase;
import org.apache.flink.table.runtime.operators.process.RuntimeTableSemantics;

@Internal
public class PassPartitionKeysCollector
extends PassThroughCollectorBase {
    private final ProjectedRowData[] partitionKeys;

    public PassPartitionKeysCollector(Output<StreamRecord<RowData>> output, ChangelogMode changelogMode, List<RuntimeTableSemantics> tableSemantics) {
        super(output, changelogMode, tableSemantics.size());
        this.partitionKeys = new ProjectedRowData[tableSemantics.size()];
        IntStream.range(0, tableSemantics.size()).forEach(pos -> {
            this.partitionKeys[pos] = ProjectedRowData.from((int[])((RuntimeTableSemantics)tableSemantics.get(pos)).partitionByColumns());
        });
    }

    @Override
    public void setPrefix(int pos, RowData input) {
        this.prefix = this.partitionKeys[pos].replaceRow(input);
    }
}

