/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableJoinToMultiJoinForReorderRule;
import org.immutables.value.Value;

@Value.Enclosing
public class JoinToMultiJoinForReorderRule
extends RelRule<Config>
implements TransformationRule {
    public static final JoinToMultiJoinForReorderRule INSTANCE = Config.DEFAULT.toRule();

    public JoinToMultiJoinForReorderRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Join origJoin = (Join)call.rel(0);
        return origJoin.getJoinType().projectsRight();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join origJoin = (Join)call.rel(0);
        Object left = call.rel(1);
        Object right = call.rel(2);
        ArrayList<Boolean> inputNullGenFieldList = new ArrayList<Boolean>();
        this.buildInputNullGenFieldList((RelNode)left, (RelNode)right, origJoin.getJoinType(), (List<Boolean>)inputNullGenFieldList);
        ArrayList<ImmutableBitSet> projFieldsList = new ArrayList<ImmutableBitSet>();
        ArrayList<int[]> joinFieldRefCountsList = new ArrayList<int[]>();
        List<RelNode> newInputs = this.combineInputs(origJoin, (RelNode)left, (RelNode)right, (List<ImmutableBitSet>)projFieldsList, (List<int[]>)joinFieldRefCountsList, (List<Boolean>)inputNullGenFieldList);
        ArrayList<Pair<JoinRelType, RexNode>> joinSpecs = new ArrayList<Pair<JoinRelType, RexNode>>();
        this.combineOuterJoins(origJoin, newInputs, (RelNode)left, (RelNode)right, (List<Pair<JoinRelType, RexNode>>)joinSpecs, (List<Boolean>)inputNullGenFieldList);
        List<RexNode> newJoinFilters = this.combineJoinFilters(origJoin, (RelNode)left, (RelNode)right, (List<Boolean>)inputNullGenFieldList);
        ImmutableMap<Integer, ImmutableIntList> newJoinFieldRefCountsMap = this.addOnJoinFieldRefCounts(newInputs, origJoin.getRowType().getFieldCount(), origJoin.getCondition(), joinFieldRefCountsList);
        List<RexNode> newPostJoinFilters = this.combinePostJoinFilters(origJoin, (RelNode)left, (RelNode)right);
        RexBuilder rexBuilder = origJoin.getCluster().getRexBuilder();
        MultiJoin multiJoin = new MultiJoin(origJoin.getCluster(), newInputs, RexUtil.composeConjunction(rexBuilder, newJoinFilters), origJoin.getRowType(), origJoin.getJoinType() == JoinRelType.FULL, Pair.right(joinSpecs), Pair.left(joinSpecs), projFieldsList, newJoinFieldRefCountsMap, RexUtil.composeConjunction(rexBuilder, newPostJoinFilters, true));
        call.transformTo(multiJoin);
    }

    private void buildInputNullGenFieldList(RelNode left, RelNode right, JoinRelType joinType, List<Boolean> isNullGenFieldList) {
        if (joinType == JoinRelType.INNER) {
            this.buildNullGenFieldList(left, isNullGenFieldList);
            this.buildNullGenFieldList(right, isNullGenFieldList);
        } else if (joinType == JoinRelType.LEFT) {
            this.buildNullGenFieldList(left, isNullGenFieldList);
            for (int i = 0; i < right.getRowType().getFieldCount(); ++i) {
                isNullGenFieldList.add(true);
            }
        } else if (joinType == JoinRelType.RIGHT) {
            for (int i = 0; i < left.getRowType().getFieldCount(); ++i) {
                isNullGenFieldList.add(true);
            }
            this.buildNullGenFieldList(right, isNullGenFieldList);
        } else if (joinType == JoinRelType.FULL) {
            int i;
            for (i = 0; i < left.getRowType().getFieldCount(); ++i) {
                isNullGenFieldList.add(true);
            }
            for (i = 0; i < right.getRowType().getFieldCount(); ++i) {
                isNullGenFieldList.add(true);
            }
        } else {
            throw new TableException("This is a bug. Now, join to multi join rule only support Full outer join, Inner join and Left/Right join.");
        }
    }

    private void buildNullGenFieldList(RelNode rel, List<Boolean> isNullGenFieldList) {
        MultiJoin multiJoin;
        MultiJoin multiJoin2 = multiJoin = rel instanceof MultiJoin ? (MultiJoin)rel : null;
        if (multiJoin == null) {
            for (int i = 0; i < rel.getRowType().getFieldCount(); ++i) {
                isNullGenFieldList.add(false);
            }
        } else {
            List<RelNode> inputs = multiJoin.getInputs();
            List<JoinRelType> joinTypes = multiJoin.getJoinTypes();
            for (int i = 0; i < inputs.size() - 1; ++i) {
                if (joinTypes.get(i) == JoinRelType.RIGHT) {
                    this.buildInputNullGenFieldList(inputs.get(i), inputs.get(i + 1), joinTypes.get(i), isNullGenFieldList);
                    continue;
                }
                this.buildInputNullGenFieldList(inputs.get(i), inputs.get(i + 1), joinTypes.get(i + 1), isNullGenFieldList);
            }
        }
    }

    private List<RelNode> combineInputs(Join join, RelNode left, RelNode right, List<ImmutableBitSet> projFieldsList, List<int[]> joinFieldRefCountsList, List<Boolean> inputNullGenFieldList) {
        int i;
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        JoinInfo joinInfo = join.analyzeCondition();
        ImmutableIntList leftKeys = joinInfo.leftKeys;
        ImmutableIntList rightKeys = joinInfo.rightKeys;
        if (this.canCombine(left, leftKeys, join.getJoinType(), join.getJoinType().generatesNullsOnLeft(), true, inputNullGenFieldList, 0)) {
            MultiJoin leftMultiJoin = (MultiJoin)left;
            for (i = 0; i < leftMultiJoin.getInputs().size(); ++i) {
                newInputs.add(leftMultiJoin.getInput(i));
                projFieldsList.add(leftMultiJoin.getProjFields().get(i));
                joinFieldRefCountsList.add(leftMultiJoin.getJoinFieldRefCountsMap().get(i).toIntArray());
            }
        } else {
            newInputs.add(left);
            projFieldsList.add(null);
            joinFieldRefCountsList.add(new int[left.getRowType().getFieldCount()]);
        }
        if (this.canCombine(right, rightKeys, join.getJoinType(), join.getJoinType().generatesNullsOnRight(), false, inputNullGenFieldList, left.getRowType().getFieldCount())) {
            MultiJoin rightMultiJoin = (MultiJoin)right;
            for (i = 0; i < rightMultiJoin.getInputs().size(); ++i) {
                newInputs.add(rightMultiJoin.getInput(i));
                projFieldsList.add(rightMultiJoin.getProjFields().get(i));
                joinFieldRefCountsList.add(rightMultiJoin.getJoinFieldRefCountsMap().get(i).toIntArray());
            }
        } else {
            newInputs.add(right);
            projFieldsList.add(null);
            joinFieldRefCountsList.add(new int[right.getRowType().getFieldCount()]);
        }
        return newInputs;
    }

    private void combineOuterJoins(Join joinRel, List<RelNode> combinedInputs, RelNode left, RelNode right, List<Pair<JoinRelType, RexNode>> joinSpecs, List<Boolean> inputNullGenFieldList) {
        JoinRelType joinType = joinRel.getJoinType();
        JoinInfo joinInfo = joinRel.analyzeCondition();
        ImmutableIntList leftKeys = joinInfo.leftKeys;
        ImmutableIntList rightKeys = joinInfo.rightKeys;
        boolean leftCombined = this.canCombine(left, leftKeys, joinType, joinType.generatesNullsOnLeft(), true, inputNullGenFieldList, 0);
        boolean rightCombined = this.canCombine(right, rightKeys, joinType, joinType.generatesNullsOnRight(), false, inputNullGenFieldList, left.getRowType().getFieldCount());
        switch (joinType) {
            case LEFT: {
                if (leftCombined) {
                    this.copyOuterJoinInfo((MultiJoin)left, joinSpecs, 0, null, null);
                } else {
                    joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                }
                joinSpecs.add(Pair.of(joinType, joinRel.getCondition()));
                break;
            }
            case RIGHT: {
                joinSpecs.add(Pair.of(joinType, joinRel.getCondition()));
                if (rightCombined) {
                    this.copyOuterJoinInfo((MultiJoin)right, joinSpecs, left.getRowType().getFieldCount(), right.getRowType().getFieldList(), joinRel.getRowType().getFieldList());
                    break;
                }
                joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                break;
            }
            default: {
                if (leftCombined) {
                    this.copyOuterJoinInfo((MultiJoin)left, joinSpecs, 0, null, null);
                } else {
                    joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                }
                if (rightCombined) {
                    this.copyOuterJoinInfo((MultiJoin)right, joinSpecs, left.getRowType().getFieldCount(), right.getRowType().getFieldList(), joinRel.getRowType().getFieldList());
                    break;
                }
                joinSpecs.add(Pair.of(JoinRelType.INNER, null));
            }
        }
    }

    private void copyOuterJoinInfo(MultiJoin multiJoin, List<Pair<JoinRelType, RexNode>> destJoinSpecs, int adjustmentAmount, List<RelDataTypeField> srcFields, List<RelDataTypeField> destFields) {
        List<Pair<JoinRelType, RexNode>> srcJoinSpecs = Pair.zip(multiJoin.getJoinTypes(), multiJoin.getOuterJoinConditions());
        if (adjustmentAmount == 0) {
            destJoinSpecs.addAll(srcJoinSpecs);
        } else {
            assert (srcFields != null);
            assert (destFields != null);
            int nFields = srcFields.size();
            int[] adjustments = new int[nFields];
            for (int idx = 0; idx < nFields; ++idx) {
                adjustments[idx] = adjustmentAmount;
            }
            for (Pair<JoinRelType, RexNode> src : srcJoinSpecs) {
                destJoinSpecs.add(Pair.of((JoinRelType)((Object)src.left), src.right == null ? null : ((RexNode)src.right).accept(new RelOptUtil.RexInputConverter(multiJoin.getCluster().getRexBuilder(), srcFields, destFields, adjustments))));
            }
        }
    }

    private List<RexNode> combineJoinFilters(Join join, RelNode left, RelNode right, List<Boolean> inputNullGenFieldList) {
        JoinRelType joinType = join.getJoinType();
        JoinInfo joinInfo = join.analyzeCondition();
        ImmutableIntList leftKeys = joinInfo.leftKeys;
        ImmutableIntList rightKeys = joinInfo.rightKeys;
        ArrayList<RexNode> filters = new ArrayList<RexNode>();
        if (joinType != JoinRelType.LEFT && joinType != JoinRelType.RIGHT) {
            filters.add(join.getCondition());
        }
        if (this.canCombine(left, leftKeys, joinType, joinType.generatesNullsOnLeft(), true, inputNullGenFieldList, 0)) {
            filters.add(((MultiJoin)left).getJoinFilter());
        }
        if (this.canCombine(right, rightKeys, joinType, joinType.generatesNullsOnRight(), false, inputNullGenFieldList, left.getRowType().getFieldCount())) {
            MultiJoin multiJoin = (MultiJoin)right;
            filters.add(this.shiftRightFilter(join, left, multiJoin, multiJoin.getJoinFilter()));
        }
        return filters;
    }

    private boolean canCombine(RelNode input, ImmutableIntList joinKeys, JoinRelType joinType, boolean nullGenerating, boolean isLeft, List<Boolean> inputNullGenFieldList, int beginIndex) {
        if (input instanceof MultiJoin) {
            MultiJoin join = (MultiJoin)input;
            if (join.isFullOuterJoin() || nullGenerating) {
                return false;
            }
            if (joinType == JoinRelType.LEFT) {
                if (!isLeft) {
                    return false;
                }
                for (int joinKey : joinKeys) {
                    if (!inputNullGenFieldList.get(joinKey + beginIndex).booleanValue()) continue;
                    return false;
                }
            } else if (joinType == JoinRelType.RIGHT) {
                if (isLeft) {
                    return false;
                }
                for (int joinKey : joinKeys) {
                    if (!inputNullGenFieldList.get(joinKey + beginIndex).booleanValue()) continue;
                    return false;
                }
            } else if (joinType == JoinRelType.INNER) {
                for (int joinKey : joinKeys) {
                    if (!inputNullGenFieldList.get(joinKey + beginIndex).booleanValue()) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private RexNode shiftRightFilter(Join joinRel, RelNode left, MultiJoin right, RexNode rightFilter) {
        if (rightFilter == null) {
            return null;
        }
        int nFieldsOnLeft = left.getRowType().getFieldList().size();
        int nFieldsOnRight = right.getRowType().getFieldList().size();
        int[] adjustments = new int[nFieldsOnRight];
        for (int i = 0; i < nFieldsOnRight; ++i) {
            adjustments[i] = nFieldsOnLeft;
        }
        rightFilter = rightFilter.accept(new RelOptUtil.RexInputConverter(joinRel.getCluster().getRexBuilder(), right.getRowType().getFieldList(), joinRel.getRowType().getFieldList(), adjustments));
        return rightFilter;
    }

    private ImmutableMap<Integer, ImmutableIntList> addOnJoinFieldRefCounts(List<RelNode> multiJoinInputs, int nTotalFields, RexNode joinCondition, List<int[]> origJoinFieldRefCounts) {
        int[] joinCondRefCounts = new int[nTotalFields];
        joinCondition.accept(new InputReferenceCounter(joinCondRefCounts));
        HashMap<Integer, int[]> refCountsMap = new HashMap<Integer, int[]>();
        int nInputs = multiJoinInputs.size();
        int currInput = 0;
        for (int[] origRefCounts : origJoinFieldRefCounts) {
            refCountsMap.put(currInput, (int[])origRefCounts.clone());
            ++currInput;
        }
        currInput = -1;
        int startField = 0;
        int nFields = 0;
        for (int i = 0; i < nTotalFields; ++i) {
            if (joinCondRefCounts[i] == 0) continue;
            while (i >= startField + nFields) {
                startField += nFields;
                assert (++currInput < nInputs);
                nFields = multiJoinInputs.get(currInput).getRowType().getFieldCount();
            }
            int[] refCounts = (int[])refCountsMap.get(currInput);
            int n = i - startField;
            refCounts[n] = refCounts[n] + joinCondRefCounts[i];
        }
        ImmutableMap.Builder<Integer, ImmutableIntList> builder = ImmutableMap.builder();
        for (Map.Entry entry : refCountsMap.entrySet()) {
            builder.put((Integer)entry.getKey(), ImmutableIntList.of((int[])entry.getValue()));
        }
        return builder.build();
    }

    private List<RexNode> combinePostJoinFilters(Join joinRel, RelNode left, RelNode right) {
        ArrayList<RexNode> filters = new ArrayList<RexNode>();
        if (right instanceof MultiJoin) {
            MultiJoin multiRight = (MultiJoin)right;
            filters.add(this.shiftRightFilter(joinRel, left, multiRight, multiRight.getPostJoinFilter()));
        }
        if (left instanceof MultiJoin) {
            filters.add(((MultiJoin)left).getPostJoinFilter());
        }
        return filters;
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableJoinToMultiJoinForReorderRule.Config.builder().build().as(Config.class).withOperandFor(LogicalJoin.class);

        @Override
        default public JoinToMultiJoinForReorderRule toRule() {
            return new JoinToMultiJoinForReorderRule(this);
        }

        default public Config withOperandFor(Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(joinClass).inputs(b1 -> b1.operand(RelNode.class).anyInputs(), b2 -> b2.operand(RelNode.class).anyInputs())).as(Config.class);
        }
    }

    private static class InputReferenceCounter
    extends RexVisitorImpl<Void> {
        private final int[] refCounts;

        InputReferenceCounter(int[] refCounts) {
            super(true);
            this.refCounts = refCounts;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            int n = inputRef.getIndex();
            this.refCounts[n] = this.refCounts[n] + 1;
            return null;
        }
    }
}

