/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.ExpressionCodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class CharVarCharTrimPadCastRule
extends AbstractNullAwareCodeGeneratorCastRule<Object, StringData> {
    static final CharVarCharTrimPadCastRule INSTANCE = new CharVarCharTrimPadCastRule();

    private CharVarCharTrimPadCastRule() {
        super(CastRulePredicate.builder().predicate((inputType, targetType) -> targetType.is(LogicalTypeFamily.CHARACTER_STRING) && !targetType.equals((Object)VarCharType.STRING_TYPE)).build());
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        int targetLength = LogicalTypeChecks.getLength((LogicalType)targetLogicalType);
        Integer inputLength = null;
        if (inputLogicalType.is(LogicalTypeFamily.CHARACTER_STRING)) {
            inputLength = LogicalTypeChecks.getLength((LogicalType)inputLogicalType);
        }
        CastRule<?, ?> castRule = CastRuleProvider.resolve(inputLogicalType, (LogicalType)VarCharType.STRING_TYPE);
        CodeGeneratorContext codeGeneratorContext = context.getCodeGeneratorContext();
        if (castRule instanceof ExpressionCodeGeneratorCastRule) {
            String stringExpr = ((ExpressionCodeGeneratorCastRule)castRule).generateExpression(context, inputTerm, inputLogicalType, targetLogicalType);
            CastRuleUtils.CodeWriter writer = new CastRuleUtils.CodeWriter();
            if (context.legacyBehaviour() || (!CharVarCharTrimPadCastRule.couldTrim(targetLength) || inputLength != null && inputLength <= targetLength) && !CharVarCharTrimPadCastRule.couldPad(targetLogicalType, targetLength)) {
                return writer.assignStmt(returnVariable, stringExpr).toString();
            }
            return writer.ifStmt(CastRuleUtils.methodCall(stringExpr, "numChars", new Object[0]) + " > " + targetLength, thenWriter -> thenWriter.assignStmt(returnVariable, CastRuleUtils.methodCall(stringExpr, "substring", 0, targetLength)), elseWriter -> {
                if (CharVarCharTrimPadCastRule.couldPad(targetLogicalType, targetLength)) {
                    String padLength = CodeGenUtils.newName(codeGeneratorContext, "padLength");
                    String padString = CodeGenUtils.newName(codeGeneratorContext, "padString");
                    elseWriter.ifStmt(CastRuleUtils.methodCall(stringExpr, "numChars", new Object[0]) + " < " + targetLength, thenInnerWriter -> thenInnerWriter.declStmt(Integer.TYPE, padLength).assignStmt(padLength, targetLength + " - " + CastRuleUtils.methodCall(stringExpr, "numChars", new Object[0])).declStmt(BinaryStringData.class, padString).assignStmt(padString, CastRuleUtils.staticCall(BinaryStringData.class, "blankString", padLength)).assignStmt(returnVariable, CastRuleUtils.staticCall(BinaryStringDataUtil.class, "concat", stringExpr, padString)), elseInnerWriter -> elseInnerWriter.assignStmt(returnVariable, stringExpr));
                } else {
                    elseWriter.assignStmt(returnVariable, stringExpr);
                }
            }).toString();
        }
        throw new IllegalStateException("This is a bug. Please file an issue.");
    }

    static String stringExceedsLength(String strTerm, int targetLength) {
        return CastRuleUtils.methodCall(strTerm, "length", new Object[0]) + " > " + targetLength;
    }

    static String stringShouldPad(String strTerm, int targetLength) {
        return CastRuleUtils.methodCall(strTerm, "length", new Object[0]) + " < " + targetLength;
    }

    static boolean couldTrim(int targetLength) {
        return targetLength < Integer.MAX_VALUE;
    }

    static boolean couldPad(LogicalType targetType, int targetLength) {
        return targetType.is(LogicalTypeRoot.CHAR) && targetLength < Integer.MAX_VALUE;
    }

    static CastRuleUtils.CodeWriter padAndTrimStringIfNeeded(CastRuleUtils.CodeWriter writer, LogicalType targetType, boolean legacyBehaviour, int length, String resultStringTerm, String builderTerm, CodeGeneratorContext codeGeneratorContext) {
        writer.declStmt(String.class, resultStringTerm).assignStmt(resultStringTerm, CastRuleUtils.methodCall(builderTerm, "toString", new Object[0]));
        if (!legacyBehaviour && (CharVarCharTrimPadCastRule.couldTrim(length) || CharVarCharTrimPadCastRule.couldPad(targetType, length))) {
            writer.ifStmt(CharVarCharTrimPadCastRule.stringExceedsLength(builderTerm, length), thenWriter -> thenWriter.assignStmt(resultStringTerm, CastRuleUtils.methodCall(builderTerm, "substring", 0, CastRuleUtils.staticCall(Math.class, "min", CastRuleUtils.methodCall(builderTerm, "length", new Object[0]), length))), elseWriter -> CharVarCharTrimPadCastRule.padStringIfNeeded(elseWriter, targetType, legacyBehaviour, length, resultStringTerm, codeGeneratorContext));
        }
        return writer;
    }

    static void padStringIfNeeded(CastRuleUtils.CodeWriter writer, LogicalType targetType, boolean legacyBehaviour, int length, String returnTerm, CodeGeneratorContext codeGeneratorContext) {
        if (!legacyBehaviour && CharVarCharTrimPadCastRule.couldPad(targetType, length)) {
            String padLength = CodeGenUtils.newName(codeGeneratorContext, "padLength");
            String sbPadding = CodeGenUtils.newName(codeGeneratorContext, "sbPadding");
            writer.ifStmt(CharVarCharTrimPadCastRule.stringShouldPad(returnTerm, length), thenWriter -> thenWriter.declStmt(Integer.TYPE, padLength).assignStmt(padLength, length + " - " + CastRuleUtils.methodCall(returnTerm, "length", new Object[0])).declStmt(StringBuilder.class, sbPadding).assignStmt(sbPadding, CastRuleUtils.constructorCall(StringBuilder.class, new Object[0])).forStmt(padLength, (idx, loopWriter) -> loopWriter.stmt(CastRuleUtils.methodCall(sbPadding, "append", "\" \"")), codeGeneratorContext).assignStmt(returnTerm, returnTerm + " + " + CastRuleUtils.methodCall(sbPadding, "toString", new Object[0])));
        }
    }
}

