/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.otel;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.otel.OpenTelemetryReporterOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OpenTelemetryReporterBase {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTelemetryReporterBase.class);
    protected Resource resource = Resource.getDefault();
    protected MetricExporter exporter;

    protected OpenTelemetryReporterBase() {
    }

    protected void open(MetricConfig metricConfig) {
        if (metricConfig.containsKey((Object)OpenTelemetryReporterOptions.SERVICE_NAME.key())) {
            this.resource = this.resource.merge(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)metricConfig.getString(OpenTelemetryReporterOptions.SERVICE_NAME.key(), (String)OpenTelemetryReporterOptions.SERVICE_NAME.defaultValue()))));
        }
        if (metricConfig.containsKey((Object)OpenTelemetryReporterOptions.SERVICE_VERSION.key())) {
            this.resource = this.resource.merge(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_VERSION, (Object)metricConfig.getString(OpenTelemetryReporterOptions.SERVICE_VERSION.key(), (String)OpenTelemetryReporterOptions.SERVICE_VERSION.defaultValue()))));
        }
    }
}

