/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.otel;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.GaugeData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.data.SummaryData;
import io.opentelemetry.sdk.metrics.data.ValueAtQuantile;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableValueAtQuantile;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.otel.MetricMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenTelemetryMetricAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTelemetryMetricAdapter.class);
    static final double[] HISTOGRAM_QUANTILES = new double[]{0.5, 0.75, 0.95, 0.99};
    static final InstrumentationScopeInfo INSTRUMENTATION_SCOPE_INFO = InstrumentationScopeInfo.create((String)"io.confluent.flink.common.metrics");

    OpenTelemetryMetricAdapter() {
    }

    public static Optional<MetricData> convertCounter(CollectionMetadata collectionMetadata, Long count, Long previousCount, MetricMetadata metricMetadata) {
        long delta = count - previousCount;
        if (delta < 0L) {
            LOG.warn("Non-monotonic counter {}: current count {} is less than previous count {}", new Object[]{metricMetadata.getName(), count, previousCount});
            return Optional.empty();
        }
        Boolean isMonotonic = true;
        return Optional.of(ImmutableMetricData.createLongSum((Resource)collectionMetadata.getOtelResource(), (InstrumentationScopeInfo)INSTRUMENTATION_SCOPE_INFO, (String)metricMetadata.getName(), (String)"", (String)"", (SumData)ImmutableSumData.create((boolean)isMonotonic, (AggregationTemporality)AggregationTemporality.DELTA, Collections.singleton(ImmutableLongPointData.create((long)collectionMetadata.getStartEpochNanos(), (long)collectionMetadata.getEpochNanos(), (Attributes)OpenTelemetryMetricAdapter.convertVariables(metricMetadata.getVariables()), (long)delta)))));
    }

    public static Optional<MetricData> convertGauge(CollectionMetadata collectionMetadata, Gauge<?> gauge, MetricMetadata metricMetadata) {
        if (!(gauge.getValue() instanceof Number)) {
            LOG.debug("Couldn't adapt gauge {} with value {} and type {}", new Object[]{metricMetadata.getName(), gauge.getValue(), gauge.getValue().getClass().getName()});
            return Optional.empty();
        }
        Number number = (Number)gauge.getValue();
        if (number instanceof Long || number instanceof Integer) {
            return Optional.of(ImmutableMetricData.createLongGauge((Resource)collectionMetadata.getOtelResource(), (InstrumentationScopeInfo)INSTRUMENTATION_SCOPE_INFO, (String)metricMetadata.getName(), (String)"", (String)"", (GaugeData)ImmutableGaugeData.create(Collections.singleton(ImmutableLongPointData.create((long)collectionMetadata.getStartEpochNanos(), (long)collectionMetadata.getEpochNanos(), (Attributes)OpenTelemetryMetricAdapter.convertVariables(metricMetadata.getVariables()), (long)number.longValue())))));
        }
        return Optional.of(ImmutableMetricData.createDoubleGauge((Resource)collectionMetadata.getOtelResource(), (InstrumentationScopeInfo)INSTRUMENTATION_SCOPE_INFO, (String)metricMetadata.getName(), (String)"", (String)"", (GaugeData)ImmutableGaugeData.create(Collections.singleton(ImmutableDoublePointData.create((long)collectionMetadata.getStartEpochNanos(), (long)collectionMetadata.getEpochNanos(), (Attributes)OpenTelemetryMetricAdapter.convertVariables(metricMetadata.getVariables()), (double)number.doubleValue())))));
    }

    public static List<MetricData> convertMeter(CollectionMetadata collectionMetadata, Meter meter, Long count, Long previousCount, MetricMetadata metricMetadata) {
        ArrayList<MetricData> metricData = new ArrayList<MetricData>();
        OpenTelemetryMetricAdapter.convertCounter(collectionMetadata, count, previousCount, metricMetadata.subMetric("count")).ifPresent(metricData::add);
        OpenTelemetryMetricAdapter.convertGauge(collectionMetadata, () -> ((Meter)meter).getRate(), metricMetadata.subMetric("rate")).ifPresent(metricData::add);
        return metricData;
    }

    public static Optional<MetricData> convertHistogram(CollectionMetadata collectionMetadata, Histogram histogram, MetricMetadata metricMetadata) {
        ArrayList<ValueAtQuantile> quantileList = new ArrayList<ValueAtQuantile>();
        quantileList.add(ImmutableValueAtQuantile.create((double)0.0, (double)histogram.getStatistics().getMin()));
        for (double histogramQuantile : HISTOGRAM_QUANTILES) {
            quantileList.add(ImmutableValueAtQuantile.create((double)histogramQuantile, (double)histogram.getStatistics().getQuantile(histogramQuantile)));
        }
        quantileList.add(ImmutableValueAtQuantile.create((double)1.0, (double)histogram.getStatistics().getMax()));
        quantileList.add(ImmutableValueAtQuantile.create((double)1.0, (double)histogram.getStatistics().getMax()));
        return Optional.of(ImmutableMetricData.createDoubleSummary((Resource)collectionMetadata.getOtelResource(), (InstrumentationScopeInfo)INSTRUMENTATION_SCOPE_INFO, (String)metricMetadata.getName(), (String)"", (String)"", (SummaryData)ImmutableSummaryData.create(Collections.singleton(ImmutableSummaryPointData.create((long)collectionMetadata.getStartEpochNanos(), (long)collectionMetadata.getEpochNanos(), (Attributes)OpenTelemetryMetricAdapter.convertVariables(metricMetadata.getVariables()), (long)histogram.getCount(), (double)(histogram.getStatistics().getMean() * (double)histogram.getCount()), quantileList)))));
    }

    private static Attributes convertVariables(Map<String, String> variables) {
        AttributesBuilder builder = Attributes.builder();
        variables.forEach((arg_0, arg_1) -> ((AttributesBuilder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    public static class CollectionMetadata {
        private final Resource otelResource;
        private final long startEpochNanos;
        private final long epochNanos;

        public CollectionMetadata(Resource otelResource, long startEpochNanos, long epochNanos) {
            this.otelResource = otelResource;
            this.startEpochNanos = startEpochNanos;
            this.epochNanos = epochNanos;
        }

        public Resource getOtelResource() {
            return this.otelResource;
        }

        public long getStartEpochNanos() {
            return this.startEpochNanos;
        }

        public long getEpochNanos() {
            return this.epochNanos;
        }
    }
}

