/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.lang.reflect.Constructor;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongComparator;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeQueryable;
import org.apache.flink.util.Preconditions;

@Deprecated
@Internal
public final class TimeIntervalTypeInfo<T>
extends TypeInformation<T>
implements AtomicType<T>,
DataTypeQueryable {
    private static final long serialVersionUID = -1816179424364825258L;
    public static final TimeIntervalTypeInfo<Integer> INTERVAL_MONTHS = new TimeIntervalTypeInfo<Integer>(Integer.class, (TypeSerializer<Integer>)IntSerializer.INSTANCE, (Class<TypeComparator<Integer>>)IntComparator.class);
    public static final TimeIntervalTypeInfo<Long> INTERVAL_MILLIS = new TimeIntervalTypeInfo<Long>(Long.class, (TypeSerializer<Long>)LongSerializer.INSTANCE, (Class<TypeComparator<Long>>)LongComparator.class);
    private final Class<T> clazz;
    private final TypeSerializer<T> serializer;
    private final Class<? extends TypeComparator<T>> comparatorClass;

    private TimeIntervalTypeInfo(Class<T> clazz, TypeSerializer<T> serializer, Class<? extends TypeComparator<T>> comparatorClass) {
        this.clazz = (Class)Preconditions.checkNotNull(clazz);
        this.serializer = (TypeSerializer)Preconditions.checkNotNull(serializer);
        this.comparatorClass = (Class)Preconditions.checkNotNull(comparatorClass);
    }

    @Override
    public DataType getDataType() {
        if (this.clazz == Long.class) {
            return (DataType)DataTypes.INTERVAL(DataTypes.SECOND(3)).bridgedTo(Long.class);
        }
        if (this.clazz == Integer.class) {
            return (DataType)DataTypes.INTERVAL(DataTypes.MONTH()).bridgedTo(Integer.class);
        }
        throw new UnsupportedOperationException("Unsupported interval type info.");
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.clazz;
    }

    public boolean isKeyType() {
        return true;
    }

    public TypeSerializer<T> createSerializer(SerializerConfig config) {
        return this.serializer;
    }

    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        try {
            Constructor<TypeComparator<T>> constructor = this.comparatorClass.getConstructor(Boolean.TYPE);
            return constructor.newInstance(sortOrderAscending);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize comparator " + this.comparatorClass.getName(), e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.serializer, this.comparatorClass);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof TimeIntervalTypeInfo;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeIntervalTypeInfo) {
            TimeIntervalTypeInfo other = (TimeIntervalTypeInfo)obj;
            return other.canEqual(this) && this.clazz.equals(other.clazz) && this.serializer == other.serializer && this.comparatorClass.equals(other.comparatorClass);
        }
        return false;
    }

    public String toString() {
        return TimeIntervalTypeInfo.class.getSimpleName() + "(" + this.clazz.getSimpleName() + ")";
    }
}

