/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public class ToTimestampLtzTypeStrategy
implements TypeStrategy {
    private static final int DEFAULT_PRECISION = 3;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List<DataType> argumentTypes = callContext.getArgumentDataTypes();
        int argCount = argumentTypes.size();
        if (argCount < 1 || argCount > 3) {
            throw new ValidationException("Unsupported argument type. TO_TIMESTAMP_LTZ requires 1 to 3 arguments, but " + argCount + " were provided.");
        }
        LogicalType firstType = argumentTypes.get(0).getLogicalType();
        LogicalTypeRoot firstTypeRoot = firstType.getTypeRoot();
        if (argCount == 1) {
            if (this.isCharacterType(firstTypeRoot) || firstType.is(LogicalTypeFamily.NUMERIC)) return Optional.of((DataType)DataTypes.TIMESTAMP_LTZ(3).nullable());
            throw new ValidationException("Unsupported argument type. When taking 1 argument, TO_TIMESTAMP_LTZ accepts an argument of type <VARCHAR>, <CHAR>, or <NUMERIC>.");
        }
        if (argCount == 2) {
            LogicalType secondType = argumentTypes.get(1).getLogicalType();
            LogicalTypeRoot secondTypeRoot = secondType.getTypeRoot();
            if (firstType.is(LogicalTypeFamily.NUMERIC)) {
                if (secondTypeRoot == LogicalTypeRoot.INTEGER) return Optional.of((DataType)DataTypes.TIMESTAMP_LTZ(3).nullable());
                throw new ValidationException("Unsupported argument type. TO_TIMESTAMP_LTZ(<NUMERIC>, <INTEGER>) requires the second argument to be <INTEGER>.");
            }
            if (!this.isCharacterType(firstTypeRoot)) throw new ValidationException("Unsupported argument type. When taking 2 arguments, TO_TIMESTAMP_LTZ requires the first argument to be of type <VARCHAR>, <CHAR>, or <NUMERIC>.");
            if (this.isCharacterType(secondTypeRoot)) return Optional.of((DataType)DataTypes.TIMESTAMP_LTZ(3).nullable());
            throw new ValidationException("Unsupported argument type. If the first argument is of type <VARCHAR> or <CHAR>, TO_TIMESTAMP_LTZ requires the second argument to be of type <VARCHAR> or <CHAR>.");
        }
        if (argCount != 3 || this.isCharacterType(firstTypeRoot) && this.isCharacterType(argumentTypes.get(1).getLogicalType().getTypeRoot()) && this.isCharacterType(argumentTypes.get(2).getLogicalType().getTypeRoot())) return Optional.of((DataType)DataTypes.TIMESTAMP_LTZ(3).nullable());
        throw new ValidationException("Unsupported argument type. When taking 3 arguments, TO_TIMESTAMP_LTZ requires all three arguments to be of type <VARCHAR> or <CHAR>.");
    }

    private boolean isCharacterType(LogicalTypeRoot typeRoot) {
        return typeRoot == LogicalTypeRoot.CHAR || typeRoot == LogicalTypeRoot.VARCHAR;
    }
}

