/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.formats.common.Converter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.FormatSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.MappingIterator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SerializableFunction;
import org.apache.flink.util.function.SerializableSupplier;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@PublicEvolving
public class CsvReaderFormat<T>
extends SimpleStreamFormat<T> {
    private static final long serialVersionUID = 1L;
    private final SerializableSupplier<CsvMapper> mapperFactory;
    private final SerializableFunction<CsvMapper, CsvSchema> schemaGenerator;
    private final Class<Object> rootType;
    private final Converter<Object, T, Void> converter;
    private final TypeInformation<T> typeInformation;
    private boolean ignoreParseErrors;

    <R> CsvReaderFormat(SerializableSupplier<CsvMapper> mapperFactory, SerializableFunction<CsvMapper, CsvSchema> schemaGenerator, Class<R> rootType, Converter<R, T, Void> converter, TypeInformation<T> typeInformation, boolean ignoreParseErrors) {
        this.mapperFactory = (SerializableSupplier)Preconditions.checkNotNull(mapperFactory);
        this.schemaGenerator = (SerializableFunction)Preconditions.checkNotNull(schemaGenerator);
        this.rootType = (Class)Preconditions.checkNotNull(rootType);
        this.typeInformation = (TypeInformation)Preconditions.checkNotNull(typeInformation);
        this.converter = (Converter)Preconditions.checkNotNull(converter);
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public static <T> CsvReaderFormat<T> forSchema(CsvSchema schema, TypeInformation<T> typeInformation) {
        return CsvReaderFormat.forSchema((SerializableSupplier<CsvMapper>)((SerializableSupplier & Serializable)JacksonMapperFactory::createCsvMapper), (SerializableFunction<CsvMapper, CsvSchema>)(SerializableFunction & Serializable)ignored -> schema, typeInformation);
    }

    public static <T> CsvReaderFormat<T> forSchema(SerializableSupplier<CsvMapper> mapperFactory, SerializableFunction<CsvMapper, CsvSchema> schemaGenerator, TypeInformation<T> typeInformation) {
        return new CsvReaderFormat<Object>(mapperFactory, schemaGenerator, typeInformation.getTypeClass(), (value, context) -> value, typeInformation, false);
    }

    public static <T> CsvReaderFormat<T> forPojo(Class<T> pojoType) {
        return CsvReaderFormat.forSchema((SerializableSupplier<CsvMapper>)((SerializableSupplier & Serializable)JacksonMapperFactory::createCsvMapper), (SerializableFunction<CsvMapper, CsvSchema>)(SerializableFunction & Serializable)mapper -> mapper.schemaFor(pojoType).withoutQuoteChar(), TypeInformation.of(pojoType));
    }

    public CsvReaderFormat<T> withIgnoreParseErrors() {
        return new CsvReaderFormat<T>(this.mapperFactory, this.schemaGenerator, this.rootType, this.converter, this.typeInformation, true);
    }

    public StreamFormat.Reader<T> createReader(Configuration config, FSDataInputStream stream) throws IOException {
        CsvMapper csvMapper = (CsvMapper)this.mapperFactory.get();
        return new Reader<Object, T>(csvMapper.readerFor(this.rootType).with((FormatSchema)this.schemaGenerator.apply((Object)csvMapper)).readValues((InputStream)stream), this.converter, this.ignoreParseErrors);
    }

    public TypeInformation<T> getProducedType() {
        return this.typeInformation;
    }

    private static final class Reader<R, T>
    implements StreamFormat.Reader<T> {
        private final MappingIterator<R> iterator;
        private final Converter<R, T, Void> converter;
        private final boolean ignoreParseErrors;

        public Reader(MappingIterator<R> iterator, Converter<R, T, Void> converter, boolean ignoreParseErrors) {
            this.iterator = (MappingIterator)Preconditions.checkNotNull(iterator);
            this.converter = (Converter)Preconditions.checkNotNull(converter);
            this.ignoreParseErrors = ignoreParseErrors;
        }

        @Nullable
        public T read() throws IOException {
            while (this.iterator.hasNext()) {
                try {
                    Object nextElement = this.iterator.next();
                    return this.converter.convert(nextElement, null);
                }
                catch (Throwable t) {
                    if (this.ignoreParseErrors) continue;
                    throw t;
                }
            }
            return null;
        }

        public void close() throws IOException {
            this.iterator.close();
        }
    }
}

