/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.flink.runtime.scheduler.adaptivebatch.OperatorsFinished;
import org.apache.flink.runtime.scheduler.adaptivebatch.StreamGraphOptimizationStrategy;
import org.apache.flink.streaming.api.graph.StreamGraphContext;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamEdge;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamGraph;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamNode;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.CustomPartitionerWrapper;
import org.apache.flink.streaming.runtime.partitioner.ForwardForConsecutiveHashPartitioner;
import org.apache.flink.streaming.runtime.partitioner.GlobalPartitioner;
import org.apache.flink.streaming.runtime.partitioner.KeyGroupStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.RebalancePartitioner;
import org.apache.flink.streaming.runtime.partitioner.ShufflePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.table.runtime.operators.join.adaptive.AdaptiveJoin;
import org.apache.flink.table.runtime.partitioner.BinaryHashPartitioner;
import org.apache.flink.table.runtime.partitioner.RowDataCustomStreamPartitioner;
import org.apache.flink.util.Preconditions;

public abstract class BaseAdaptiveJoinOperatorOptimizationStrategy
implements StreamGraphOptimizationStrategy {
    protected static final int LEFT_INPUT_TYPE_NUMBER = 1;
    protected static final int RIGHT_INPUT_TYPE_NUMBER = 2;
    private static final Set<Class<?>> PARTITIONERS_CAN_CORRECT_KEY_GROUP_AUTOMATIC = Set.of(BinaryHashPartitioner.class, BroadcastPartitioner.class, CustomPartitionerWrapper.class, GlobalPartitioner.class, KeyGroupStreamPartitioner.class, RebalancePartitioner.class, RowDataCustomStreamPartitioner.class, ShufflePartitioner.class);
    private static final Set<Class<?>> PARTITIONERS_CAN_CORRECT_KEY_GROUP_FORCED = Set.of(ForwardForConsecutiveHashPartitioner.class);

    protected void visitDownstreamAdaptiveJoinNode(OperatorsFinished operatorsFinished, StreamGraphContext context) {
        ImmutableStreamGraph streamGraph = context.getStreamGraph();
        List finishedStreamNodeIds = operatorsFinished.getFinishedStreamNodeIds();
        HashMap<ImmutableStreamNode, List> joinNodesWithInEdges = new HashMap<ImmutableStreamNode, List>();
        for (Integer finishedStreamNodeId : finishedStreamNodeIds) {
            for (ImmutableStreamEdge streamEdge : streamGraph.getStreamNode(finishedStreamNodeId).getOutEdges()) {
                ImmutableStreamNode downstreamNode = streamGraph.getStreamNode(Integer.valueOf(streamEdge.getTargetId()));
                if (!(downstreamNode.getOperatorFactory() instanceof AdaptiveJoin)) continue;
                joinNodesWithInEdges.computeIfAbsent(downstreamNode, k -> new ArrayList()).add(streamEdge);
            }
        }
        for (ImmutableStreamNode joinNode : joinNodesWithInEdges.keySet()) {
            this.tryOptimizeAdaptiveJoin(operatorsFinished, context, joinNode, (List)joinNodesWithInEdges.get(joinNode), (AdaptiveJoin)joinNode.getOperatorFactory());
        }
    }

    abstract void tryOptimizeAdaptiveJoin(OperatorsFinished var1, StreamGraphContext var2, ImmutableStreamNode var3, List<ImmutableStreamEdge> var4, AdaptiveJoin var5);

    static boolean canPerformOptimizationAutomatic(StreamGraphContext context, ImmutableStreamNode adaptiveJoinNode) {
        return adaptiveJoinNode.getOutEdges().stream().allMatch(edge -> {
            Class<?> classOfOutputPartitioner = ((StreamPartitioner)Preconditions.checkNotNull((Object)context.getOutputPartitioner(edge.getEdgeId(), Integer.valueOf(edge.getSourceId()), Integer.valueOf(edge.getTargetId())))).getClass();
            return !edge.isIntraInputKeyCorrelated() || PARTITIONERS_CAN_CORRECT_KEY_GROUP_AUTOMATIC.contains(classOfOutputPartitioner);
        });
    }

    static boolean canPerformOptimizationForced(StreamGraphContext context, ImmutableStreamNode adaptiveJoinNode) {
        return adaptiveJoinNode.getOutEdges().stream().allMatch(edge -> {
            Class<?> classOfOutputPartitioner = ((StreamPartitioner)Preconditions.checkNotNull((Object)context.getOutputPartitioner(edge.getEdgeId(), Integer.valueOf(edge.getSourceId()), Integer.valueOf(edge.getTargetId())))).getClass();
            return !edge.isIntraInputKeyCorrelated() || PARTITIONERS_CAN_CORRECT_KEY_GROUP_AUTOMATIC.contains(classOfOutputPartitioner) || PARTITIONERS_CAN_CORRECT_KEY_GROUP_FORCED.contains(classOfOutputPartitioner);
        });
    }
}

