/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.SqlFunctionUtils;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;

@Internal
public class RegexpSubstrFunction
extends BuiltInScalarFunction {
    public RegexpSubstrFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.REGEXP_SUBSTR, context);
    }

    @Nullable
    public StringData eval(@Nullable StringData str, @Nullable StringData regex) {
        Matcher matcher = SqlFunctionUtils.getRegexpMatcher(str, regex);
        return matcher != null && matcher.find() ? BinaryStringData.fromString((String)matcher.group(0)) : null;
    }
}

