/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.ArrayList;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.SqlFunctionUtils;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;

@Internal
public class RegexpExtractAllFunction
extends BuiltInScalarFunction {
    public RegexpExtractAllFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.REGEXP_EXTRACT_ALL, context);
    }

    @Nullable
    public ArrayData eval(@Nullable StringData str, @Nullable StringData regex) {
        return this.eval(str, regex, 1);
    }

    @Nullable
    public ArrayData eval(@Nullable StringData str, @Nullable StringData regex, @Nullable Number extractIndex) {
        if (extractIndex == null || extractIndex.longValue() < 0L) {
            return null;
        }
        Matcher matcher = SqlFunctionUtils.getRegexpMatcher(str, regex);
        if (matcher == null) {
            return null;
        }
        if ((long)matcher.groupCount() < extractIndex.longValue()) {
            return null;
        }
        ArrayList<BinaryStringData> list = new ArrayList<BinaryStringData>();
        while (matcher.find()) {
            list.add(BinaryStringData.fromString((String)matcher.group(extractIndex.intValue())));
        }
        return new GenericArrayData(list.toArray());
    }
}

