/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AbstractAsyncContextSpanEventInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.util.ScopeUtils;
import java.util.Objects;

public abstract class AsyncContextSpanEventSimpleAroundInterceptor
extends AbstractAsyncContextSpanEventInterceptor
implements AroundInterceptor {
    protected final MethodDescriptor methodDescriptor;

    public AsyncContextSpanEventSimpleAroundInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        super(traceContext);
        this.methodDescriptor = Objects.requireNonNull(methodDescriptor, "methodDescriptor");
    }

    @Override
    public void before(Object target, Object[] args) {
        block6: {
            AsyncContext asyncContext;
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if ((asyncContext = this.getAsyncContext(target, args)) == null) {
                if (this.isTrace) {
                    this.logger.trace("AsyncContext not found");
                }
                return;
            }
            Trace trace = this.getAsyncTrace(asyncContext);
            if (trace == null) {
                return;
            }
            ScopeUtils.entryAsyncTraceScope(trace);
            try {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                this.beforeTrace(asyncContext, trace, recorder, target, args);
                this.doInBeforeTrace(recorder, asyncContext, target, args);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block6;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    protected void beforeTrace(AsyncContext asyncContext, Trace trace, SpanEventRecorder recorder, Object target, Object[] args) {
    }

    protected abstract void doInBeforeTrace(SpanEventRecorder var1, AsyncContext var2, Object var3, Object[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        AsyncContext asyncContext;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((asyncContext = this.getAsyncContext(target, args, result, throwable)) == null) {
            if (this.isTrace) {
                this.logger.trace("AsyncContext not found");
            }
            return;
        }
        Trace trace = asyncContext.currentAsyncTraceObject();
        if (trace == null) {
            return;
        }
        if (!ScopeUtils.leaveAsyncTraceScope(trace)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to leave scope of async trace {}.", (Object)trace);
            }
            this.deleteAsyncContext(trace, asyncContext);
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            this.afterTrace(asyncContext, trace, recorder, target, args, result, throwable);
            this.doInAfterTrace(recorder, target, args, result, throwable);
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER error. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
            if (ScopeUtils.isAsyncTraceEndScope(trace)) {
                this.deleteAsyncContext(trace, asyncContext);
            }
        }
    }

    protected void afterTrace(AsyncContext asyncContext, Trace trace, SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
    }

    protected abstract void doInAfterTrace(SpanEventRecorder var1, Object var2, Object[] var3, Object var4, Throwable var5);
}

