/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.transformer;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallbackChecker;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import java.util.Objects;

@InterfaceStability.Unstable
public class MatchableTransformTemplate
extends TransformTemplate {
    public MatchableTransformTemplate(InstrumentContext instrumentContext) {
        super(instrumentContext);
    }

    public void transform(Matcher matcher, TransformCallback transformCallback) {
        Objects.requireNonNull(matcher, "matcher");
        Objects.requireNonNull(transformCallback, "transformCallback");
        InstrumentContext instrumentContext = this.getInstrumentContext();
        instrumentContext.addClassFileTransformer(matcher, transformCallback);
    }

    public void transform(Matcher matcher, Class<? extends TransformCallback> transformCallbackClass) {
        Objects.requireNonNull(matcher, "matcher");
        Objects.requireNonNull(transformCallbackClass, "transformCallbackClass");
        TransformCallbackChecker.validate(transformCallbackClass);
        String transformCallbackName = transformCallbackClass.getName();
        InstrumentContext instrumentContext = this.getInstrumentContext();
        instrumentContext.addClassFileTransformer(matcher, transformCallbackName);
    }
}

