/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher.operator;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.AbstractMatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.MatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operator.MatcherOperator;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import java.util.Objects;

@InterfaceStability.Unstable
public class AndMatcherOperator
extends AbstractMatcherOperand
implements MatcherOperator {
    private final MatcherOperand leftOperand;
    private final MatcherOperand rightOperand;

    public AndMatcherOperator(MatcherOperand leftOperand, MatcherOperand rightOperand) {
        this.leftOperand = Objects.requireNonNull(leftOperand, "leftOperand");
        this.rightOperand = Objects.requireNonNull(rightOperand, "rightOperand");
    }

    @Override
    public int getPrecedence() {
        return 2;
    }

    @Override
    public int getExecutionCost() {
        return this.leftOperand.getExecutionCost() + this.rightOperand.getExecutionCost();
    }

    @Override
    public boolean isOperator() {
        return true;
    }

    @Override
    public boolean isIndex() {
        return false;
    }

    @Override
    public MatcherOperand getLeftOperand() {
        return this.leftOperand;
    }

    @Override
    public MatcherOperand getRightOperand() {
        return this.rightOperand;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(this.leftOperand);
        sb.append(" AND ");
        sb.append(this.rightOperand).append(")");
        return sb.toString();
    }
}

