/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.classloader;

import com.navercorp.pinpoint.bootstrap.classloader.ClassLoaderFactory;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.List;

public class DynamicClassLoaderFactory
implements ClassLoaderFactory {
    private final Constructor<? extends ClassLoader> constructor;

    public DynamicClassLoaderFactory(String classLoaderName, ClassLoader classLoader) {
        this.constructor = DynamicClassLoaderFactory.getConstructor(classLoaderName, classLoader);
    }

    private static Constructor<? extends ClassLoader> getConstructor(String classLoaderName, ClassLoader classLoader) {
        try {
            Class<?> classLoaderClazz = Class.forName(classLoaderName, true, classLoader);
            return classLoaderClazz.getDeclaredConstructor(String.class, URL[].class, ClassLoader.class, List.class);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException(classLoaderName + " initialize fail Caused by:" + ex.getMessage(), ex);
        }
    }

    @Override
    public ClassLoader createClassLoader(String name, URL[] urls, ClassLoader parent, List<String> libClass) {
        try {
            return this.constructor.newInstance(name, urls, parent, libClass);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException(this.constructor + " invoke fail Caused by:" + ex.getMessage(), ex);
        }
    }
}

