/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.trace;

import io.cloudevents.CloudEvent;
import io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.eventmesh.runtime.trace.AttributeKeys;
import org.apache.eventmesh.runtime.trace.SpanKey;
import org.apache.eventmesh.trace.api.EventMeshTraceService;
import org.apache.eventmesh.trace.api.TracePluginFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trace {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Trace.class);
    private static final Map<String, Trace> TRACE_CACHE = new HashMap<String, Trace>(16);
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private EventMeshTraceService eventMeshTraceService;
    private boolean useTrace;

    public static Trace getInstance(String tracePluginType, boolean useTrace) {
        return TRACE_CACHE.computeIfAbsent(tracePluginType, key -> Trace.traceBuilder(tracePluginType, useTrace));
    }

    private static Trace traceBuilder(String tracePluginType, boolean useTrace) {
        Trace trace = new Trace();
        trace.useTrace = useTrace;
        trace.eventMeshTraceService = TracePluginFactory.getEventMeshTraceService((String)tracePluginType);
        return trace;
    }

    private Trace() {
    }

    public void init() throws Exception {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.eventMeshTraceService.init();
    }

    public Span createSpan(String spanName, SpanKind spanKind, long startTime, TimeUnit timeUnit, Context context, boolean isSpanFinishInOtherThread) {
        if (!this.useTrace) {
            return Span.getInvalid();
        }
        return this.eventMeshTraceService.createSpan(spanName, spanKind, startTime, timeUnit, context, isSpanFinishInOtherThread);
    }

    public Span createSpan(String spanName, SpanKind spanKind, Context context, boolean isSpanFinishInOtherThread) {
        if (!this.useTrace) {
            return Span.getInvalid();
        }
        return this.eventMeshTraceService.createSpan(spanName, spanKind, context, isSpanFinishInOtherThread);
    }

    public Context extractFrom(Context context, Map<String, Object> map) {
        if (!this.useTrace) {
            return null;
        }
        if (map == null) {
            return context;
        }
        return this.eventMeshTraceService.extractFrom(context, map);
    }

    public void inject(Context context, Map<String, Object> map) {
        if (!this.useTrace) {
            return;
        }
        if (context == null || map == null) {
            return;
        }
        this.eventMeshTraceService.inject(context, map);
    }

    public Span addTraceInfoToSpan(ChannelHandlerContext ctx, CloudEvent cloudEvent) {
        if (!this.useTrace) {
            return null;
        }
        Context context = (Context)ctx.channel().attr(AttributeKeys.SERVER_CONTEXT).get();
        Span span = context != null ? (Span)context.get(SpanKey.SERVER_KEY) : null;
        return this.addTraceInfoToSpan(span, cloudEvent);
    }

    public Span addTraceInfoToSpan(Span span, CloudEvent cloudEvent) {
        if (!this.useTrace) {
            return null;
        }
        if (span == null) {
            log.warn("span is null when finishSpan");
            return null;
        }
        if (cloudEvent == null) {
            return span;
        }
        Iterator iterator = cloudEvent.getExtensionNames().iterator();
        while (iterator.hasNext()) {
            String entry;
            span.setAttribute(entry, cloudEvent.getExtension(entry = (String)iterator.next()) == null ? "" : cloudEvent.getExtension(entry).toString());
        }
        return span;
    }

    public Span addTraceInfoToSpan(Span span, Map<String, Object> map) {
        if (!this.useTrace) {
            return null;
        }
        if (span == null) {
            log.warn("span is null when finishSpan");
            return null;
        }
        if (map == null || map.size() < 1) {
            return span;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            span.setAttribute(entry.getKey(), entry.getValue().toString());
        }
        return span;
    }

    public void finishSpan(ChannelHandlerContext ctx, StatusCode statusCode) {
        if (this.useTrace) {
            Context context = (Context)ctx.channel().attr(AttributeKeys.SERVER_CONTEXT).get();
            Span span = context != null ? (Span)context.get(SpanKey.SERVER_KEY) : null;
            this.finishSpan(span, statusCode);
        }
    }

    public void finishSpan(Span span, StatusCode statusCode) {
        try {
            if (this.useTrace) {
                if (span == null) {
                    log.warn("span is null when finishSpan");
                    return;
                }
                if (statusCode != null) {
                    span.setStatus(statusCode);
                }
                span.end();
            }
        }
        catch (Exception e) {
            log.error("finishSpan occur exception,", (Throwable)e);
        }
    }

    public void finishSpan(Span span, StatusCode statusCode, String errMsg, Throwable throwable) {
        try {
            if (this.useTrace) {
                if (span == null) {
                    log.warn("span is null when finishSpan");
                    return;
                }
                if (statusCode != null) {
                    span.setStatus(statusCode, errMsg);
                }
                if (throwable != null) {
                    span.recordException(throwable);
                }
                span.end();
            }
        }
        catch (Exception e) {
            log.error("finishSpan occur exception,", (Throwable)e);
        }
    }

    public void finishSpan(ChannelHandlerContext ctx, StatusCode statusCode, String errMsg, Throwable throwable) {
        if (this.useTrace) {
            Context context = (Context)ctx.channel().attr(AttributeKeys.SERVER_CONTEXT).get();
            Span span = context != null ? (Span)context.get(SpanKey.SERVER_KEY) : null;
            this.finishSpan(span, statusCode, errMsg, throwable);
        }
    }

    public void shutdown() throws Exception {
        if (this.useTrace && this.inited.compareAndSet(true, false)) {
            this.eventMeshTraceService.shutdown();
        }
    }
}

