/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.common.protocol.HeartbeatItem;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.common.ClientType;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatProcessor {
    private static final Logger ACL_LOGGER = LoggerFactory.getLogger((String)"acl");
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final Acl acl;

    public HeartbeatProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.acl = eventMeshGrpcServer.getAcl();
    }

    public void process(CloudEvent heartbeat, EventEmitter<CloudEvent> emitter) throws Exception {
        if (!ServiceUtils.validateCloudEventAttributes(heartbeat)) {
            ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_PROTOCOL_HEADER_ERR, emitter);
            return;
        }
        if (!ServiceUtils.validateHeartBeat(heartbeat)) {
            ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_PROTOCOL_BODY_ERR, emitter);
            return;
        }
        try {
            this.doAclCheck(heartbeat);
        }
        catch (AclException e) {
            ACL_LOGGER.warn("CLIENT HAS NO PERMISSION, HeartbeatProcessor failed", (Throwable)e);
            ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_ACL_ERR, e.getMessage(), emitter);
            return;
        }
        ClientType clientType = EventMeshCloudEventUtils.getClientType((CloudEvent)heartbeat);
        if (ClientType.SUB != clientType) {
            ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_PROTOCOL_BODY_ERR, emitter);
            return;
        }
        ConsumerManager consumerManager = this.eventMeshGrpcServer.getConsumerManager();
        String consumerGroup = EventMeshCloudEventUtils.getConsumerGroup((CloudEvent)heartbeat);
        String env = EventMeshCloudEventUtils.getEnv((CloudEvent)heartbeat);
        String idc = EventMeshCloudEventUtils.getIdc((CloudEvent)heartbeat);
        String sys = EventMeshCloudEventUtils.getSys((CloudEvent)heartbeat);
        String ip = EventMeshCloudEventUtils.getIp((CloudEvent)heartbeat);
        String pid = EventMeshCloudEventUtils.getPid((CloudEvent)heartbeat);
        List heartbeatItems = (List)JsonUtils.parseTypeReferenceObject((String)heartbeat.getTextData(), (TypeReference)new TypeReference<List<HeartbeatItem>>(){});
        Objects.requireNonNull(heartbeatItems, "heartbeatItems can't be null");
        for (HeartbeatItem item : heartbeatItems) {
            ConsumerGroupClient hbClient = ConsumerGroupClient.builder().env(env).idc(idc).sys(sys).ip(ip).pid(pid).consumerGroup(consumerGroup).topic(item.getTopic()).lastUpTime(new Date()).build();
            if (consumerManager.updateClientTime(hbClient)) continue;
            ServiceUtils.sendResponseCompleted(StatusCode.CLIENT_RESUBSCRIBE, emitter);
            return;
        }
        ServiceUtils.sendResponseCompleted(StatusCode.SUCCESS, "heartbeat success", emitter);
    }

    private void doAclCheck(CloudEvent heartbeat) throws AclException {
        if (this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().isEventMeshServerSecurityEnable()) {
            String remoteAdd = EventMeshCloudEventUtils.getIp((CloudEvent)heartbeat);
            String user = EventMeshCloudEventUtils.getUserName((CloudEvent)heartbeat);
            String pass = EventMeshCloudEventUtils.getPassword((CloudEvent)heartbeat);
            String sys = EventMeshCloudEventUtils.getSys((CloudEvent)heartbeat);
            int requestCode = RequestCode.HEARTBEAT.getRequestCode();
            List heartbeatItems = (List)JsonUtils.parseTypeReferenceObject((String)heartbeat.getTextData(), (TypeReference)new TypeReference<List<HeartbeatItem>>(){});
            for (HeartbeatItem item : heartbeatItems) {
                this.acl.doAclCheckInHttpHeartbeat(remoteAdd, user, pass, sys, item.getTopic(), requestCode);
            }
        }
    }
}

