/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.recommend.EventMeshRecommendImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/eventMesh/recommend")
public class QueryRecommendEventMeshHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryRecommendEventMeshHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public QueryRecommendEventMeshHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        String result = "";
        if (!this.eventMeshTCPServer.getEventMeshTCPConfiguration().isEventMeshServerMetaStorageEnable()) {
            throw new Exception("registry enable config is false, not support");
        }
        String queryString = URI.create(httpRequest.uri()).getQuery();
        Map queryStringInfo = NetUtils.formData2Dic((String)queryString);
        String group = (String)queryStringInfo.get("group");
        String purpose = (String)queryStringInfo.get("purpose");
        if (StringUtils.isBlank((CharSequence)group) || StringUtils.isBlank((CharSequence)purpose)) {
            result = "params illegal!";
            this.writeText(ctx, result);
            return;
        }
        EventMeshRecommendImpl eventMeshRecommendStrategy = new EventMeshRecommendImpl(this.eventMeshTCPServer);
        String recommendEventMeshResult = eventMeshRecommendStrategy.calculateRecommendEventMesh(group, purpose);
        result = recommendEventMeshResult == null ? "null" : recommendEventMeshResult;
        log.info("recommend eventmesh:{},group:{},purpose:{}", new Object[]{result, group, purpose});
        this.writeText(ctx, result);
    }
}

