/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.misc.LogHelper;

public class CommandsData
implements QueueCommand {
    private final List<CommandData<?, ?>> commands;
    private final List<CommandData<?, ?>> attachedCommands;
    private final CompletableFuture<Void> promise;
    private final boolean skipResult;
    private final boolean atomic;
    private final boolean queued;
    private final boolean syncSlaves;

    public CommandsData(CompletableFuture<Void> promise, List<CommandData<?, ?>> commands, boolean queued, boolean syncSlaves) {
        this(promise, commands, null, false, false, queued, syncSlaves);
    }

    public CommandsData(CompletableFuture<Void> promise, List<CommandData<?, ?>> commands, boolean skipResult, boolean atomic, boolean queued, boolean syncSlaves) {
        this(promise, commands, null, skipResult, atomic, queued, syncSlaves);
    }

    public CommandsData(CompletableFuture<Void> promise, List<CommandData<?, ?>> commands, List<CommandData<?, ?>> attachedCommands, boolean skipResult, boolean atomic, boolean queued, boolean syncSlaves) {
        this.promise = promise;
        this.commands = commands;
        this.skipResult = skipResult;
        this.atomic = atomic;
        this.attachedCommands = attachedCommands;
        this.queued = queued;
        this.syncSlaves = syncSlaves;
    }

    public boolean isSyncSlaves() {
        return this.syncSlaves;
    }

    public CompletableFuture<Void> getPromise() {
        return this.promise;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public boolean isSkipResult() {
        return this.skipResult;
    }

    public List<CommandData<?, ?>> getAttachedCommands() {
        return this.attachedCommands;
    }

    public List<CommandData<?, ?>> getCommands() {
        return this.commands;
    }

    @Override
    public List<CommandData<Object, Object>> getPubSubOperations() {
        ArrayList<CommandData<Object, Object>> result = new ArrayList<CommandData<Object, Object>>();
        for (CommandData<?, ?> commandData : this.commands) {
            if (!RedisCommands.PUBSUB_COMMANDS.contains(commandData.getCommand().getName())) continue;
            result.add(commandData);
        }
        return result;
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        return this.promise.completeExceptionally(cause);
    }

    public String toString() {
        return "CommandsData{commands=" + LogHelper.toString(this.commands) + ", promise=" + this.promise + ", skipResult=" + this.skipResult + ", atomic=" + this.atomic + ", queued=" + this.queued + ", syncSlaves=" + this.syncSlaves + '}';
    }

    @Override
    public boolean isExecuted() {
        return this.promise.isDone();
    }

    @Override
    public boolean isBlockingCommand() {
        return false;
    }
}

