/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.util.Timeout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.redisson.RedissonBaseLock;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RFuture;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.Hash;
import org.redisson.pubsub.LockPubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonFasterMultiLock
extends RedissonBaseLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedissonFasterMultiLock.class);
    protected long internalLockLeaseTime;
    private final LockPubSub pubSub;
    private final CommandAsyncExecutor commandExecutor;
    private final String key;
    private final Collection<String> fields;

    public RedissonFasterMultiLock(CommandAsyncExecutor commandExecutor, String group, Collection<Object> values) {
        super(commandExecutor, group);
        this.commandExecutor = commandExecutor;
        this.pubSub = commandExecutor.getConnectionManager().getSubscribeService().getLockPubSub();
        this.internalLockLeaseTime = this.getServiceManager().getCfg().getLockWatchdogTimeout();
        this.key = group;
        this.fields = this.hashValues(values);
    }

    private Collection<String> hashValues(Collection<Object> values) {
        return values.stream().map(this::hashValue).collect(Collectors.toSet());
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        this.lock(leaseTime, unit, true);
    }

    @Override
    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        long time = unit.toMillis(waitTime);
        long current = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        Long ttl = this.tryAcquire(leaseTime, unit, threadId);
        if (ttl == null) {
            return true;
        }
        if ((time -= System.currentTimeMillis() - current) <= 0L) {
            this.acquireFailed(waitTime, unit, threadId);
            return false;
        }
        current = System.currentTimeMillis();
        CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe();
        try {
            subscribeFuture.get(time, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            if (!subscribeFuture.completeExceptionally(new RedisTimeoutException("Unable to acquire subscription lock after " + time + "ms. Try to increase 'subscriptionsPerConnection' and/or 'subscriptionConnectionPoolSize' parameters."))) {
                subscribeFuture.whenComplete((res, ex) -> {
                    if (ex == null) {
                        this.unsubscribe((RedissonLockEntry)res);
                    }
                });
            }
            this.acquireFailed(waitTime, unit, threadId);
            return false;
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.acquireFailed(waitTime, unit, threadId);
            return false;
        }
        try {
            if ((time -= System.currentTimeMillis() - current) <= 0L) {
                this.acquireFailed(waitTime, unit, threadId);
                boolean e = false;
                return e;
            }
            while (true) {
                long currentTime = System.currentTimeMillis();
                ttl = this.tryAcquire(leaseTime, unit, threadId);
                if (ttl == null) {
                    boolean bl = true;
                    return bl;
                }
                if ((time -= System.currentTimeMillis() - currentTime) <= 0L) {
                    this.acquireFailed(waitTime, unit, threadId);
                    boolean bl = false;
                    return bl;
                }
                currentTime = System.currentTimeMillis();
                if (ttl >= 0L && ttl < time) {
                    this.commandExecutor.getNow(subscribeFuture).getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                } else {
                    this.commandExecutor.getNow(subscribeFuture).getLatch().tryAcquire(time, TimeUnit.MILLISECONDS);
                }
                if ((time -= System.currentTimeMillis() - currentTime) > 0L) continue;
                this.acquireFailed(waitTime, unit, threadId);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.unsubscribe(this.commandExecutor.getNow(subscribeFuture));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String hashValue(Object key) {
        ByteBuf objectState = this.encode(key);
        try {
            String string = Hash.hash128toBase64(objectState);
            return string;
        }
        finally {
            objectState.release();
        }
    }

    @Override
    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lock(leaseTime, unit, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(long leaseTime, TimeUnit unit, boolean interruptible) throws InterruptedException {
        long threadId = Thread.currentThread().getId();
        Long ttl = this.tryAcquire(leaseTime, unit, threadId);
        if (ttl == null) {
            return;
        }
        CompletableFuture<RedissonLockEntry> future = this.subscribe();
        this.pubSub.timeout((CompletableFuture)future);
        RedissonLockEntry entry = interruptible ? this.commandExecutor.getInterrupted(future) : this.commandExecutor.get(future);
        try {
            while ((ttl = this.tryAcquire(leaseTime, unit, threadId)) != null) {
                if (ttl >= 0L) {
                    try {
                        entry.getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        if (interruptible) {
                            throw e;
                        }
                        entry.getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                    }
                    continue;
                }
                if (interruptible) {
                    entry.getLatch().acquire();
                    continue;
                }
                entry.getLatch().acquireUninterruptibly();
            }
        }
        finally {
            this.unsubscribe(entry);
        }
    }

    protected void unsubscribe(RedissonLockEntry entry) {
        this.pubSub.unsubscribe(entry, this.getEntryName(), this.getChannelName());
    }

    protected CompletableFuture<RedissonLockEntry> subscribe() {
        return this.pubSub.subscribe(this.getEntryName(), this.getChannelName());
    }

    String getChannelName() {
        return RedissonFasterMultiLock.prefixName("redisson_lock__channel", this.getRawName());
    }

    private RFuture<Long> tryAcquireAsync(long leaseTime, TimeUnit unit, long threadId) {
        RFuture<Long> ttlRemainingFuture = leaseTime > 0L ? this.tryLockInnerAsync(leaseTime, unit, threadId) : this.tryLockInnerAsync(this.internalLockLeaseTime, TimeUnit.MILLISECONDS, threadId);
        CompletionStage<Long> s = this.handleNoSync(threadId, ttlRemainingFuture);
        ttlRemainingFuture = new CompletableFutureWrapper<Long>(s);
        CompletionStage<Long> f = ttlRemainingFuture.thenApply(ttlRemaining -> {
            if (ttlRemaining == null) {
                if (leaseTime > 0L) {
                    this.internalLockLeaseTime = unit.toMillis(leaseTime);
                } else {
                    this.scheduleExpirationRenewal(threadId);
                }
            }
            return ttlRemaining;
        });
        return new CompletableFutureWrapper<Long>(f);
    }

    private Long tryAcquire(long leaseTime, TimeUnit unit, long threadId) {
        return this.get(this.tryAcquireAsync0(leaseTime, unit, threadId));
    }

    private RFuture<Long> tryAcquireAsync0(long leaseTime, TimeUnit unit, long threadId) {
        return this.getServiceManager().execute(() -> this.tryAcquireAsync(leaseTime, unit, threadId));
    }

    private RFuture<Boolean> tryAcquireOnceAsync(long leaseTime, TimeUnit unit, long threadId) {
        CompletionStage<Boolean> acquiredFuture = leaseTime > 0L ? this.tryLockOnceInnerAsync(leaseTime, unit, RedisCommands.EVAL_BOOLEAN, threadId) : this.tryLockOnceInnerAsync(this.internalLockLeaseTime, TimeUnit.MILLISECONDS, RedisCommands.EVAL_BOOLEAN, threadId);
        acquiredFuture = this.handleNoSync(threadId, acquiredFuture);
        CompletionStage<Boolean> f = acquiredFuture.thenApply(acquired -> {
            if (acquired.booleanValue()) {
                if (leaseTime > 0L) {
                    this.internalLockLeaseTime = unit.toMillis(leaseTime);
                } else {
                    this.scheduleExpirationRenewal(threadId);
                }
            }
            return acquired;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    protected CompletionStage<Boolean> renewExpirationAsync(long threadId) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getLockName(threadId));
        params.add(this.internalLockLeaseTime);
        params.add(System.currentTimeMillis());
        params.addAll(this.fields);
        return this.commandExecutor.syncedEval(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local leaseTime = tonumber(ARGV[2]);local currentTime = tonumber(ARGV[3]);local currentThread = ARGV[1];if (redis.call('exists',KEYS[1]) > 0) then   local newExpireTime = leaseTime + currentTime;   for i=4, #ARGV, 1 do        local lockThread = redis.call('hget', KEYS[1], ARGV[i]);       if(lockThread ~= false and lockThread == currentThread) then            local expireFieldName = ARGV[i]..':'..lockThread..':expire_time';           local expireTime = redis.call('hget', KEYS[1], expireFieldName);           if(tonumber(expireTime) < newExpireTime) then                redis.call('hset', KEYS[1],expireFieldName, newExpireTime);           end;       else           return 0;       end;   end;    local expireTime = redis.call('pttl',KEYS[1]);   if(tonumber(expireTime) < tonumber(leaseTime)) then        redis.call('pexpire',KEYS[1], leaseTime);   end;   return 1;end;return 0;", Collections.singletonList(this.getRawName()), params.toArray());
    }

    private <T> RFuture<T> tryLockOnceInnerAsync(long leaseTime, TimeUnit unit, RedisStrictCommand<T> command, long threadId) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(String.valueOf(System.currentTimeMillis()));
        params.add(String.valueOf(unit.toMillis(leaseTime)));
        params.add(this.getLockName(threadId));
        params.addAll(this.fields);
        return this.commandExecutor.syncedEval(this.key, StringCodec.INSTANCE, command, "local currentTime = tonumber(ARGV[1]);local leaseTime = tonumber(ARGV[2]);local currentThread = ARGV[3];local keyExist = nil;if (redis.call('exists',KEYS[1]) > 0) then   keyExist = 1;   for i=4, #ARGV, 1 do        local lockThread = redis.call('hget', KEYS[1], ARGV[i]);        if(lockThread ~= false and currentThread ~= lockThread ) then            local expireFieldName = ARGV[i]..':'..lockThread..':expire_time'           local expireTime = redis.call('hget', KEYS[1], expireFieldName);           if( tonumber(expireTime) > currentTime and currentThread ~= lockThread) then                return 0;           end       end;    end; else   keyExist = 0;end;for i=4, #ARGV, 1 do    redis.call('hset', KEYS[1], ARGV[i], currentThread);    local expireFieldName = ARGV[i]..':'..currentThread..':expire_time'   local expireTime = redis.call('hget', KEYS[1], expireFieldName);    local newExpireTime = leaseTime + currentTime    if(expireTime == false or tonumber(expireTime) < newExpireTime ) then      redis.call('hset', KEYS[1], expireFieldName, newExpireTime);    end;   redis.call('HINCRBY', KEYS[1], ARGV[i]..':'..currentThread..':lock_count', 1); end; if(keyExist == 1) then   local expireTime = redis.call('pttl',KEYS[1]);   if(tonumber(expireTime) > 0 and leaseTime > tonumber(expireTime)) then       redis.call('pexpire',KEYS[1], leaseTime);   end;else    redis.call('pexpire',KEYS[1], leaseTime);end;return 1;", Collections.singletonList(this.getRawName()), params.toArray());
    }

    private RFuture<Long> tryLockInnerAsync(long leaseTime, TimeUnit unit, long threadId) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(String.valueOf(unit.toMillis(leaseTime)));
        params.add(String.valueOf(System.currentTimeMillis()));
        params.add(this.getLockName(threadId));
        params.addAll(this.fields);
        return this.commandExecutor.syncedEval(this.key, StringCodec.INSTANCE, RedisCommands.EVAL_LONG, "local leaseTime = tonumber(ARGV[1]);local currentTime = tonumber(ARGV[2]);local currentThread = ARGV[3];local maxExpireTime = -1;local keyExist = nil;if (tonumber(redis.call('exists',KEYS[1])) > 0) then   keyExist = 1;   for i=4, #ARGV, 1 do        local lockThread = redis.call('hget', KEYS[1], ARGV[i]);        if(lockThread ~= false and lockThread ~= currentThread) then            local expireFieldName = ARGV[i]..':'..lockThread..':expire_time';           local expireTime = redis.call('hget', KEYS[1], expireFieldName);           if(expireTime ~= false and tonumber(expireTime) > currentTime ) then                if(tonumber(expireTime) > maxExpireTime) then                   maxExpireTime = tonumber(expireTime);               end;           end       end;    end; else   keyExist = 0;end;if( maxExpireTime ~= -1) then   return maxExpireTime-currentTime;end;for i=4, #ARGV, 1 do    redis.call('hset', KEYS[1], ARGV[i], currentThread);    local expireFieldName = ARGV[i]..':'..currentThread..':expire_time'   local expireTime = redis.call('hget', KEYS[1], expireFieldName);    local newExpireTime = leaseTime + currentTime    if(expireTime == false or tonumber(expireTime) < newExpireTime ) then      redis.call('hset', KEYS[1], expireFieldName, newExpireTime);    end;   redis.call('HINCRBY', KEYS[1], ARGV[i]..':'..currentThread..':lock_count', 1); end; if(keyExist == 1) then   local expireTime = redis.call('pttl',KEYS[1]);   if(tonumber(expireTime) > 0 and leaseTime > tonumber(expireTime)) then       redis.call('pexpire',KEYS[1], leaseTime);   end;else    redis.call('pexpire',KEYS[1], leaseTime);end;return nil;", Collections.singletonList(this.getRawName()), params.toArray());
    }

    @Override
    public boolean forceUnlock() {
        return this.get(this.forceUnlockAsync());
    }

    @Override
    public boolean isLocked() {
        return this.get(this.isLockedAsync());
    }

    @Override
    public boolean isHeldByThread(long threadId) {
        return this.get(this.isHeldByThreadAsync(threadId));
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.isHeldByThread(Thread.currentThread().getId());
    }

    @Override
    public int getHoldCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long remainTimeToLive() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void lock() {
        try {
            this.lock(-1L, null, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected RFuture<Boolean> unlockInnerAsync(long threadId, String requestId, int timeout) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getLockName(threadId));
        params.add(LockPubSub.UNLOCK_MESSAGE);
        params.add(this.internalLockLeaseTime);
        params.add(this.getSubscribeService().getPublishCommand());
        params.add(timeout);
        params.add(System.currentTimeMillis());
        params.addAll(this.fields);
        return this.commandExecutor.syncedEval(this.getRawName(), StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local val = redis.call('get', KEYS[3]); if val ~= false then    return tonumber(val);end; if(redis.call('exists', KEYS[1]) == 0) then   redis.call(ARGV[4], KEYS[2], ARGV[2]);    return nil;end;local lockName = ARGV[1];local hasFailed = 0;local allDeleted = 1;local hasDeleted = 0;local newExpireTime = tonumber(ARGV[3]) + tonumber(ARGV[6]);for i = 7,#ARGV,1 do   local expireTime = redis.call('hget', KEYS[1], ARGV[i]..':'..lockName..':expire_time');   if (expireTime ~= false and tonumber(expireTime) >= tonumber(ARGV[6])) then       if(tonumber(redis.call('hincrby', KEYS[1], ARGV[i]..':'..lockName..':lock_count',-1)) <= 0) then           redis.call('hdel',KEYS[1], ARGV[i]..':'..lockName..':expire_time');           redis.call('hdel',KEYS[1], ARGV[i]..':'..lockName..':lock_count');           redis.call('hdel',KEYS[1], ARGV[i]);           hasDeleted = 1;       else           if(tonumber(expireTime) < newExpireTime) then                redis.call('hset', KEYS[1], ARGV[i]..':'..lockName..':expire_time', newExpireTime);           end;           allDeleted = 0;       end;   else       allDeleted = 0;       hasFailed = 1;   end;end;if(hasFailed ~= 0) then   return nil;end;if(hasDeleted) then   redis.call(ARGV[4], KEYS[2], ARGV[2]); end;if(allDeleted == 1) then   redis.call('set', KEYS[3], 1, 'px', ARGV[5]); else    redis.call('set', KEYS[3], 0, 'px', ARGV[5]);    local expireTime = redis.call('pttl',KEYS[1]);   if(tonumber(ARGV[3]) > tonumber(expireTime)) then       redis.call('pexpire',KEYS[1], ARGV[3]);   end;end;return allDeleted;", Arrays.asList(this.getRawName(), this.getChannelName(), this.getUnlockLatchName(requestId)), params.toArray());
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock(-1L, null, false);
    }

    @Override
    public boolean tryLock() {
        return this.get(this.tryLockAsync());
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryLock(waitTime, -1L, unit);
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        this.cancelExpirationRenewal(null, null);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(LockPubSub.UNLOCK_MESSAGE);
        params.add(this.getSubscribeService().getPublishCommand());
        params.addAll(this.fields);
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local removeCount = 0;for i=3, #ARGV, 1 do     local lockName = redis.call('hget', KEYS[1], ARGV[i]);     local count = redis.call('HDEL', KEYS[1], ARGV[i]);     redis.call('HDEL', KEYS[1], ARGV[i]..':'..lockName..':expire_time');     redis.call('HDEL', KEYS[1], ARGV[i]..':'..lockName..':lock_count');     removeCount = removeCount+count;end; redis.call(ARGV[2], KEYS[2], ARGV[1]); return removeCount; ", Arrays.asList(this.getRawName(), this.getChannelName()), params.toArray());
    }

    @Override
    public RFuture<Void> unlockAsync() {
        return this.unlockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Void> unlockAsync(long threadId) {
        return this.getServiceManager().execute(() -> this.unlockAsync0(threadId));
    }

    private RFuture<Void> unlockAsync0(long threadId) {
        RFuture<Boolean> future = this.unlockInnerAsync(threadId);
        CompletionStage<Void> f = future.handle((res, e) -> {
            this.cancelExpirationRenewal(threadId, (Boolean)res);
            if (e != null) {
                if (e instanceof CompletionException) {
                    throw (CompletionException)e;
                }
                throw new CompletionException((Throwable)e);
            }
            if (res == null) {
                IllegalMonitorStateException cause = new IllegalMonitorStateException("attempt to unlock lock, not locked by current thread by node id: " + this.id + " thread-id: " + threadId);
                throw new CompletionException(cause);
            }
            return null;
        });
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit, long currentThreadId) {
        CompletableFuture result = new CompletableFuture();
        RFuture<Long> ttlFuture = this.tryLockInnerAsync(leaseTime, unit, currentThreadId);
        ttlFuture.whenComplete((ttl, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (ttl == null) {
                if (!result.complete(null)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe();
            this.pubSub.timeout((CompletableFuture)subscribeFuture);
            subscribeFuture.whenComplete((res, ex) -> {
                if (ex != null) {
                    result.completeExceptionally((Throwable)ex);
                    return;
                }
                this.lockAsync(leaseTime, unit, (RedissonLockEntry)res, result, currentThreadId);
            });
        });
        return new CompletableFutureWrapper<Void>(result);
    }

    @Override
    public RFuture<Boolean> tryLockAsync() {
        return this.getServiceManager().execute(() -> this.tryAcquireOnceAsync(-1L, null, Thread.currentThread().getId()));
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long threadId) {
        return this.getServiceManager().execute(() -> this.tryAcquireOnceAsync(-1L, null, threadId));
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, TimeUnit unit) {
        return this.getServiceManager().execute(() -> this.tryLockAsync(waitTime, -1L, unit, Thread.currentThread().getId()));
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
        return this.getServiceManager().execute(() -> this.tryLockAsync(waitTime, leaseTime, unit, Thread.currentThread().getId()));
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit, long currentThreadId) {
        CompletableFuture result = new CompletableFuture();
        AtomicLong time = new AtomicLong(unit.toMillis(waitTime));
        long currentTime = System.currentTimeMillis();
        RFuture<Long> ttlFuture = this.tryAcquireAsync0(leaseTime, unit, currentThreadId);
        ttlFuture.whenComplete((ttl, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (ttl == null) {
                if (!result.complete(true)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            long el = System.currentTimeMillis() - currentTime;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.trySuccessFalse(currentThreadId, result);
                return;
            }
            long current = System.currentTimeMillis();
            AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
            CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe();
            this.pubSub.timeout((CompletableFuture)subscribeFuture, time.get());
            subscribeFuture.whenComplete((r, ex) -> {
                if (ex != null) {
                    result.completeExceptionally((Throwable)ex);
                    return;
                }
                if (futureRef.get() != null) {
                    ((Timeout)futureRef.get()).cancel();
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                this.tryLockAsync(time, leaseTime, unit, (RedissonLockEntry)r, result, currentThreadId);
            });
            if (!subscribeFuture.isDone()) {
                Timeout scheduledFuture = this.getServiceManager().newTimeout(timeout -> {
                    if (!subscribeFuture.isDone()) {
                        subscribeFuture.cancel(false);
                        this.trySuccessFalse(currentThreadId, result);
                    }
                }, time.get(), TimeUnit.MILLISECONDS);
                futureRef.set(scheduledFuture);
            }
        });
        return new CompletableFutureWrapper<Boolean>(result);
    }

    @Override
    public RFuture<Boolean> isHeldByThreadAsync(long threadId) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(String.valueOf(System.currentTimeMillis()));
        params.add(this.getLockName(threadId));
        params.addAll(this.fields);
        return this.commandExecutor.syncedEval(this.getRawName(), StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local currentTime = tonumber(ARGV[1]);local currentThread = ARGV[2];if (redis.call('exists',KEYS[1]) > 0) then   for i=4, #ARGV, 1 do        local expireTime = redis.call('hget', KEYS[1], ARGV[i]..':'..currentThread..':expire_time');        if(expireTime == false or tonumber(expireTime) < currentTime) then            return 0;       end;   end; else   return 0;end;return 1;", Collections.singletonList(this.getRawName()), params.toArray());
    }

    @Override
    public RFuture<Integer> getHoldCountAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> isLockedAsync() {
        ArrayList<String> params = new ArrayList<String>();
        params.add(String.valueOf(System.currentTimeMillis()));
        params.addAll(this.fields);
        return this.commandExecutor.syncedEval(this.getRawName(), StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local currentTime = tonumber(ARGV[1]);for i = 2,#ARGV,1 do   local localThread = redis.call('hget', KEYS[1], ARGV[i]);   if(localThread ~= false) then       local expireTime = redis.call('hget', KEYS[1], ARGV[i]..':'..localThread..':expire_time');       if (expireTime ~= false and tonumber(expireTime) >= currentTime) then           return 1;       end;   end;end;return 0;", Collections.singletonList(this.getRawName()), params.toArray());
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync() {
        throw new UnsupportedOperationException();
    }

    private void tryLockAsync(AtomicLong time, long leaseTime, TimeUnit unit, RedissonLockEntry entry, CompletableFuture<Boolean> result, long currentThreadId) {
        if (result.isDone()) {
            this.unsubscribe(entry);
            return;
        }
        if (time.get() <= 0L) {
            this.unsubscribe(entry);
            this.trySuccessFalse(currentThreadId, result);
            return;
        }
        long curr = System.currentTimeMillis();
        RFuture<Long> ttlFuture = this.tryLockInnerAsync(leaseTime, unit, currentThreadId);
        ttlFuture.whenComplete((ttl, e) -> {
            if (e != null) {
                this.unsubscribe(entry);
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (ttl == null) {
                this.unsubscribe(entry);
                if (!result.complete(true)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            long el = System.currentTimeMillis() - curr;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.unsubscribe(entry);
                this.trySuccessFalse(currentThreadId, result);
                return;
            }
            long current = System.currentTimeMillis();
            if (entry.getLatch().tryAcquire()) {
                this.tryLockAsync(time, leaseTime, unit, entry, result, currentThreadId);
            } else {
                AtomicBoolean executed = new AtomicBoolean();
                AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                Runnable listener = () -> {
                    executed.set(true);
                    if (futureRef.get() != null) {
                        ((Timeout)futureRef.get()).cancel();
                    }
                    long elapsed = System.currentTimeMillis() - current;
                    time.addAndGet(-elapsed);
                    this.tryLockAsync(time, leaseTime, unit, entry, result, currentThreadId);
                };
                entry.addListener(listener);
                long t = time.get();
                if (ttl >= 0L && ttl < time.get()) {
                    t = ttl;
                }
                if (!executed.get()) {
                    Timeout scheduledFuture = this.getServiceManager().newTimeout(timeout -> {
                        if (entry.removeListener(listener)) {
                            long elapsed = System.currentTimeMillis() - current;
                            time.addAndGet(-elapsed);
                            this.tryLockAsync(time, leaseTime, unit, entry, result, currentThreadId);
                        }
                    }, t, TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
    }

    private void lockAsync(long leaseTime, TimeUnit unit, RedissonLockEntry entry, CompletableFuture<Void> result, long currentThreadId) {
        RFuture<Long> ttlFuture = this.tryLockInnerAsync(leaseTime, unit, currentThreadId);
        ttlFuture.whenComplete((ttl, e) -> {
            if (e != null) {
                this.unsubscribe(entry);
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (ttl == null) {
                this.unsubscribe(entry);
                if (!result.complete(null)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            if (entry.getLatch().tryAcquire()) {
                this.lockAsync(leaseTime, unit, entry, result, currentThreadId);
            } else {
                AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                Runnable listener = () -> {
                    if (futureRef.get() != null) {
                        ((Timeout)futureRef.get()).cancel();
                    }
                    this.lockAsync(leaseTime, unit, entry, result, currentThreadId);
                };
                entry.addListener(listener);
                if (ttl >= 0L) {
                    Timeout scheduledFuture = this.getServiceManager().newTimeout(timeout -> {
                        if (entry.removeListener(listener)) {
                            this.lockAsync(leaseTime, unit, entry, result, currentThreadId);
                        }
                    }, (long)ttl, TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
    }
}

