/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.kafka.source.connector;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.mq.kafka.KafkaSourceConfig;
import org.apache.eventmesh.common.remote.offset.RecordOffset;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.common.remote.offset.kafka.KafkaRecordOffset;
import org.apache.eventmesh.common.remote.offset.kafka.KafkaRecordPartition;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class KafkaSourceConnector
implements Source {
    private KafkaSourceConfig sourceConfig;
    private KafkaConsumer<String, String> kafkaConsumer;
    private long maxPollWaitTime;

    public Class<? extends Config> configClass() {
        return KafkaSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (KafkaSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (KafkaSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.sourceConfig.getConnectorConfig().getBootstrapServers());
        props.put("key.deserializer", this.sourceConfig.getConnectorConfig().getKeyConverter());
        props.put("value.deserializer", this.sourceConfig.getConnectorConfig().getValueConverter());
        props.put("group.id", this.sourceConfig.getConnectorConfig().getGroupID());
        props.put("enable.auto.commit", this.sourceConfig.getConnectorConfig().getEnableAutoCommit());
        props.put("max.poll.records", this.sourceConfig.getConnectorConfig().getMaxPollRecords());
        props.put("auto.commit.interval.ms", this.sourceConfig.getConnectorConfig().getAutoCommitIntervalMS());
        props.put("session.timeout.ms", this.sourceConfig.getConnectorConfig().getSessionTimeoutMS());
        this.maxPollWaitTime = this.sourceConfig.getPollConfig().getMaxWaitTime();
        this.kafkaConsumer = new KafkaConsumer(props);
    }

    public void start() throws Exception {
        this.kafkaConsumer.subscribe(Collections.singleton(this.sourceConfig.getConnectorConfig().getTopic()));
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        this.kafkaConsumer.unsubscribe();
    }

    public List<ConnectRecord> poll() {
        ConsumerRecords records = this.kafkaConsumer.poll(Duration.ofMillis(this.maxPollWaitTime));
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(records.count());
        for (ConsumerRecord record : records) {
            Long timestamp = System.currentTimeMillis();
            String key = (String)record.key();
            String value = (String)record.value();
            RecordPartition recordPartition = KafkaSourceConnector.convertToRecordPartition(record.topic(), record.partition());
            RecordOffset recordOffset = KafkaSourceConnector.convertToRecordOffset(record.offset());
            ConnectRecord connectRecord = new ConnectRecord(recordPartition, recordOffset, timestamp, (Object)value);
            connectRecord.addExtension("key", (Object)key);
            connectRecords.add(connectRecord);
        }
        this.kafkaConsumer.commitAsync();
        return connectRecords;
    }

    public static RecordOffset convertToRecordOffset(Long offset) {
        KafkaRecordOffset recordOffset = new KafkaRecordOffset();
        recordOffset.setOffset(offset);
        return recordOffset;
    }

    public static RecordPartition convertToRecordPartition(String topic, int partition) {
        KafkaRecordPartition recordPartition = new KafkaRecordPartition();
        recordPartition.setTopic(topic);
        recordPartition.setPartition(Integer.valueOf(partition));
        return recordPartition;
    }
}

