/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.remote.job;

import java.util.HashMap;
import java.util.Map;

public enum JobType {
    FULL,
    INCREASE,
    CHECK;

    private static final JobType[] STATES_NUM_INDEX;
    private static final Map<String, JobType> STATES_NAME_INDEX;

    public static JobType fromIndex(Integer index) {
        if (index == null || index < 0 || index > STATES_NUM_INDEX.length) {
            return null;
        }
        return STATES_NUM_INDEX[index];
    }

    public static JobType fromIndex(String index) {
        if (index == null || index.isEmpty()) {
            return null;
        }
        return STATES_NAME_INDEX.get(index);
    }

    static {
        STATES_NUM_INDEX = JobType.values();
        STATES_NAME_INDEX = new HashMap<String, JobType>();
        for (JobType jobType : STATES_NUM_INDEX) {
            STATES_NAME_INDEX.put(jobType.name(), jobType);
        }
    }
}

