/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.grpc;

import com.google.protobuf.StringValue;
import com.navercorp.pinpoint.common.profiler.message.RouteResult;
import com.navercorp.pinpoint.grpc.trace.PCmdMessage;
import com.navercorp.pinpoint.grpc.trace.PCmdRequest;
import com.navercorp.pinpoint.grpc.trace.PCmdResponse;
import com.navercorp.pinpoint.grpc.trace.ProfilerCommandServiceGrpc;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandService;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandServiceLocator;
import com.navercorp.pinpoint.profiler.receiver.grpc.ProfilerGrpcCommandService;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrpcCommandDispatcher {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ProfilerCommandServiceGrpc.ProfilerCommandServiceStub profilerCommandServiceStub;
    private final ProfilerCommandServiceLocator commandServiceLocator;

    public GrpcCommandDispatcher(ProfilerCommandServiceGrpc.ProfilerCommandServiceStub profilerCommandServiceStub, ProfilerCommandServiceLocator commandServiceLocator) {
        this.profilerCommandServiceStub = Objects.requireNonNull(profilerCommandServiceStub, "profilerCommandServiceStub");
        this.commandServiceLocator = Objects.requireNonNull(commandServiceLocator, "commandServiceLocator");
    }

    public void handle(PCmdRequest commandRequest, StreamObserver<PCmdMessage> streamObserver) {
        int value = commandRequest.getCommandCase().getNumber();
        ProfilerGrpcCommandService grpcCommandService = this.commandServiceLocator.getGrpcService((short)value);
        if (grpcCommandService != null) {
            try {
                grpcCommandService.handle(commandRequest, this.profilerCommandServiceStub);
            }
            catch (Exception e) {
                this.logger.warn("Failed to handle commandService. message:{}", (Object)e.getMessage(), (Object)e);
                PCmdResponse failMessage = this.createFailMessage(commandRequest, e.getMessage());
                if (streamObserver != null) {
                    streamObserver.onNext((Object)PCmdMessage.newBuilder().setFailMessage(failMessage).build());
                }
            }
        } else {
            PCmdResponse failMessage = this.createFailMessage(commandRequest, RouteResult.NOT_SUPPORTED_REQUEST.name());
            if (streamObserver != null) {
                streamObserver.onNext((Object)PCmdMessage.newBuilder().setFailMessage(failMessage).build());
            }
        }
    }

    private PCmdResponse createFailMessage(PCmdRequest commandRequest, String message) {
        PCmdResponse.Builder failMessage = PCmdResponse.newBuilder();
        failMessage.setResponseId(commandRequest.getRequestId());
        failMessage.setMessage(StringValue.of((String)message));
        return failMessage.build();
    }

    public Collection<Short> getSupportCommandServiceIdList() {
        return this.commandServiceLocator.getCommandServiceCodes();
    }

    public void close() {
        this.logger.info("close() started");
        Set<Short> commandServiceCodes = this.commandServiceLocator.getCommandServiceCodes();
        for (Short commandServiceCode : commandServiceCodes) {
            ProfilerCommandService service = this.commandServiceLocator.getService(commandServiceCode);
            if (!(service instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)service)).close();
            }
            catch (Exception e) {
                this.logger.warn("failed to close for CommandService:{}. message:{}", (Object)service, (Object)e.getMessage());
            }
        }
        this.logger.info("close() completed");
    }
}

