/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.transformer;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.ClassNameMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.MultiClassNameMatcher;
import com.navercorp.pinpoint.profiler.instrument.classreading.InternalClassMetadata;
import com.navercorp.pinpoint.profiler.instrument.transformer.TransformerRegistry;
import com.navercorp.pinpoint.profiler.plugin.MatchableClassFileTransformer;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.lang.instrument.ClassFileTransformer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultTransformerRegistry
implements TransformerRegistry {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Map<String, ClassFileTransformer> registry;

    public DefaultTransformerRegistry(List<MatchableClassFileTransformer> matchableClassFileTransformerList) {
        Objects.requireNonNull(matchableClassFileTransformerList, "matchableClassFileTransformerList");
        this.registry = this.newRegistry(matchableClassFileTransformerList);
    }

    private Map<String, ClassFileTransformer> newRegistry(List<MatchableClassFileTransformer> matchableClassFileTransformerList) {
        HashMap<String, ClassFileTransformer> registry = new HashMap<String, ClassFileTransformer>(512);
        for (MatchableClassFileTransformer transformer : matchableClassFileTransformerList) {
            try {
                this.addTransformer(registry, transformer.getMatcher(), transformer);
            }
            catch (Exception ex) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn("Failed to add transformer {}", (Object)transformer, (Object)ex);
            }
        }
        return registry;
    }

    @Override
    public ClassFileTransformer findTransformer(ClassLoader classLoader, String classInternalName, byte[] classFileBuffer) {
        return this.findTransformer(classLoader, classInternalName, classFileBuffer, null);
    }

    @Override
    public ClassFileTransformer findTransformer(ClassLoader classLoader, String classInternalName, byte[] classFileBuffer, InternalClassMetadata classMetadata) {
        return this.registry.get(classInternalName);
    }

    private void addTransformer(Map<String, ClassFileTransformer> registry, Matcher matcher, ClassFileTransformer transformer) {
        if (matcher instanceof ClassNameMatcher) {
            ClassNameMatcher classNameMatcher = (ClassNameMatcher)matcher;
            String className = classNameMatcher.getClassName();
            this.addModifier0(registry, transformer, className);
        } else if (matcher instanceof MultiClassNameMatcher) {
            MultiClassNameMatcher classNameMatcher = (MultiClassNameMatcher)matcher;
            List classNameList = classNameMatcher.getClassNames();
            for (String className : classNameList) {
                this.addModifier0(registry, transformer, className);
            }
        } else {
            throw new IllegalArgumentException("unsupported matcher :" + matcher);
        }
    }

    private void addModifier0(Map<String, ClassFileTransformer> registry, ClassFileTransformer transformer, String className) {
        String classInternalName = JavaAssistUtils.javaNameToJvmName(className);
        ClassFileTransformer old = registry.put(classInternalName, transformer);
        if (old != null) {
            throw new IllegalStateException("Transformer already exist. className:" + classInternalName + " new:" + transformer.getClass() + " old:" + old.getClass());
        }
    }
}

