/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.exception.model;

import com.navercorp.pinpoint.profiler.context.exception.ExceptionRecordingState;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionContext;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionContextValue;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionWrapper;
import com.navercorp.pinpoint.profiler.context.exception.sampler.ExceptionChainSampler;
import com.navercorp.pinpoint.profiler.context.exception.storage.ExceptionStorage;
import java.util.List;

public class DefaultExceptionContext
implements ExceptionContext {
    private static final long EMPTY_EXCEPTION_ID = Long.MIN_VALUE;
    private ExceptionChainSampler.SamplingState samplingState = ExceptionChainSampler.DISABLED;
    private final ExceptionStorage storage;
    private ExceptionContextValue topContextValue;

    public DefaultExceptionContext(ExceptionStorage storage) {
        this.storage = storage;
        this.topContextValue = new ExceptionContextValue();
    }

    @Override
    public void store(List<ExceptionWrapper> wrappers) {
        this.storage.store(wrappers);
    }

    @Override
    public void flush() {
        this.storage.flush();
    }

    @Override
    public void update(Throwable throwable, long startTime, ExceptionChainSampler.SamplingState samplingState) {
        this.samplingState = samplingState;
        if (throwable != null) {
            this.topContextValue = this.topContextValue.newChild(throwable, startTime);
        }
    }

    @Override
    public void cleanContext() {
        this.topContextValue = new ExceptionContextValue();
    }

    @Override
    public ExceptionRecordingState stateOf(Throwable throwable) {
        return ExceptionRecordingState.stateOf(this.topContextValue.getThrowable(), throwable);
    }

    @Override
    public boolean hasValidExceptionId() {
        return this.samplingState != null && this.samplingState.isSampling();
    }

    @Override
    public ExceptionContextValue getContextValue() {
        return this.topContextValue;
    }

    @Override
    public long getExceptionId() {
        if (this.samplingState != null) {
            return this.samplingState.currentId();
        }
        return Long.MIN_VALUE;
    }

    @Override
    public long getStartTime() {
        return this.topContextValue.getStartTime();
    }

    @Override
    public Throwable getPrevious() {
        return this.topContextValue.getThrowable();
    }

    @Override
    public ExceptionChainSampler.SamplingState getSamplingState() {
        return this.samplingState;
    }

    public void setSamplingState(ExceptionChainSampler.SamplingState samplingState) {
        this.samplingState = samplingState;
    }
}

