/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.source.connector;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.mq.rocketmq.RocketMQSourceConfig;
import org.apache.eventmesh.common.remote.offset.RecordOffset;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.common.remote.offset.rocketmq.RocketMQRecordOffset;
import org.apache.eventmesh.common.remote.offset.rocketmq.RocketMQRecordPartition;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetStorageReader;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.body.Connection;
import org.apache.rocketmq.common.protocol.body.ConsumerConnection;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQSourceConnector
implements Source,
ConnectorCreateService<Source> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocketMQSourceConnector.class);
    private RocketMQSourceConfig sourceConfig;
    private OffsetStorageReader offsetStorageReader;
    private DefaultMQAdminExt srcMQAdminExt;
    private final AllocateMessageQueueStrategy allocateMessageQueueStrategy = new AllocateMessageQueueAveragely();
    private final DefaultLitePullConsumer consumer = new DefaultLitePullConsumer();
    private final ScheduledExecutorService commitOffsetScheduleService = Executors.newSingleThreadScheduledExecutor();
    private final ConcurrentHashMap<MessageQueue, List<AtomicLong>> prepareCommitOffset = new ConcurrentHashMap();
    private final ConcurrentHashMap<MessageQueue, TreeMap<Long, MessageExt>> queue2Offsets = new ConcurrentHashMap();
    private final AtomicInteger unAckCounter = new AtomicInteger();

    public Class<? extends Config> configClass() {
        return RocketMQSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (RocketMQSourceConfig)config;
        this.consumer.setConsumerGroup(this.sourceConfig.getPubSubConfig().getGroup());
        this.consumer.setNamesrvAddr(this.sourceConfig.getConnectorConfig().getNameserver());
        this.consumer.setAutoCommit(false);
        this.consumer.setPullBatchSize(32);
        this.consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET);
        this.initAdmin();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (RocketMQSourceConfig)sourceConnectorContext.getSourceConfig();
        this.offsetStorageReader = sourceConnectorContext.getOffsetStorageReader();
        this.consumer.setConsumerGroup(this.sourceConfig.getPubSubConfig().getGroup());
        this.consumer.setNamesrvAddr(this.sourceConfig.getConnectorConfig().getNameserver());
        this.consumer.setAutoCommit(false);
        this.consumer.setPullBatchSize(32);
        this.consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET);
        this.consumer.setAllocateMessageQueueStrategy(this.allocateMessageQueueStrategy);
        this.initAdmin();
    }

    private synchronized void initAdmin() throws MQClientException {
        if (this.srcMQAdminExt == null) {
            this.srcMQAdminExt = new DefaultMQAdminExt();
            this.srcMQAdminExt.setNamesrvAddr(this.sourceConfig.getConnectorConfig().getNameserver());
            this.srcMQAdminExt.setAdminExtGroup("RocketMQ-Admin");
        }
    }

    public void start() throws Exception {
        this.consumer.start();
        this.srcMQAdminExt.start();
        this.execScheduleTask();
        Thread.sleep(1500L);
        List<MessageQueue> allocated = this.getAllocatedMessageQueue(this.sourceConfig.getConnectorConfig().getTopic(), this.sourceConfig.getPubSubConfig().getGroup());
        this.consumer.assign(allocated);
        this.consumer.setMessageQueueListener((topic, mqAll, mqDivided) -> {
            for (MessageQueue messageQueue : mqDivided) {
                try {
                    long pollOffset;
                    RocketMQRecordPartition recordPartition = new RocketMQRecordPartition();
                    recordPartition.setBroker(messageQueue.getBrokerName());
                    recordPartition.setTopic(messageQueue.getTopic());
                    recordPartition.setQueueId(messageQueue.getQueueId() + "");
                    RecordOffset recordOffset = this.offsetStorageReader.readOffset((RecordPartition)recordPartition);
                    log.info("assigned messageQueue {}, recordOffset {}", (Object)messageQueue, (Object)recordOffset);
                    if (recordOffset == null || (pollOffset = ((RocketMQRecordOffset)recordOffset).getQueueOffset().longValue()) == 0L) continue;
                    this.consumer.seek(messageQueue, pollOffset);
                }
                catch (MQClientException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private List<MessageQueue> getAllocatedMessageQueue(String topic, String group) throws MQBrokerException, RemotingException, InterruptedException, MQClientException {
        List<MessageQueue> mqAll = this.getMessageQueueList(topic);
        List<String> cidAll = this.getCidList(group);
        if (cidAll != null) {
            Collections.sort(mqAll);
            Collections.sort(cidAll);
            return this.allocateMessageQueueStrategy.allocate(group, this.consumer.buildMQClientId(), mqAll, cidAll);
        }
        return new ArrayList<MessageQueue>();
    }

    private List<String> getCidList(String group) throws MQBrokerException, RemotingException, InterruptedException, MQClientException {
        ConsumerConnection consumerConnection = this.srcMQAdminExt.examineConsumerConnectionInfo(group);
        return consumerConnection.getConnectionSet().stream().map(Connection::getClientId).collect(Collectors.toList());
    }

    private List<MessageQueue> getMessageQueueList(String topic) throws MQClientException {
        Collection messageQueueCollection = this.consumer.fetchMessageQueues(topic);
        return new ArrayList<MessageQueue>(messageQueueCollection);
    }

    public void commit(ConnectRecord record) {
        RocketMQRecordPartition rocketMQRecordPartition = (RocketMQRecordPartition)record.getPosition().getRecordPartition();
        String brokerName = rocketMQRecordPartition.getBroker();
        String topic = rocketMQRecordPartition.getTopic();
        int queueId = Integer.parseInt(rocketMQRecordPartition.getQueueId());
        MessageQueue mq = new MessageQueue(topic, brokerName, queueId);
        RocketMQRecordOffset rocketMQRecordOffset = (RocketMQRecordOffset)record.getPosition().getRecordOffset();
        long offset = rocketMQRecordOffset.getQueueOffset();
        long canCommitOffset = this.removeMessage(mq, offset);
        log.info("commit record {}|mq {}|canCommitOffset {}", new Object[]{record, mq, canCommitOffset});
        this.commitOffset(mq, canCommitOffset);
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        this.consumer.unsubscribe(this.sourceConfig.getConnectorConfig().getTopic());
        this.consumer.shutdown();
    }

    public List<ConnectRecord> poll() {
        List messageExts = this.consumer.poll();
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(messageExts.size());
        for (MessageExt messageExt : messageExts) {
            log.info("poll message {} from mq", (Object)messageExt);
            Long timestamp = System.currentTimeMillis();
            byte[] body = messageExt.getBody();
            String bodyStr = new String(body, StandardCharsets.UTF_8);
            RecordPartition recordPartition = RocketMQSourceConnector.convertToRecordPartition(messageExt.getTopic(), messageExt.getBrokerName(), messageExt.getQueueId());
            RecordOffset recordOffset = RocketMQSourceConnector.convertToRecordOffset(messageExt.getQueueOffset());
            ConnectRecord connectRecord = new ConnectRecord(recordPartition, recordOffset, timestamp, (Object)bodyStr);
            connectRecord.addExtension("topic", (Object)messageExt.getTopic());
            connectRecords.add(connectRecord);
            this.putPulledQueueOffset(messageExt);
        }
        return connectRecords;
    }

    public static RecordOffset convertToRecordOffset(Long offset) {
        RocketMQRecordOffset rocketMQRecordOffset = new RocketMQRecordOffset();
        rocketMQRecordOffset.setQueueOffset(offset);
        return rocketMQRecordOffset;
    }

    public static RecordPartition convertToRecordPartition(String topic, String brokerName, int queueId) {
        RocketMQRecordPartition rocketMQRecordPartition = new RocketMQRecordPartition();
        rocketMQRecordPartition.setBroker(brokerName);
        rocketMQRecordPartition.setTopic(topic);
        rocketMQRecordPartition.setQueueId(queueId + "");
        return rocketMQRecordPartition;
    }

    private void putPulledQueueOffset(MessageExt messageExt) {
        TreeMap newOffsets;
        MessageQueue mq = new MessageQueue(messageExt.getTopic(), messageExt.getBrokerName(), messageExt.getQueueId());
        TreeMap<Long, Object> offsets = this.queue2Offsets.get(mq);
        if (offsets == null && (offsets = this.queue2Offsets.putIfAbsent(mq, newOffsets = new TreeMap())) == null) {
            offsets = newOffsets;
        }
        offsets.put(messageExt.getQueueOffset(), messageExt);
        this.unAckCounter.incrementAndGet();
    }

    private long removeMessage(MessageQueue mq, long offset) {
        MessageExt prev;
        TreeMap<Long, MessageExt> offsets = this.queue2Offsets.get(mq);
        if (offsets != null && !offsets.isEmpty() && (prev = offsets.remove(offset)) != null) {
            this.unAckCounter.decrementAndGet();
        }
        return offset;
    }

    private void execScheduleTask() {
        this.commitOffsetScheduleService.scheduleAtFixedRate(this::commitOffsetSchedule, this.sourceConfig.connectorConfig.getCommitOffsetIntervalMs(), this.sourceConfig.connectorConfig.getCommitOffsetIntervalMs(), TimeUnit.MILLISECONDS);
    }

    private void commitOffsetSchedule() {
        this.prepareCommitOffset.forEach((messageQueue, list) -> {
            Iterator offsetIterator = list.iterator();
            while (offsetIterator.hasNext()) {
                HashMap<MessageQueue, Long> commitOffsetTable = new HashMap<MessageQueue, Long>();
                commitOffsetTable.put((MessageQueue)messageQueue, ((AtomicLong)offsetIterator.next()).get());
                this.consumer.commitSync(commitOffsetTable, false);
                offsetIterator.remove();
            }
        });
    }

    public void commitOffset(MessageQueue mq, long canCommitOffset) {
        if (canCommitOffset == -1L) {
            return;
        }
        long nextBeginOffset = canCommitOffset + 1L;
        List<AtomicLong> commitOffset = this.prepareCommitOffset.get(mq);
        if (commitOffset == null || commitOffset.isEmpty()) {
            commitOffset = new ArrayList<AtomicLong>();
        }
        commitOffset.add(new AtomicLong(nextBeginOffset));
        this.prepareCommitOffset.put(mq, commitOffset);
    }

    public Source create() {
        return new RocketMQSourceConnector();
    }
}

