/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.catalog.mysql;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.catalog.DefaultValueConvertor;
import org.apache.eventmesh.connector.jdbc.utils.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDefaultValueConvertorImpl
implements DefaultValueConvertor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MysqlDefaultValueConvertorImpl.class);
    private static final String EPOCH_DATE = "1970-01-01";
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\-?[0-9]*):([0-9]*)(:([0-9]*))?(\\.([0-9]*))?");
    private static final Set<JDBCType> NUMBER_DATA_TYPES = Collections.unmodifiableSet(new HashSet<JDBCType>(Arrays.asList(JDBCType.TINYINT, JDBCType.INTEGER, JDBCType.DATE, JDBCType.TIMESTAMP, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.TIME, JDBCType.BOOLEAN, JDBCType.BIT, JDBCType.NUMERIC, JDBCType.DECIMAL, JDBCType.FLOAT, JDBCType.DOUBLE, JDBCType.REAL)));
    private static final Set<JDBCType> BINARY_DATA_TYPES = Collections.unmodifiableSet(new HashSet<JDBCType>(Arrays.asList(JDBCType.BINARY, JDBCType.VARBINARY)));

    @Override
    public Object parseDefaultValue(Column<?> column, String defaultValueExpression) {
        if (defaultValueExpression == null) {
            return null;
        }
        defaultValueExpression = defaultValueExpression.trim();
        if (NUMBER_DATA_TYPES.contains(column.getJdbcType()) && StringUtils.equalsAnyIgnoreCase((CharSequence)defaultValueExpression, (CharSequence[])new CharSequence[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()})) {
            if (column.getJdbcType() == JDBCType.DECIMAL || column.getJdbcType() == JDBCType.NUMERIC) {
                return this.convert2Decimal(column, defaultValueExpression);
            }
            return StringUtils.equalsIgnoreCase((CharSequence)Boolean.TRUE.toString(), (CharSequence)defaultValueExpression) ? 1 : 0;
        }
        if (BINARY_DATA_TYPES.contains(column.getJdbcType()) && column.getDefaultValueExpression() != null) {
            String cleanedDefaultValueExpression = StringUtils.replace((String)column.getDefaultValueExpression(), (String)"\\0", (String)"");
            return ByteArrayUtils.bytesToHexString(cleanedDefaultValueExpression.getBytes(Constants.DEFAULT_CHARSET));
        }
        switch (column.getDataType().getSQLType()) {
            case DATE: {
                return this.convert2LocalDate(column, defaultValueExpression);
            }
            case TIMESTAMP: {
                return this.convertToLocalDateTime(column, defaultValueExpression);
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return this.convertToTimestamp(column, defaultValueExpression);
            }
            case TIME: {
                return this.convertToLocalTime(column, defaultValueExpression);
            }
            case BOOLEAN: {
                return this.convert2Boolean(column, defaultValueExpression);
            }
            case BIT: {
                return this.convertToBits(column, defaultValueExpression);
            }
            case NUMERIC: 
            case DECIMAL: {
                return this.convert2Decimal(column, defaultValueExpression);
            }
            case FLOAT: 
            case DOUBLE: 
            case REAL: {
                return Double.parseDouble(defaultValueExpression);
            }
        }
        return defaultValueExpression;
    }

    private Object convert2Boolean(Column<?> column, String value) {
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(value) != 0;
        }
        return Boolean.parseBoolean(value);
    }

    private Object convert2Decimal(Column<?> column, String value) {
        return Optional.ofNullable(column.getDecimal()).isPresent() ? new BigDecimal(value).setScale((int)column.getDecimal(), RoundingMode.HALF_UP) : new BigDecimal(value);
    }

    private Object convertToBits(Column<?> column, String value) {
        if (column.getColumnLength() > 1L) {
            int nums = value.length() / 8 + (value.length() % 8 == 0 ? 0 : 1);
            byte[] bytes = new byte[nums];
            int length = value.length();
            for (int i = 0; i < nums; ++i) {
                int size = value.length() - 8 < 0 ? 0 : value.length() - 8;
                bytes[nums - i - 1] = (byte)Integer.parseInt(value.substring(size, length), 2);
                value = value.substring(0, size);
            }
            return bytes;
        }
        return Short.parseShort(value) != 0;
    }

    private Object convertToLocalTime(Column<?> column, String value) {
        Matcher matcher = TIME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unexpected format for TIME column: " + value);
        }
        int hours = Integer.parseInt(matcher.group(1));
        int minutes = Integer.parseInt(matcher.group(2));
        String secondsGroup = matcher.group(4);
        int seconds = 0;
        int nanoSeconds = 0;
        if (secondsGroup != null) {
            seconds = Integer.parseInt(secondsGroup);
            String microSecondsString = matcher.group(6);
            if (microSecondsString != null) {
                nanoSeconds = Integer.parseInt(microSecondsString) * 1000;
            }
        }
        return LocalTime.of(hours, minutes, seconds, nanoSeconds);
    }

    private Object convertToTimestamp(Column<?> column, String value) {
        return null;
    }

    private Object convertToLocalDateTime(Column<?> column, String value) {
        if (StringUtils.containsAny((CharSequence)value, (CharSequence[])new CharSequence[]{"CURRENT_TIMESTAMP", "current_timestamp"})) {
            return value;
        }
        return LocalDateTime.from(this.timestampFormat(Optional.ofNullable(column.getColumnLength()).orElse(0L).intValue()).parse(value));
    }

    private Object convert2LocalDate(Column<?> column, String value) {
        try {
            if (StringUtils.contains((CharSequence)value, (CharSequence)"-")) {
                return LocalDate.parse(value);
            }
            if (StringUtils.isNumeric((CharSequence)value)) {
                return LocalDate.parse(value + "-01-01");
            }
            return LocalDate.from(this.dateFormat().parse(value));
        }
        catch (Exception e) {
            log.warn("Convert date error[value={}]", (Object)value);
            return LocalDate.parse(EPOCH_DATE);
        }
    }

    private DateTimeFormatter timestampFormat(int length) {
        DateTimeFormatterBuilder dtf = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").optionalStart().appendLiteral(" ").append(DateTimeFormatter.ISO_LOCAL_TIME).optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L);
        if (length > 0) {
            dtf.appendFraction(ChronoField.MICRO_OF_SECOND, 0, length, true);
        }
        return dtf.toFormatter();
    }

    private DateTimeFormatter dateFormat() {
        DateTimeFormatterBuilder dtf = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendValue(ChronoField.DAY_OF_YEAR, 2);
        return dtf.toFormatter();
    }
}

